/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_21_R3;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Biomes;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBiome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.main.TerraformGeneratorPlugin;

public class CustomBiomeHandler {
    public static final HashMap<CustomBiomeType, ResourceKey<BiomeBase>> terraformGenBiomeRegistry = new HashMap();

    public static IRegistry<BiomeBase> getBiomeRegistry() {
        return (IRegistry)MinecraftServer.getServer().ba().a(Registries.aI).orElseThrow();
    }

    public static void init() {
        CraftServer craftserver = (CraftServer)Bukkit.getServer();
        DedicatedServer dedicatedserver = craftserver.getServer();
        IRegistryWritable registrywritable = (IRegistryWritable)CustomBiomeHandler.getBiomeRegistry();
        try {
            Field frozen = RegistryMaterials.class.getDeclaredField("l");
            frozen.setAccessible(true);
            frozen.set(registrywritable, false);
            TerraformGeneratorPlugin.logger.info("Unfreezing biome registry...");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            TerraformGeneratorPlugin.logger.stackTrace(e1);
        }
        Holder.c forestbiome = registrywritable.p().b(Biomes.i);
        for (CustomBiomeType type : CustomBiomeType.values()) {
            if (type == CustomBiomeType.NONE) continue;
            try {
                assert (forestbiome != null);
                CustomBiomeHandler.registerCustomBiomeBase(type, dedicatedserver, (IRegistryWritable<BiomeBase>)registrywritable, (Holder<BiomeBase>)forestbiome);
                TerraformGeneratorPlugin.logger.info("Registered custom biome: " + type.toString().toLowerCase(Locale.ENGLISH));
            }
            catch (Throwable e2) {
                TerraformGeneratorPlugin.logger.error("Failed to register custom biome: " + type.getKey());
                TerraformGeneratorPlugin.logger.stackTrace(e2);
            }
        }
        try {
            Field frozen = RegistryMaterials.class.getDeclaredField("l");
            frozen.setAccessible(true);
            frozen.set(registrywritable, true);
            TerraformGeneratorPlugin.logger.info("Freezing biome registry");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            TerraformGeneratorPlugin.logger.stackTrace(e1);
        }
    }

    private static void registerCustomBiomeBase(@NotNull CustomBiomeType biomeType, DedicatedServer dedicatedserver, @NotNull IRegistryWritable<BiomeBase> registrywritable, @NotNull Holder<BiomeBase> forestBiomeHolder) throws Throwable {
        BiomeBase forestbiome = (BiomeBase)forestBiomeHolder.a();
        Field defaultRegInfoField = ReloadableServerRegistries.class.getDeclaredField("b");
        defaultRegInfoField.setAccessible(true);
        Object regInfo = defaultRegInfoField.get(null);
        ResourceKey newKey = ResourceKey.a((ResourceKey)Registries.aI, (MinecraftKey)MinecraftKey.a((String)"terraformgenerator", (String)biomeType.toString().toLowerCase(Locale.ENGLISH)));
        BiomeBase.a newBiomeBuilder = new BiomeBase.a();
        newBiomeBuilder.a(forestbiome.c());
        Field biomeSettingMobsField = BiomeBase.class.getDeclaredField("k");
        biomeSettingMobsField.setAccessible(true);
        BiomeSettingsMobs biomeSettingMobs = (BiomeSettingsMobs)biomeSettingMobsField.get(forestbiome);
        newBiomeBuilder.a(biomeSettingMobs);
        Field biomeSettingGenField = BiomeBase.class.getDeclaredField("j");
        biomeSettingGenField.setAccessible(true);
        BiomeSettingsGeneration biomeSettingGen = (BiomeSettingsGeneration)biomeSettingGenField.get(forestbiome);
        newBiomeBuilder.a(biomeSettingGen);
        newBiomeBuilder.a(0.7f);
        newBiomeBuilder.b(biomeType.getRainFall());
        if (biomeType.isCold()) {
            newBiomeBuilder.a(BiomeBase.TemperatureModifier.b);
        } else {
            newBiomeBuilder.a(BiomeBase.TemperatureModifier.a);
        }
        BiomeFog.a newFog = new BiomeFog.a();
        newFog.a(BiomeFog.GrassColor.a);
        newFog.a(biomeType.getFogColor().isEmpty() ? forestbiome.e() : Integer.parseInt(biomeType.getFogColor(), 16));
        newFog.b(biomeType.getWaterColor().isEmpty() ? forestbiome.i() : Integer.parseInt(biomeType.getWaterColor(), 16));
        newFog.c(biomeType.getWaterFogColor().isEmpty() ? forestbiome.j() : Integer.parseInt(biomeType.getWaterFogColor(), 16));
        newFog.d(biomeType.getSkyColor().isEmpty() ? forestbiome.a() : Integer.parseInt(biomeType.getSkyColor(), 16));
        newFog.e(biomeType.getFoliageColor().isEmpty() ? forestbiome.f() : Integer.parseInt(biomeType.getFoliageColor(), 16));
        newFog.f(biomeType.getGrassColor().isEmpty() ? Integer.parseInt("79C05A", 16) : Integer.parseInt(biomeType.getGrassColor(), 16));
        newBiomeBuilder.a(newFog.b());
        BiomeBase biome = newBiomeBuilder.a();
        if (registrywritable.p().a(newKey).isPresent() && ((Holder.c)registrywritable.p().a(newKey).get()).b()) {
            TerraformGeneratorPlugin.logger.info(String.valueOf(newKey) + " was already registered. Was there a plugin/server reload?");
            return;
        }
        Method register = registrywritable.getClass().getDeclaredMethod("a", ResourceKey.class, Object.class, Class.forName("net.minecraft.core.RegistrationInfo"));
        register.setAccessible(true);
        Holder.c holder = (Holder.c)register.invoke(registrywritable, newKey, biome, regInfo);
        Method bindValue = Holder.c.class.getDeclaredMethod("b", Object.class);
        bindValue.setAccessible(true);
        bindValue.invoke((Object)holder, biome);
        HashSet tags = new HashSet();
        forestBiomeHolder.c().forEach(tags::add);
        Method bindTags = Holder.c.class.getDeclaredMethod("a", Collection.class);
        bindTags.setAccessible(true);
        bindTags.invoke((Object)holder, tags);
        terraformGenBiomeRegistry.put(biomeType, (ResourceKey<BiomeBase>)newKey);
    }

    public static Set<Holder<BiomeBase>> biomeListToBiomeBaseSet(@NotNull IRegistry<BiomeBase> registry) {
        ArrayList biomeBases = new ArrayList();
        Registry.BIOME.iterator().forEachRemaining(biome -> {
            try {
                if (biome == null) {
                    return;
                }
                Holder holder = CraftBiome.bukkitToMinecraftHolder((Biome)biome);
                if (holder == null) {
                    return;
                }
                biomeBases.add(holder);
            }
            catch (Throwable e2) {
                TerraformGeneratorPlugin.logger.info("Ignoring biome " + String.valueOf(biome));
            }
        });
        for (CustomBiomeType cbt : CustomBiomeType.values()) {
            if (cbt == CustomBiomeType.NONE) continue;
            ResourceKey<BiomeBase> rkey = terraformGenBiomeRegistry.get((Object)cbt);
            Optional holder = registry.a(rkey);
            holder.ifPresent(biomeBases::add);
        }
        return Set.copyOf(biomeBases);
    }
}

