/*
 * Decompiled with CFR 0.152.
 */
package org.avarion.yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.avarion.yaml.Leniency;
import org.avarion.yaml.NestedMap;
import org.avarion.yaml.YamlComment;
import org.avarion.yaml.YamlFile;
import org.avarion.yaml.YamlKey;
import org.avarion.yaml.YamlMap;
import org.avarion.yaml.YamlWrapper;
import org.avarion.yaml.YamlWrapperFactory;
import org.avarion.yaml.exceptions.DuplicateKey;
import org.avarion.yaml.exceptions.FinalAttribute;
import org.avarion.yaml.exceptions.YamlException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class YamlFileInterface {
    static final Object UNKNOWN = new Object();
    private static final YamlWrapper yaml = YamlWrapperFactory.create();
    private static final Set<String> TRUE_VALUES = new HashSet<String>(Arrays.asList("yes", "y", "true", "1"));

    @Nullable
    private static Object getConvertedValue(@NotNull Field field, Object value, boolean isLenient) throws IOException {
        return YamlFileInterface.getConvertedValue(field, field.getType(), value, isLenient);
    }

    @Nullable
    private static Object getConvertedValue(@Nullable Field field, @NotNull Class<?> expectedType, Object value, boolean isLenient) throws IOException {
        if (value == null) {
            return YamlFileInterface.handleNullValue(expectedType, field);
        }
        if (expectedType.isEnum() && value instanceof String) {
            return YamlFileInterface.stringToEnum(expectedType, (String)value);
        }
        if (value instanceof List) {
            return YamlFileInterface.handleListValue(field, expectedType, (List)value, isLenient);
        }
        if (expectedType.isInstance(value)) {
            return value;
        }
        if (YamlFileInterface.isBooleanType(expectedType)) {
            return YamlFileInterface.convertToBoolean(value);
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            return YamlFileInterface.convertToNumber((Number)value, expectedType, isLenient);
        }
        if (YamlFileInterface.isCharacterType(expectedType)) {
            return YamlFileInterface.convertToCharacter(String.valueOf(value), isLenient);
        }
        try {
            Constructor<?> constructor = expectedType.getConstructor(String.class);
            return constructor.newInstance(value.toString());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            throw new IOException("'" + expectedType.getSimpleName() + "' doesn't accept a single String argument to create the object.");
        }
    }

    @Nullable
    private static Object handleNullValue(@NotNull Class<?> expectedType, Field field) throws IOException {
        if (expectedType.isPrimitive()) {
            String message = "Cannot assign null to primitive type " + expectedType.getSimpleName();
            if (field != null) {
                message = message + " (field: " + field.getName() + ")";
            }
            throw new IOException(message);
        }
        return null;
    }

    @NotNull
    private static Object handleListValue(@Nullable Field field, @NotNull Class<?> expectedType, List<?> list, boolean isLenient) throws IOException {
        Type genericType;
        if (!List.class.isAssignableFrom(expectedType)) {
            throw new IOException("Expected a List, but got " + expectedType.getSimpleName());
        }
        Class<Object> elementType = field != null ? ((genericType = field.getGenericType()) instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)genericType).getActualTypeArguments()[0] : Object.class) : Object.class;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : list) {
            Object convertedValue = YamlFileInterface.getConvertedValue(null, elementType, item, isLenient);
            result.add(convertedValue);
        }
        return result;
    }

    private static boolean isBooleanType(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    @NotNull
    private static Boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String strValue = value.toString().toLowerCase().trim();
        return TRUE_VALUES.contains(strValue);
    }

    private static Object convertToNumber(Number numValue, Class<?> expectedType, boolean isLenient) throws IOException {
        if (expectedType == Integer.TYPE || expectedType == Integer.class) {
            return numValue.intValue();
        }
        if (expectedType == Double.TYPE || expectedType == Double.class) {
            return numValue.doubleValue();
        }
        if (expectedType == Float.TYPE || expectedType == Float.class) {
            return Float.valueOf(YamlFileInterface.convertToFloat(numValue, isLenient));
        }
        if (expectedType == Long.TYPE || expectedType == Long.class) {
            return numValue.longValue();
        }
        if (expectedType == Short.TYPE || expectedType == Short.class) {
            return numValue.shortValue();
        }
        if (expectedType == Byte.TYPE || expectedType == Byte.class) {
            return numValue.byteValue();
        }
        throw new IOException("Cannot convert " + numValue.getClass().getSimpleName() + " to " + expectedType.getSimpleName());
    }

    private static float convertToFloat(@NotNull Number numValue, boolean isLenient) throws IOException {
        double doubleValue = numValue.doubleValue();
        if (!isLenient && Math.abs(doubleValue - (double)((float)doubleValue)) >= 1.0E-9) {
            throw new IOException("Double value " + doubleValue + " cannot be precisely represented as a float");
        }
        return numValue.floatValue();
    }

    private static boolean isCharacterType(Class<?> type) {
        return type == Character.TYPE || type == Character.class;
    }

    @NotNull
    private static Character convertToCharacter(@NotNull String value, boolean isLenient) throws IOException {
        if (value.length() == 1 || isLenient) {
            return Character.valueOf(value.charAt(0));
        }
        throw new IOException("Cannot convert String of length " + value.length() + " to Character");
    }

    @NotNull
    private static <E extends Enum<E>> E stringToEnum(Class<E> enumClass, @NotNull String value) {
        return Enum.valueOf(enumClass, value.toUpperCase());
    }

    public <T extends YamlFileInterface> T load(@NotNull File file) throws IOException {
        String content;
        if (!file.exists()) {
            this.save(file);
            return (T)this;
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            content = new String(inputStream.readAllBytes());
        }
        Map data = (Map)yaml.load(content);
        Class<?> clazz = this.getClass();
        YamlFile yamlFileAnnotation = clazz.getAnnotation(YamlFile.class);
        boolean isLenientByDefault = yamlFileAnnotation != null && yamlFileAnnotation.lenient() == Leniency.LENIENT;
        try {
            this.loadFields(data, isLenientByDefault);
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | FinalAttribute e2) {
            throw new IOException(e2);
        }
        return (T)this;
    }

    private void loadFields(Map<String, Object> data, boolean isLenientByDefault) throws FinalAttribute, IllegalAccessException, IOException {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                YamlKey keyAnnotation = field.getAnnotation(YamlKey.class);
                YamlMap mapAnnotation = field.getAnnotation(YamlMap.class);
                if (keyAnnotation != null && mapAnnotation != null) {
                    throw new IllegalStateException("Field " + field.getName() + " cannot have both @YamlKey and @YamlMap annotations");
                }
                if (keyAnnotation != null && !keyAnnotation.value().trim().isEmpty()) {
                    this.readYamlKeyField(data, field, keyAnnotation, isLenientByDefault);
                    continue;
                }
                if (mapAnnotation == null || mapAnnotation.value().trim().isEmpty()) continue;
                this.readYamlMapField(data, field, mapAnnotation);
            }
        }
    }

    public <T extends YamlFileInterface> T load(@NotNull String file) throws IOException {
        return this.load(new File(file));
    }

    @Nullable
    private static Object getNestedValue(@NotNull Map<String, Object> map, @NotNull String[] keys) {
        return YamlFileInterface.getNestedValue(map, new ArrayList<String>(Arrays.asList(keys)));
    }

    @Nullable
    private static Object getNestedValue(@NotNull Map<String, Object> map, @NotNull List<String> keys) {
        String key = keys.remove(0);
        if (!map.containsKey(key)) {
            return UNKNOWN;
        }
        Object tmp = map.get(key);
        if (keys.isEmpty()) {
            return tmp;
        }
        if (!(tmp instanceof Map)) {
            return UNKNOWN;
        }
        return YamlFileInterface.getNestedValue((Map<String, Object>)((Map)tmp), keys);
    }

    @NotNull
    private String buildYamlContents() throws IllegalAccessException, FinalAttribute, DuplicateKey {
        StringBuilder result = new StringBuilder();
        Class<?> clazz = this.getClass();
        YamlFile yamlFileAnnotation = clazz.getAnnotation(YamlFile.class);
        if (yamlFileAnnotation != null && !yamlFileAnnotation.header().trim().isEmpty()) {
            this.splitAndAppend(result, yamlFileAnnotation.header(), "", "# ");
            result.append("\n");
        }
        NestedMap nestedMap = new NestedMap();
        for (Field field : clazz.getDeclaredFields()) {
            YamlKey keyAnnotation = field.getAnnotation(YamlKey.class);
            YamlMap mapAnnotation = field.getAnnotation(YamlMap.class);
            if (keyAnnotation != null && !keyAnnotation.value().trim().isEmpty()) {
                if (Modifier.isFinal(field.getModifiers())) {
                    throw new FinalAttribute(field.getName());
                }
                Object value = field.get(this);
                YamlComment comment = field.getAnnotation(YamlComment.class);
                nestedMap.put(keyAnnotation.value(), comment == null ? null : comment.value(), value);
                continue;
            }
            if (mapAnnotation == null || mapAnnotation.value().trim().isEmpty()) continue;
            this.writeYamlMapField(nestedMap, this, field, mapAnnotation);
        }
        this.convertNestedMapToYaml(result, nestedMap.getMap(), 0);
        return result.toString();
    }

    private void splitAndAppend(@NotNull StringBuilder yaml, @Nullable String data, @NotNull String indentStr, @NotNull String extra) {
        if (data == null) {
            return;
        }
        for (String line : data.split("\\r?\\n")) {
            yaml.append(indentStr).append(extra).append(line.replace("\\s*$", "")).append("\n");
        }
    }

    private void convertNestedMapToYaml(StringBuilder yaml, @NotNull Map<String, Object> map, int indent) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            tmp.append("  ");
        }
        String indentStr = tmp.toString();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof NestedMap.NestedNode) {
                NestedMap.NestedNode node = (NestedMap.NestedNode)value;
                value = node.value;
                this.splitAndAppend(yaml, node.comment, indentStr, "# ");
            }
            yaml.append(indentStr).append(key).append(":");
            if (value instanceof Map) {
                yaml.append("\n");
                this.convertNestedMapToYaml(yaml, (Map)value, indent + 1);
                continue;
            }
            if (value instanceof List) {
                yaml.append("\n");
                for (Object item : (List)value) {
                    this.splitAndAppend(yaml, this.formatValue(item), indentStr + "  ", "- ");
                }
                continue;
            }
            yaml.append(' ').append(this.formatValue(value)).append('\n');
        }
    }

    @NotNull
    private String formatValue(Object value) {
        String yamlContent = yaml.dump(value).trim();
        if (value instanceof Enum) {
            yamlContent = yamlContent.replaceAll("^!!\\S+\\s+", "");
        }
        return yamlContent;
    }

    public void save(@NotNull File file) throws IOException {
        File newFile = file.getAbsoluteFile();
        newFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(newFile);){
            writer.write(this.buildYamlContents());
        }
        catch (IllegalAccessException | YamlException e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public void save(@NotNull String target) throws IOException {
        this.save(new File(target));
    }

    private void readYamlKeyField(Map<String, Object> data, @NotNull Field field, @NotNull YamlKey annotation, boolean isLenientByDefault) throws FinalAttribute, IllegalAccessException, IOException {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new FinalAttribute(field.getName());
        }
        String key = annotation.value();
        boolean isLenient = YamlFileInterface.isLenient(annotation.lenient(), isLenientByDefault);
        Object value = YamlFileInterface.getNestedValue(data, key.split("\\."));
        if (value != UNKNOWN) {
            field.set(this, YamlFileInterface.getConvertedValue(field, value, isLenient));
        }
    }

    @Contract(pure=true)
    private static boolean isLenient(@NotNull Leniency leniency, boolean isLenientByDefault) {
        switch (leniency) {
            case LENIENT: {
                return true;
            }
            case UNDEFINED: {
                return isLenientByDefault;
            }
        }
        return false;
    }

    private void readYamlMapField(Map<String, Object> data, @NotNull Field field, @NotNull YamlMap annotation) throws IllegalAccessException, FinalAttribute {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new FinalAttribute(field.getName());
        }
        String mapKey = annotation.value();
        Object mapValue = YamlFileInterface.getNestedValue(data, mapKey.split("\\."));
        if (mapValue == UNKNOWN || mapValue == null) {
            return;
        }
        try {
            Map fieldMap = (Map)mapValue;
            YamlMap.YamlMapProcessor<? extends YamlFileInterface> processor = annotation.processor().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            field.set(this, new LinkedHashMap());
            for (Map.Entry entry : fieldMap.entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                processor.read(this, (String)entry.getKey(), (Map)entry.getValue());
            }
        }
        catch (ClassCastException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            throw new IllegalStateException("Failed to instantiate YamlMapProcessor", e2);
        }
    }

    private void writeYamlMapField(NestedMap nestedMap, Object obj, @NotNull Field field, @NotNull YamlMap annotation) throws IllegalAccessException, DuplicateKey {
        String mapKey = annotation.value();
        Object fieldValue = field.get(obj);
        if (fieldValue instanceof Map) {
            try {
                YamlMap.YamlMapProcessor<? extends YamlFileInterface> processor = annotation.processor().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                HashMap<String, Map<String, Object>> processedMap = new HashMap<String, Map<String, Object>>();
                for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                    String key = entry.getKey().toString();
                    Map<String, Object> value = processor.write((YamlFileInterface)obj, key, entry.getValue());
                    processedMap.put(key, value);
                }
                nestedMap.put(mapKey, null, processedMap);
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                throw new IllegalStateException("Failed to instantiate YamlMapProcessor", e2);
            }
        }
    }
}

