/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.TreeDB;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class OasisBeach {
    public static final double oasisThreshold = (2.0 - TConfig.c.BIOME_OASIS_COMMONNESS) * 0.31;
    private static final float oasisFrequency = TConfig.c.BIOME_OASIS_FREQUENCY;

    public static float getOasisNoise(TerraformWorld world, int x, int z) {
        FastNoise lushRiversNoise = NoiseCacheHandler.getNoise(world, NoiseCacheHandler.NoiseCacheEntry.BIOME_DESERT_LUSH_RIVER, w -> {
            FastNoise n = new FastNoise((int)((double)w.getSeed() * 0.4));
            n.SetNoiseType(FastNoise.NoiseType.Cubic);
            n.SetFrequency(oasisFrequency);
            return n;
        });
        return lushRiversNoise.GetNoise(x, z);
    }

    private static boolean isOasisBeach(TerraformWorld tw, int x, int z, BiomeBank targetBiome) {
        double lushRiverNoiseValue = OasisBeach.getOasisNoise(tw, x, z);
        double riverDepth = HeightMap.getRawRiverDepth(tw, x, z);
        BiomeBank biome = BiomeBank.calculateHeightIndependentBiome(tw, x, z);
        return lushRiverNoiseValue > oasisThreshold && riverDepth > 0.0 && biome == targetBiome;
    }

    public static void generateOasisBeach(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data, int x, int z, BiomeBank targetBiome) {
        if (!OasisBeach.isOasisBeach(tw, x, z, targetBiome)) {
            return;
        }
        int y = GenUtils.getHighestGround(data, x, z);
        int aboveSea = y - TerraformGenerator.seaLevel;
        boolean isGrass = false;
        if (1.0 - (double)aboveSea / 8.0 > random.nextDouble() && y >= TerraformGenerator.seaLevel) {
            data.setType(x, y, z, Material.GRASS_BLOCK);
            isGrass = true;
        }
        if (y == TerraformGenerator.seaLevel && random.nextInt(3) == 0) {
            PlantBuilder.SUGAR_CANE.build(random, data, x, y + 1, z, 1, 4);
        } else if (y >= TerraformGenerator.seaLevel) {
            if (random.nextInt(8) == 0) {
                TreeDB.spawnCoconutTree(tw, data, x, y, z);
            } else if (random.nextInt(5) == 0) {
                OasisBeach.createBush(random, data, x, y, z, GenUtils.randDouble(random, 1.7, 3.0), GenUtils.randDouble(random, 2.0, 2.8), GenUtils.randDouble(random, 1.7, 3.0), Material.JUNGLE_LEAVES, Material.JUNGLE_LOG, 0.7);
            } else if (isGrass) {
                PlantBuilder.build(random, data, x, y + 1, z, PlantBuilder.GRASS, PlantBuilder.GRASS, PlantBuilder.GRASS, PlantBuilder.FERN);
            }
        }
    }

    public static void createBush(@NotNull Random random, @NotNull PopulatorDataAbstract data, int x, int y, int z, double xRadius, double yRadius, double zRadius, Material leaves, Material stem, double density) {
        if (!TConfig.arePlantsEnabled()) {
            return;
        }
        int ny = y;
        while ((double)ny < (double)y + yRadius / 2.0) {
            data.setType(x, ny, z, stem);
            ++ny;
        }
        int xr = (int)(-Math.ceil(xRadius));
        while ((double)xr < Math.ceil(xRadius)) {
            int yr = (int)(-Math.ceil(yRadius));
            while ((double)yr < Math.ceil(yRadius)) {
                int zr = (int)(-Math.ceil(zRadius));
                while ((double)zr < Math.ceil(zRadius)) {
                    double distToCenter = Math.sqrt((double)(xr * xr) / (xRadius * xRadius) + (double)(yr * yr) / (yRadius * yRadius) + (double)(zr * zr) / (zRadius * zRadius));
                    if (distToCenter < 1.0 && random.nextDouble() < 1.0 - distToCenter + density) {
                        data.lsetType(x + xr, y + yr, z + zr, leaves);
                    }
                    ++zr;
                }
                ++yr;
            }
            ++xr;
        }
    }
}

