/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cavepopulators;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.biome.cavepopulators.AbstractCaveClusterPopulator;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.MultipleFacingBuilder;
import org.terraform.utils.version.V_1_19;

public class DeepDarkClusterCavePopulator
extends AbstractCaveClusterPopulator {
    public DeepDarkClusterCavePopulator(float radius) {
        super(radius);
    }

    public static void oneUnit(TerraformWorld tw, @NotNull Random random, @NotNull SimpleBlock origin) {
        if (origin.isSolid()) {
            return;
        }
        new DeepDarkClusterCavePopulator(0.0f).oneUnit(tw, random, origin.findStonelikeCeiling(50), origin.findStonelikeFloor(50), false);
        origin.setType(Material.GLASS);
    }

    @Override
    public void oneUnit(TerraformWorld tw, @NotNull Random random, @Nullable SimpleBlock ceil, @Nullable SimpleBlock floor, boolean boundary) {
        MultipleFacing sculkVein;
        if (ceil == null || floor == null) {
            return;
        }
        if (ceil.getType() == V_1_19.SCULK || floor.getType() == V_1_19.SCULK) {
            return;
        }
        if (!BlockUtils.isWet(ceil.getDown())) {
            if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
                return;
            }
            if (BlockUtils.isStoneLike(ceil.getType())) {
                ceil.setType(V_1_19.SCULK);
            } else {
                sculkVein = (MultipleFacing)Bukkit.createBlockData((Material)V_1_19.SCULK_VEIN);
                sculkVein.setFace(BlockFace.UP, true);
                ceil.getDown().setBlockData((BlockData)sculkVein);
            }
        }
        if (BlockUtils.isWet(floor.getUp())) {
            return;
        }
        if (BlockUtils.isStoneLike(ceil.getType())) {
            floor.setType(V_1_19.SCULK);
        } else {
            sculkVein = (MultipleFacing)Bukkit.createBlockData((Material)V_1_19.SCULK_VEIN);
            sculkVein.setFace(BlockFace.DOWN, true);
            floor.getUp().setBlockData((BlockData)sculkVein);
        }
        if (GenUtils.chance(random, 1, 20)) {
            floor.getUp().setType(V_1_19.SCULK_CATALYST);
        } else if (GenUtils.chance(random, 1, 17)) {
            floor.getUp().setType(V_1_19.SCULK_SENSOR);
        } else if (GenUtils.chance(random, 1, 25)) {
            floor.getUp().setType(V_1_19.SCULK_SHRIEKER);
        }
        SimpleBlock target = floor;
        while (target.getY() != ceil.getY()) {
            for (BlockFace face : BlockUtils.directBlockFaces) {
                SimpleBlock rel = target.getRelative(face);
                if (!BlockUtils.isStoneLike(rel.getType())) continue;
                rel.setType(V_1_19.SCULK);
                if (!BlockUtils.isAir(target.getType()) || !GenUtils.chance(random, 1, 5)) continue;
                new MultipleFacingBuilder(V_1_19.SCULK_VEIN).setFace(face, true).apply(target);
            }
            target = target.getUp();
        }
        PopulatorDataICAAbstract populatorDataICAAbstract = TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData());
        if (populatorDataICAAbstract instanceof PopulatorDataICABiomeWriterAbstract) {
            PopulatorDataICABiomeWriterAbstract data = (PopulatorDataICABiomeWriterAbstract)populatorDataICAAbstract;
            while (floor.getY() < ceil.getY()) {
                data.setBiome(floor.getX(), floor.getY(), floor.getZ(), V_1_19.DEEP_DARK);
                floor = floor.getUp();
            }
        }
    }
}

