/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cavepopulators;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.cavepopulators.AbstractCaveClusterPopulator;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class DripstoneClusterCavePopulator
extends AbstractCaveClusterPopulator {
    public DripstoneClusterCavePopulator(float radius) {
        super(radius);
    }

    @Override
    protected void oneUnit(TerraformWorld tw, @NotNull Random random, @NotNull SimpleBlock ceil, @NotNull SimpleBlock floor, boolean boundary) {
        PopulatorDataICAAbstract populatorDataICAAbstract;
        int h2;
        int caveHeight = ceil.getY() - floor.getY();
        if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
            return;
        }
        ceil.setType(Material.DRIPSTONE_BLOCK);
        if (GenUtils.chance(random, 1, 4)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            if (h2 > 4) {
                h2 = 4;
            }
            BlockUtils.downLPointedDripstone(GenUtils.randInt(1, h2), ceil.getDown());
        }
        floor.setType(Material.DRIPSTONE_BLOCK);
        if (GenUtils.chance(random, 1, 4)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            if (h2 > 4) {
                h2 = 4;
            }
            BlockUtils.upLPointedDripstone(GenUtils.randInt(1, h2), floor.getUp());
        }
        if ((populatorDataICAAbstract = TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData())) instanceof PopulatorDataICABiomeWriterAbstract) {
            PopulatorDataICABiomeWriterAbstract data = (PopulatorDataICABiomeWriterAbstract)populatorDataICAAbstract;
            while (floor.getY() < ceil.getY()) {
                data.setBiome(floor.getX(), floor.getY(), floor.getZ(), Biome.DRIPSTONE_CAVES);
                floor = floor.getUp();
            }
        }
    }
}

