/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cavepopulators;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.cavepopulators.AbstractCavePopulator;
import org.terraform.biome.cavepopulators.MossyCavePopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.small_items.PlantBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;

public class ForestedMountainsCavePopulator
extends AbstractCavePopulator {
    @NotNull
    private final MossyCavePopulator mossyCavePop = new MossyCavePopulator();

    @Override
    public void populate(TerraformWorld tw, @NotNull Random random, @NotNull SimpleBlock ceil, @NotNull SimpleBlock floor) {
        if (ceil.getY() > TerraformGenerator.seaLevel && floor.getY() < TerraformGenerator.seaLevel && ceil.getAtY(TerraformGenerator.seaLevel).getType() == Material.WATER) {
            SimpleBlock at;
            int caveHeight = ceil.getY() - TerraformGenerator.seaLevel - 1;
            if (caveHeight <= 2) {
                return;
            }
            if (GenUtils.chance(random, 1, 100)) {
                new CylinderBuilder(random, floor.getRelative(0, (ceil.getY() - floor.getY()) / 2, 0), Material.STONE).setRadius(1.5f).setRY((float)(ceil.getY() - floor.getY()) / 2.0f + 3.0f).setHardReplace(false).build();
                return;
            }
            int glowBerryChance = 15;
            if (GenUtils.chance(random, 1, glowBerryChance)) {
                int h2 = caveHeight / 2;
                if (h2 > 6) {
                    h2 = 6;
                }
                BlockUtils.downLCaveVines(h2, ceil);
            }
            if (GenUtils.chance(random, 1, 30)) {
                PlantBuilder.SPORE_BLOSSOM.build(ceil);
            }
            if (GenUtils.chance(random, 1, 50) && !(at = ceil.getAtY(TerraformGenerator.seaLevel + 1)).isSolid()) {
                PlantBuilder.LILY_PAD.build(at);
            }
            if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
                return;
            }
            if (GenUtils.chance(random, 1, 20)) {
                CoralGenerator.generateSeaPickles(floor.getPopData(), floor.getX(), floor.getY() + 1, floor.getZ());
            }
            return;
        }
        this.mossyCavePop.populate(tw, random, ceil, floor);
    }
}

