/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cavepopulators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.cavepopulators.AbstractCaveClusterPopulator;
import org.terraform.biome.cavepopulators.AbstractCavePopulator;
import org.terraform.biome.cavepopulators.CaveClusterRegistry;
import org.terraform.biome.cavepopulators.DeepCavePopulator;
import org.terraform.biome.cavepopulators.EmptyCavePopulator;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.CoordPair;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MasterCavePopulatorDistributor {
    private static final HashSet<Class<?>> populatedBefore = new HashSet();

    public void populate(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data, boolean generateClusters) {
        HashMap clusters = generateClusters ? this.calculateClusterLocations(random, tw, data.getChunkX(), data.getChunkZ()) : new HashMap();
        ChunkCache cache = TerraformGenerator.getCache(tw, data.getChunkX(), data.getChunkZ());
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                BiomeBank bank = tw.getBiomeBank(x, z);
                int maxHeightForCaves = bank.getHandler().getMaxHeightForCaves(tw, x, z);
                CaveClusterRegistry reg = (CaveClusterRegistry)((Object)clusters.remove(new CoordPair(x, z)));
                Collection<CoordPair> pairs = MasterCavePopulatorDistributor.getCaveCeilFloors(data, x, z, 4, cache);
                int clusterPair = !pairs.isEmpty() ? random.nextInt(pairs.size()) : 0;
                for (CoordPair pair : pairs) {
                    if (pair.x() > maxHeightForCaves) continue;
                    SimpleBlock ceil = new SimpleBlock(data, x, pair.x(), z);
                    SimpleBlock floor = new SimpleBlock(data, x, pair.z(), z);
                    if (BlockUtils.amethysts.contains(floor.getType()) || BlockUtils.fluids.contains(floor.getUp().getType()) || BlockUtils.amethysts.contains(ceil.getDown().getType())) continue;
                    AbstractCavePopulator pop = floor.getY() < TerraformGeneratorPlugin.injector.getMinY() + 32 ? new DeepCavePopulator() : (clusterPair == 0 && reg != null && TConfig.c.FEATURE_CAVECLUSTERS_ENABLED ? reg.getPopulator(random) : bank.getCavePop());
                    --clusterPair;
                    if (!(pop instanceof AbstractCaveClusterPopulator) && !TConfig.c.FEATURE_CAVEDECORATORS_ENABLED) {
                        pop = new EmptyCavePopulator();
                    }
                    pop.populate(tw, random, ceil, floor);
                    if (!populatedBefore.add(pop.getClass())) continue;
                    TerraformGeneratorPlugin.logger.info("Spawning " + pop.getClass().getSimpleName() + " at " + String.valueOf(floor));
                }
            }
        }
    }

    @NotNull
    private HashMap<CoordPair, CaveClusterRegistry> calculateClusterLocations(@NotNull Random rand, @NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        HashMap<CoordPair, CaveClusterRegistry> locs = new HashMap<CoordPair, CaveClusterRegistry>();
        if (!TConfig.areCavesEnabled()) {
            return locs;
        }
        for (CaveClusterRegistry type : CaveClusterRegistry.values()) {
            CoordPair[] positions;
            for (CoordPair pos : positions = GenUtils.vectorRandomObjectPositions(tw.getHashedRand(chunkX, type.getHashSeed(), chunkZ).nextInt(9999999), chunkX, chunkZ, type.getSeparation(), type.getPertub())) {
                if (locs.containsKey(pos) && rand.nextBoolean()) continue;
                locs.put(pos, type);
            }
        }
        return locs;
    }

    @NotNull
    public static Collection<CoordPair> getCaveCeilFloors(PopulatorDataAbstract data, int x, int z, int minimumHeight, ChunkCache cache) {
        short y = cache.getTransformedHeight(x & 0xF, z & 0xF);
        int INVAL = TerraformGeneratorPlugin.injector.getMinY() - 1;
        int[] pair = new int[]{INVAL, INVAL};
        ArrayList<CoordPair> list = new ArrayList<CoordPair>();
        for (int ny = y - 1; ny > TerraformGeneratorPlugin.injector.getMinY(); --ny) {
            if (cache.isSolid(x & 0xF, ny, z & 0xF)) {
                pair[1] = ny;
                if (pair[0] - pair[1] >= minimumHeight) {
                    list.add(new CoordPair(pair[0], pair[1]));
                }
                pair[0] = INVAL;
                pair[1] = INVAL;
                continue;
            }
            if (pair[0] != INVAL) continue;
            pair[0] = ny;
        }
        return list;
    }
}

