/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeBlender;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.DudChunkData;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.MushroomBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class ArchedCliffsHandler
extends BiomeHandler {
    static BiomeBlender biomeBlender;

    @NotNull
    private static BiomeBlender getBiomeBlender(TerraformWorld tw) {
        if (biomeBlender == null) {
            biomeBlender = new BiomeBlender(tw, true, true).setGridBlendingFactor(4.0).setSmoothBlendTowardsRivers(4);
        }
        return biomeBlender;
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.PLAINS;
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double height = super.calculateHeight(tw, x, z);
        double riverDepth = HeightMap.getRawRiverDepth(tw, x, z);
        if (riverDepth > 0.0) {
            height += riverDepth;
        }
        return height + 3.0;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        SimpleBlock grassBottom;
        SimpleBlock underside;
        SimpleBlock target = new SimpleBlock(data, rawX, surfaceY, rawZ);
        if (GenUtils.chance(random, 1, 10)) {
            if (GenUtils.chance(random, 6, 10)) {
                PlantBuilder.GRASS.build(target.getUp());
                if (random.nextBoolean()) {
                    PlantBuilder.TALL_GRASS.build(target.getUp());
                }
            } else if (GenUtils.chance(random, 7, 10)) {
                BlockUtils.pickFlower().build(target.getUp());
            } else {
                BlockUtils.pickTallFlower().build(target.getUp());
            }
        }
        if ((underside = target.findAirPocket(30)) != null && underside.getY() > TerraformGenerator.seaLevel && (grassBottom = underside.findStonelikeFloor(50)) != null && grassBottom.getY() > TerraformGenerator.seaLevel && grassBottom.getType() == Material.GRASS_BLOCK) {
            if (GenUtils.chance(random, 1, 10)) {
                PlantBuilder.build(grassBottom.getUp(), PlantBuilder.RED_MUSHROOM, PlantBuilder.BROWN_MUSHROOM);
            }
            for (BlockFace face : BlockUtils.directBlockFaces) {
                if (!TConfig.arePlantsEnabled() || target.getRelative(face).getType() != Material.AIR || !GenUtils.chance(random, 1, 5)) continue;
                target.getRelative(face).downLPillar(random, random.nextInt(8), Material.OAK_LEAVES);
            }
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] shrooms;
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 6)) {
            int highestY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (BlockUtils.isWet(new SimpleBlock(data, sLoc.getX(), highestY + 1, sLoc.getZ())) || data.getBiome((sLoc = sLoc.getAtY(highestY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            new FractalTreeBuilder(FractalTypes.Tree.NORMAL_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
        for (SimpleLocation sLoc : shrooms = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 10)) {
            SimpleBlock grassBottom;
            SimpleBlock target = new SimpleBlock(data, sLoc.getX(), 0, sLoc.getZ()).getGround();
            SimpleBlock underside = target.findAirPocket(30);
            if (underside == null || underside.getY() <= TerraformGenerator.seaLevel || (grassBottom = underside.findStonelikeFloor(50)) == null || grassBottom.getY() <= TerraformGenerator.seaLevel || grassBottom.getType() != Material.GRASS_BLOCK) continue;
            sLoc = sLoc.getAtY(grassBottom.getY());
            FractalTypes.Mushroom type = switch (random.nextInt(6)) {
                case 0 -> FractalTypes.Mushroom.MEDIUM_RED_MUSHROOM;
                case 1 -> FractalTypes.Mushroom.MEDIUM_BROWN_MUSHROOM;
                case 2 -> FractalTypes.Mushroom.MEDIUM_BROWN_FUNNEL_MUSHROOM;
                case 3 -> FractalTypes.Mushroom.SMALL_BROWN_MUSHROOM;
                case 4 -> FractalTypes.Mushroom.SMALL_POINTY_RED_MUSHROOM;
                default -> FractalTypes.Mushroom.SMALL_RED_MUSHROOM;
            };
            new MushroomBuilder(type).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
        }
    }

    @Override
    public BiomeHandler getTransformHandler() {
        return this;
    }

    @Override
    public void transformTerrain(@NotNull ChunkCache cache, @NotNull TerraformWorld tw, @NotNull Random random, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChunkGenerator.ChunkData chunk, int x, int z, int chunkX, int chunkZ) {
        FastNoise platformNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_ARCHEDCLIFFS_PLATFORMNOISE, world -> {
            FastNoise n = new FastNoise(tw.getRand(12115222L).nextInt());
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.01f);
            return n;
        });
        FastNoise pillarNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_ARCHEDCLIFFS_PILLARNOISE, world -> {
            FastNoise n = new FastNoise(tw.getRand(12544422L).nextInt());
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(4);
            n.SetFrequency(0.01f);
            return n;
        });
        int rawX = chunkX * 16 + x;
        int rawZ = chunkZ * 16 + z;
        double preciseHeight = HeightMap.getPreciseHeight(tw, rawX, rawZ);
        int height = (int)preciseHeight;
        double platformNoiseVal = Math.round(Math.max((double)(platformNoise.GetNoise(rawX, rawZ) * 70.0f) * ArchedCliffsHandler.getBiomeBlender(tw).getEdgeFactor(BiomeBank.ARCHED_CLIFFS, rawX, rawZ), 0.0));
        if (platformNoiseVal >= 1.0) {
            int platformHeight = (int)(HeightMap.CORE.getHeight(tw, rawX, rawZ) - HeightMap.ATTRITION.getHeight(tw, rawX, rawZ) + 55.0);
            cache.writeTransformedHeight(x, z, (short)platformHeight);
            chunk.setBlock(x, platformHeight, z, Material.GRASS_BLOCK);
            Material[] crust = this.getSurfaceCrust(random);
            int i = 0;
            while ((double)i < platformNoiseVal) {
                if (i < crust.length) {
                    chunk.setBlock(x, platformHeight - i, z, crust[i]);
                } else {
                    chunk.setBlock(x, platformHeight - i, z, Material.STONE);
                }
                ++i;
            }
            if (!(chunk instanceof DudChunkData) && platformNoiseVal > 6.0) {
                int pillarNoiseVal = (int)(platformNoiseVal / 10.0 * ((0.1 + (double)Math.abs(pillarNoise.GetNoise(rawX, rawZ))) * 20.0));
                if (pillarNoiseVal + height > platformHeight) {
                    pillarNoiseVal = platformHeight - height;
                }
                boolean applyCrust = !chunk.getType(x, height + pillarNoiseVal + 1, z).isSolid();
                for (int i2 = pillarNoiseVal; i2 >= 1; --i2) {
                    if (pillarNoiseVal - i2 < crust.length && applyCrust) {
                        chunk.setBlock(x, height + i2, z, crust[pillarNoiseVal - i2]);
                        continue;
                    }
                    chunk.setBlock(x, height + i2, z, Material.STONE);
                }
            }
        }
    }

    @Override
    public int getMaxHeightForCaves(@NotNull TerraformWorld tw, int x, int z) {
        return (int)HeightMap.CORE.getHeight(tw, x, z);
    }
}

