/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Snowable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class IceSpikesHandler
extends BiomeHandler {
    public static void genSpike(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data, int x, int y, int z, int baseRadius, int height) {
        Vector base = new Vector(x, y -= height / 5, z);
        Vector base2 = new Vector(x + GenUtils.randInt(random, (int)(-1.5 * (double)baseRadius), (int)(1.5 * (double)baseRadius)), y + height, z + GenUtils.randInt(random, (int)(-1.5 * (double)baseRadius), (int)(1.5 * (double)baseRadius)));
        Vector v = base2.subtract(base);
        SimpleBlock one = new SimpleBlock(data, x, y, z);
        double radius = baseRadius;
        for (int i = 0; i <= height; ++i) {
            Vector seg = v.clone().multiply((float)i / (float)height);
            SimpleBlock segment = one.getRelative(seg);
            BlockUtils.replaceSphere((int)(tw.getSeed() * 12L), (float)radius, 2.0f, (float)radius, segment, false, false, Material.PACKED_ICE);
            radius = (double)baseRadius * (1.0 - (double)i / (double)height);
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.ICE_SPIKES;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.weightedRandomMaterial(rand, Material.SNOW_BLOCK, 5, Material.SNOW_BLOCK, 25), Material.SNOW_BLOCK, GenUtils.randChoice(rand, new Material[]{Material.SNOW_BLOCK, Material.DIRT}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (data.getType(rawX, surfaceY + 1, rawZ) == Material.AIR && !Tag.ICE.isTagged((Keyed)data.getType(rawX, surfaceY, rawZ))) {
            data.setType(rawX, surfaceY + 1, rawZ, Material.SNOW);
            BlockData blockData = data.getBlockData(rawX, surfaceY, rawZ);
            if (blockData instanceof Snowable) {
                Snowable snowable = (Snowable)blockData;
                snowable.setSnowy(true);
                data.setBlockData(rawX, surfaceY, rawZ, (BlockData)snowable);
            }
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] spikes;
        for (SimpleLocation sLoc : spikes = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 16, 0.5f)) {
            int spikeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(spikeY)).getX(), sLoc.getZ()) != this.getBiome() || data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.SNOW_BLOCK) continue;
            if (GenUtils.chance(random, 1, 10)) {
                IceSpikesHandler.genSpike(tw, random, data, sLoc.getX(), sLoc.getY(), sLoc.getZ(), GenUtils.randInt(3, 7), GenUtils.randInt(40, 55));
                continue;
            }
            IceSpikesHandler.genSpike(tw, random, data, sLoc.getX(), sLoc.getY(), sLoc.getZ(), GenUtils.randInt(3, 5), GenUtils.randInt(13, 24));
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.ICY_BEACH;
    }

    @Override
    @NotNull
    public BiomeBank getRiverType() {
        return BiomeBank.FROZEN_RIVER;
    }
}

