/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.V_1_19;

public class MangroveHandler
extends BiomeHandler {
    @Override
    @NotNull
    public BiomeBank getRiverType() {
        return BiomeBank.MANGROVE;
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return V_1_19.MANGROVE_SWAMP;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.randChoice(rand, new Material[]{Material.GRASS_BLOCK, Material.PODZOL, Material.PODZOL}), GenUtils.randChoice(rand, new Material[]{Material.DIRT}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    @NotNull
    public BiomeHandler getTransformHandler() {
        return this;
    }

    @Override
    public void transformTerrain(@NotNull ChunkCache cache, TerraformWorld tw, @NotNull Random random, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChunkGenerator.ChunkData chunk, int x, int z, int chunkX, int chunkZ) {
        short surfaceY = cache.getTransformedHeight(x, z);
        if (surfaceY < TerraformGenerator.seaLevel) {
            int att;
            int rawX = chunkX * 16 + x;
            int rawZ = chunkZ * 16 + z;
            FastNoise mudNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_SWAMP_MUDNOISE, world -> {
                FastNoise n = new FastNoise((int)(world.getSeed() * 4L));
                n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
                n.SetFrequency(0.05f);
                n.SetFractalOctaves(4);
                return n;
            });
            double noise = mudNoise.GetNoise(rawX, rawZ);
            if (noise < 0.0) {
                noise = 0.0;
            }
            if ((att = (int)Math.round(noise * 10.0)) + surfaceY > TerraformGenerator.seaLevel) {
                att = TerraformGenerator.seaLevel - surfaceY;
            }
            for (int i = 1; i <= att; ++i) {
                if (i < att) {
                    chunk.setBlock(x, surfaceY + i, z, this.getSurfaceCrust(random)[1]);
                    continue;
                }
                chunk.setBlock(x, surfaceY + i, z, this.getSurfaceCrust(random)[0]);
            }
            cache.writeTransformedHeight(x, z, (short)(surfaceY + att));
        }
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        int seaLevel = TerraformGenerator.seaLevel;
        if (!BlockUtils.isStoneLike(data.getType(rawX, surfaceY, rawZ))) {
            return;
        }
        if (surfaceY < seaLevel) {
            if (data.getType(rawX, TerraformGenerator.seaLevel, rawZ) == Material.WATER && GenUtils.chance(random, 1, 30)) {
                PlantBuilder.LILY_PAD.build(data, rawX, TerraformGenerator.seaLevel + 1, rawZ);
            }
        } else if (GenUtils.chance(random, 1, 30)) {
            PlantBuilder.FIREFLY_BUSH.build(data, rawX, surfaceY + 1, rawZ);
        }
        if (BlockUtils.isWet(new SimpleBlock(data, rawX, surfaceY + 1, rawZ)) && GenUtils.chance(random, 10, 100) && surfaceY < TerraformGenerator.seaLevel - 3) {
            CoralGenerator.generateKelpGrowth(data, rawX, surfaceY + 1, rawZ);
        }
        if (GenUtils.chance(random, TConfig.c.BIOME_CLAY_DEPOSIT_CHANCE_OUT_OF_THOUSAND, 1000)) {
            BlockUtils.generateClayDeposit(rawX, surfaceY, rawZ, data, random);
        }
        if (GenUtils.chance(random, 5, 1000)) {
            BlockUtils.replaceCircularPatch(random.nextInt(9999), 3.5f, new SimpleBlock(data, rawX, surfaceY, rawZ), V_1_19.MUD);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        int treeY;
        int treeZ;
        int treeX;
        if (GenUtils.chance(random, 8, 10) && data.getBiome(treeX = GenUtils.randInt(random, 2, 12) + data.getChunkX() * 16, treeZ = GenUtils.randInt(random, 2, 12) + data.getChunkZ() * 16) == this.getBiome() && (treeY = GenUtils.getHighestGround(data, treeX, treeZ)) > TerraformGenerator.seaLevel - 6) {
            TreeDB.spawnBreathingRoots(tw, new SimpleBlock(data, treeX, treeY, treeZ), V_1_19.MANGROVE_ROOTS);
            FractalTypes.Tree.SWAMP_TOP.build(tw, new SimpleBlock(data, treeX, treeY, treeZ), t -> t.setCheckGradient(false));
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.MUDFLATS;
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double height = HeightMap.CORE.getHeight(tw, x, z) - 10.0;
        if (height <= 0.0) {
            height = 3.0;
        }
        return height;
    }
}

