/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.V_1_21_5;

public class MeadowHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.MEADOW;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (data.getType(rawX, surfaceY, rawZ) == Material.GRASS_BLOCK && !BlockUtils.isWet(new SimpleBlock(data, rawX, surfaceY, rawZ)) && GenUtils.chance(random, 1, 10)) {
            switch (random.nextInt(4)) {
                case 0: 
                case 1: {
                    PlantBuilder.GRASS.build(data, rawX, surfaceY + 1, rawZ);
                    break;
                }
                case 2: {
                    PlantBuilder.TALL_GRASS.build(data, rawX, surfaceY + 1, rawZ);
                    break;
                }
                case 3: {
                    V_1_21_5.wildflowers(random, data, rawX, surfaceY + 1, rawZ);
                }
            }
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] poffLocs;
        SimpleLocation[] flowerCenters;
        for (SimpleLocation center : flowerCenters = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 23)) {
            Random hashRand = tw.getHashedRand(78019432L, center.getX(), center.getZ());
            PlantBuilder flowerer = BlockUtils.pickFlower(hashRand);
            BlockUtils.lambdaCircularPatch(hashRand.nextInt(211312), GenUtils.randInt(5, 7), new SimpleBlock(data, center.getX(), 0, center.getZ()).getGround(), b2 -> {
                if (data.getBiome(b2.getX(), b2.getZ()) == this.getBiome() && hashRand.nextInt(4) == 0) {
                    flowerer.build(b2.getUp());
                }
            });
        }
        boolean isPumpkin = random.nextBoolean();
        if (GenUtils.chance(1, 70)) {
            for (int i = 0; i < GenUtils.randInt(5, 10); ++i) {
                SimpleBlock target;
                int[] loc = GenUtils.randomSurfaceCoordinates(random, data);
                if (data.getBiome(loc[0], loc[2]) != this.getBiome() || (target = new SimpleBlock(data, loc[0], GenUtils.getHighestGround(data, loc[0], loc[2]) + 1, loc[2])).isSolid()) continue;
                if (isPumpkin) {
                    PlantBuilder.PUMPKIN.build(target);
                    continue;
                }
                PlantBuilder.MELON.build(target);
            }
        }
        for (SimpleLocation sLoc : poffLocs = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 16)) {
            int highestY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (BlockUtils.isWet(new SimpleBlock(data, sLoc.getX(), highestY + 1, sLoc.getZ()))) continue;
            sLoc = sLoc.getAtY(highestY);
            if (!TConfig.arePlantsEnabled() || data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            BlockUtils.replaceSphere(random.nextInt(424444), 2.0f, 2.0f, 2.0f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ()), false, Material.OAK_LEAVES);
        }
    }
}

