/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.NewFractalTreeBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.V_1_21_4;

public class PaleForestHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return V_1_21_4.PALE_GARDEN;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (data.getType(rawX, surfaceY, rawZ) == Material.GRASS_BLOCK && GenUtils.chance(random, 1, 10)) {
            if (data.getType(rawX, surfaceY + 1, rawZ) != Material.AIR) {
                return;
            }
            PlantBuilder.GRASS.build(data, rawX, surfaceY + 1, rawZ);
            if (random.nextInt(3) != 0) {
                PlantBuilder.TALL_GRASS.build(data, rawX, surfaceY + 1, rawZ);
            } else if (random.nextInt(2) != 0) {
                PlantBuilder.CLOSED_EYEBLOSSOM.build(data, rawX, surfaceY + 1, rawZ);
            }
        }
    }

    public NewFractalTreeBuilder paleTreeMutator(NewFractalTreeBuilder b2) {
        b2.getFractalLeaves().setMaterial(V_1_21_4.PALE_OAK_LEAVES);
        b2.getFractalLeaves().setPaleMossVines(0.2f, 3);
        b2.setBranchMaterial(V_1_21_4.PALE_OAK_LOG);
        b2.setRootMaterial(V_1_21_4.PALE_OAK_WOOD);
        return b2;
    }

    private void placeHeart(PopulatorDataAbstract data, int x, int y, int z) {
        data.setBlockData(x, y, z, V_1_21_4.CREAKING_HEART);
        data.setType(x + 1, y, z, V_1_21_4.PALE_OAK_LOG);
        data.setType(x - 1, y, z, V_1_21_4.PALE_OAK_LOG);
        data.setType(x, y, z + 1, V_1_21_4.PALE_OAK_LOG);
        data.setType(x, y, z - 1, V_1_21_4.PALE_OAK_LOG);
        data.setType(x, y - 1, z, V_1_21_4.PALE_OAK_LOG);
        data.setType(x, y + 1, z, V_1_21_4.PALE_OAK_LOG);
        TerraformGeneratorPlugin.logger.info("Spawning Creaking Heart at " + x + "," + y + "," + z);
    }

    private void treeMossCircle(SimpleBlock core) {
        Random random = core.getPopData().getTerraformWorld().getHashedRand(core.getX(), core.getZ(), 1);
        core.setType(V_1_21_4.PALE_MOSS);
        if (random.nextInt(4) == 0) {
            core.getUp().lsetType(V_1_21_4.PALE_MOSS_CARPET);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        int treeY;
        SimpleLocation[] bigTrees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 20);
        SimpleLocation[] trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 10);
        for (SimpleLocation sLoc : bigTrees) {
            treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) || !TConfig.c.TREES_PALE_FOREST_BIG_ENABLED) continue;
            BlockUtils.lambdaCircularPatch(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 7.0f, new SimpleBlock(data, sLoc), this::treeMossCircle);
            if (!FractalTypes.Tree.DARK_OAK_BIG_TOP.build(tw, new SimpleBlock(data, sLoc), this::paleTreeMutator) || !(random.nextDouble() <= TConfig.c.BIOME_PALE_FOREST_CREAKING_CHANCE)) continue;
            this.placeHeart(data, sLoc.getX(), treeY + GenUtils.randInt(random, 2, 5), sLoc.getZ());
        }
        for (SimpleLocation sLoc : trees) {
            treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            BlockUtils.lambdaCircularPatch(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 4.0f, new SimpleBlock(data, sLoc), this::treeMossCircle);
            if (!FractalTypes.Tree.DARK_OAK_SMALL.build(tw, new SimpleBlock(data, sLoc), this::paleTreeMutator) || !(random.nextDouble() <= TConfig.c.BIOME_PALE_FOREST_CREAKING_CHANCE)) continue;
            this.placeHeart(data, sLoc.getX(), treeY + GenUtils.randInt(random, 1, 3), sLoc.getZ());
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.DARK_FOREST_BEACH;
    }

    @Override
    @NotNull
    public BiomeBank getRiverType() {
        return BiomeBank.DARK_FOREST_RIVER;
    }
}

