/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class SavannaHandler
extends BiomeHandler {
    private static void makeYellowPatch(int x, int y, int z, @NotNull PopulatorDataAbstract data, @NotNull Random random) {
        int length = GenUtils.randInt(6, 16);
        int nx = x;
        int nz = z;
        while (length-- > 0) {
            if (BlockUtils.isDirtLike(data.getType(nx, y, nz)) && data.getType(nx, y + 1, nz) == Material.AIR) {
                data.setType(nx, y, nz, Material.DIRT_PATH);
            }
            switch (random.nextInt(5)) {
                case 0: {
                    ++nx;
                    break;
                }
                case 2: {
                    ++nz;
                    break;
                }
                case 3: {
                    --nx;
                    break;
                }
                case 4: {
                    --nz;
                }
            }
            y = GenUtils.getHighestGround(data, nx, nz);
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.SAVANNA;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.randChoice(rand, new Material[]{Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.COARSE_DIRT}), Material.DIRT, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (GenUtils.chance(random, 1, 128)) {
            SavannaHandler.makeYellowPatch(rawX, surfaceY, rawZ, data, random);
        }
        if (data.getType(rawX, surfaceY, rawZ) == Material.GRASS_BLOCK && !data.getType(rawX, surfaceY + 1, rawZ).isSolid() && GenUtils.chance(random, TConfig.c.BIOME_SAVANNA_TALLGRASSCHANCE, 10000)) {
            PlantBuilder.TALL_GRASS.build(data, rawX, surfaceY + 1, rawZ);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        int treeY;
        boolean spawnedLargeSavannaTree = false;
        SimpleLocation[] trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 112, 0.6f);
        if (TConfig.c.TREES_SAVANNA_BIG_ENABLED) {
            for (SimpleLocation sLoc : trees) {
                treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
                if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
                new FractalTreeBuilder(FractalTypes.Tree.SAVANNA_BIG).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                spawnedLargeSavannaTree = true;
            }
        }
        if (!spawnedLargeSavannaTree) {
            for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 32)) {
                treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
                if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
                new FractalTreeBuilder(FractalTypes.Tree.SAVANNA_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
            }
        }
        if (TConfig.arePlantsEnabled()) {
            SimpleLocation[] poffs;
            for (SimpleLocation sLoc : poffs = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 31)) {
                int treeY2 = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
                if (data.getBiome((sLoc = sLoc.getAtY(treeY2)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) || data.getType(sLoc.getX(), sLoc.getY() + 1, sLoc.getZ()).isSolid()) continue;
                SimpleBlock base = new SimpleBlock(data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                int rX = GenUtils.randInt(random, 2, 4);
                int rY = GenUtils.randInt(random, 2, 4);
                int rZ = GenUtils.randInt(random, 2, 4);
                BlockUtils.replaceSphere(random.nextInt(999), (float)rX, (float)rY, (float)rZ, base, false, Material.ACACIA_LEAVES);
            }
        }
    }
}

