/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.PhysicsUpdaterPopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class RockyMountainsHandler
extends AbstractMountainHandler {
    private static void dirtStack(@NotNull PopulatorDataAbstract data, @NotNull Random rand, int x, int y, int z) {
        data.setType(x, y, z, Material.GRASS_BLOCK);
        if (GenUtils.chance(rand, 1, 10)) {
            PlantBuilder.GRASS.build(data, x, y + 1, z);
        }
        int depth = GenUtils.randInt(rand, 3, 7);
        for (int i = 1; i < depth && BlockUtils.isStoneLike(data.getType(x, y - i, z)); ++i) {
            data.setType(x, y - i, z, Material.DIRT);
            if (!BlockUtils.isExposedToNonSolid(new SimpleBlock(data, x, y - i, z))) continue;
            ++depth;
        }
    }

    public static void placeWaterFall(@NotNull TerraformWorld tw, int seed, @NotNull SimpleBlock base) {
        float radius = 4.0f;
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float y = -radius / 2.0f; y <= radius / 2.0f; y += 1.0f) {
                for (float z = -radius; z <= radius; z += 1.0f) {
                    SimpleBlock rel = base.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(y, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0);
                    if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()))) continue;
                    if (y > 0.0f) {
                        rel.setType(Material.AIR);
                        continue;
                    }
                    if (!rel.isSolid()) continue;
                    rel.setType(Material.WATER);
                    PhysicsUpdaterPopulator.pushChange(tw.getName(), new SimpleLocation(rel.getX(), rel.getY(), rel.getZ()));
                }
            }
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.JAGGED_PEAKS;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.STONE, Material.STONE, Material.STONE, Material.COBBLESTONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (surfaceY < TerraformGenerator.seaLevel) {
            return;
        }
        if (GenUtils.chance(random, 1, 25)) {
            RockyMountainsHandler.dirtStack(data, random, rawX, surfaceY, rawZ);
            for (int nx = -2; nx <= 2; ++nx) {
                for (int nz = -2; nz <= 2; ++nz) {
                    if (GenUtils.chance(random, 1, 5) || (surfaceY = GenUtils.getHighestGround(data, rawX + nx, rawZ + nz)) < TerraformGenerator.seaLevel) continue;
                    RockyMountainsHandler.dirtStack(data, random, rawX + nx, surfaceY, rawZ + nz);
                }
            }
        }
    }

    public boolean checkWaterfallSpace(@NotNull SimpleBlock b2) {
        if (b2.getY() < TerraformGenerator.seaLevel + 15) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            if (b2.getRelative(0, -i, 0).isSolid()) continue;
            return false;
        }
        return BlockUtils.isExposedToNonSolid(b2.getDown(4));
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        block0: for (int rawX = data.getChunkX() * 16; rawX < data.getChunkX() * 16 + 16; ++rawX) {
            for (int rawZ = data.getChunkZ() * 16; rawZ < data.getChunkZ() * 16 + 16; ++rawZ) {
                SimpleBlock block;
                int surfaceY = GenUtils.getTransformedHeight(data.getTerraformWorld(), rawX, rawZ);
                if (!(HeightMap.getTrueHeightGradient(data, rawX, rawZ, 3) > 1.5) || !(HeightMap.CORE.getHeight(tw, rawX, rawZ) - HeightMap.getRawRiverDepth(tw, rawX, rawZ) < (double)TerraformGenerator.seaLevel) || !this.checkWaterfallSpace(block = new SimpleBlock(data, rawX, surfaceY, rawZ)) || !GenUtils.chance(tw.getHashedRand(rawX, surfaceY, rawZ), 1, 30)) continue;
                block = block.getDown(4);
                RockyMountainsHandler.placeWaterFall(tw, rawX + 11 * rawZ + 31 * surfaceY, block);
                continue block0;
            }
        }
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 14)) {
            int treeY;
            if (!(HeightMap.getTrueHeightGradient(data, sLoc.getX(), sLoc.getZ(), 3) < 1.4) || data.getBiome((sLoc = sLoc.getAtY(treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ()))).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            new FractalTreeBuilder(FractalTypes.Tree.NORMAL_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.ROCKY_BEACH;
    }
}

