/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.cave;

import org.jetbrains.annotations.NotNull;
import org.terraform.cave.CheeseCave;
import org.terraform.cave.NoiseCaveAbstract;
import org.terraform.cave.NoiseRavine;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class NoiseCaveRegistry {
    private final TerraformWorld tw;
    private final NoiseCaveAbstract @NotNull [] noiseCaveCarvers;
    private final NoiseCaveAbstract @NotNull [] generateCaveCarvers;

    public NoiseCaveRegistry(TerraformWorld tw) {
        this.tw = tw;
        this.noiseCaveCarvers = new NoiseCaveAbstract[]{new CheeseCave()};
        this.generateCaveCarvers = new NoiseCaveAbstract[]{new NoiseRavine()};
    }

    public boolean canNoiseCarve(int x, int y, int z, double height, ChunkCache cache) {
        if (!TConfig.areCavesEnabled()) {
            return false;
        }
        float filterHeight = this.yBarrier(this.tw, x, y, z, (float)height, 10.0f, 5.0f, cache);
        float filterGround = this.yBarrier(this.tw, x, y, z, TerraformGeneratorPlugin.injector.getMinY(), 20.0f, 5.0f, cache);
        float filter = filterHeight * filterGround;
        for (NoiseCaveAbstract carver : this.noiseCaveCarvers) {
            if (!carver.canCarve(this.tw, x, y, z, height, filter)) continue;
            return true;
        }
        return false;
    }

    public boolean canGenerateCarve(int x, int y, int z, double height, ChunkCache cache) {
        if (!TConfig.areCavesEnabled()) {
            return false;
        }
        float filterSea = this.yBarrier(this.tw, x, (int)height, z, TerraformGenerator.seaLevel, 5.0f, 1.0f, cache);
        for (NoiseCaveAbstract carver : this.generateCaveCarvers) {
            if (!carver.canCarve(this.tw, x, y, z, height, filterSea)) continue;
            return true;
        }
        return false;
    }

    public float yBarrier(@NotNull TerraformWorld tw, int x, int y, int z, float v, float barrier, float limit, ChunkCache cache) {
        FastNoise boundaryNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.CAVE_YBARRIER_NOISE, world -> {
            FastNoise n = new FastNoise((int)tw.getSeed() * 5);
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.01f);
            return n;
        });
        float boundaryNoiseVal = cache.getYBarrierNoise(x & 0xF, z & 0xF);
        if (boundaryNoiseVal == ChunkCache.CHUNKCACHE_INVAL) {
            boundaryNoiseVal = 3.0f * boundaryNoise.GetNoise(x, z);
            cache.cacheYBarrierNoise(x & 0xF, z & 0xF, boundaryNoiseVal);
        }
        barrier += boundaryNoiseVal;
        if (Math.abs((float)y - v) <= limit) {
            return 0.0f;
        }
        float abs = Math.abs((float)y - v);
        if (abs < barrier + limit) {
            return (abs - limit) / barrier;
        }
        return 1.0f;
    }
}

