/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.cave;

import org.jetbrains.annotations.NotNull;
import org.terraform.cave.NoiseCaveAbstract;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class NoiseRavine
extends NoiseCaveAbstract {
    private static final int RAVINE_DEPTH = 50;

    @Override
    public boolean canCarve(@NotNull TerraformWorld tw, int rawX, int y, int rawZ, double height, float filter) {
        if (height < (double)TerraformGenerator.seaLevel) {
            return false;
        }
        if ((double)y < height - 50.0) {
            return false;
        }
        FastNoise ravineNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.CAVE_XRAVINE_NOISE, world -> {
            FastNoise n = new FastNoise(tw.getHashedRand(458930L, 16328, 54981).nextInt());
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.007f);
            n.SetFractalOctaves(3);
            return n;
        });
        float ravine = ravineNoise.GetNoise(3 * rawX, (float)y * 0.4f, 3 * rawZ);
        return (ravine *= (float)((double)filter * 0.5885 * Math.log(51.0 - (height - (double)y)))) <= -1.3f;
    }
}

