/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command;

import java.util.Stack;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.terraform.command.contants.FractalTreeTypeArgument;
import org.terraform.command.contants.InvalidArgumentException;
import org.terraform.command.contants.TerraCommand;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.tree.FractalTypes;

public class NewTreeCommand
extends TerraCommand {
    public NewTreeCommand(TerraformGeneratorPlugin plugin, String ... aliases) {
        super(plugin, aliases);
        this.parameters.add(new FractalTreeTypeArgument("type", false));
    }

    @Override
    @NotNull
    public String getDefaultDescription() {
        return "Test command for spawning the new trees";
    }

    @Override
    public boolean canConsoleExec() {
        return false;
    }

    @Override
    public boolean hasPermission(@NotNull CommandSender sender) {
        return sender.isOp();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Stack<String> args) throws InvalidArgumentException {
        Player p = (Player)sender;
        PopulatorDataPostGen data = new PopulatorDataPostGen(p.getLocation().getChunk());
        TerraformWorld tw = TerraformWorld.get(p.getWorld());
        int x = p.getLocation().getBlockX();
        int y = p.getLocation().getBlockY();
        int z = p.getLocation().getBlockZ();
        try {
            ((FractalTypes.Tree)((Object)this.parseArguments(sender, args).get(0))).build(tw, new SimpleBlock(data, x, y, z));
        }
        catch (IllegalArgumentException e2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid tree type.");
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Valid types:");
            StringBuilder types = new StringBuilder();
            boolean b2 = true;
            for (FractalTypes.Tree type : FractalTypes.Tree.values()) {
                ChatColor col = ChatColor.RED;
                if (b2) {
                    col = ChatColor.DARK_RED;
                }
                b2 = !b2;
                types.append(col).append((Object)type).append(' ');
            }
            sender.sendMessage(types.toString());
        }
    }
}

