/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen.bukkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.terraform.data.SimpleChunkLocation;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;

public class NativeGeneratorPatcherPopulator
extends BlockPopulator
implements Listener {
    @NotNull
    public static final Map<SimpleChunkLocation, Collection<Object[]>> cache = new ConcurrentHashMap<SimpleChunkLocation, Collection<Object[]>>();
    private static boolean flushIsQueued = false;

    public NativeGeneratorPatcherPopulator() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TerraformGeneratorPlugin.get());
    }

    public static void pushChange(String world, int x, int y, int z, BlockData data) {
        SimpleChunkLocation scl;
        if (!flushIsQueued && cache.size() > TConfig.c.DEVSTUFF_FLUSH_PATCHER_CACHE_FREQUENCY) {
            flushIsQueued = true;
            new BukkitRunnable(){

                public void run() {
                    NativeGeneratorPatcherPopulator.flushChanges();
                    flushIsQueued = false;
                }
            }.runTask((Plugin)TerraformGeneratorPlugin.get());
        }
        if (!cache.containsKey(scl = new SimpleChunkLocation(world, x, y, z))) {
            cache.put(scl, new ArrayList());
        }
        cache.get(scl).add(new Object[]{new int[]{x, y, z}, data});
    }

    public static void flushChanges() {
        if (cache.isEmpty()) {
            return;
        }
        TerraformGeneratorPlugin.logger.info("[NativeGeneratorPatcher] Flushing repairs (" + cache.size() + " chunks), pushed by cache size");
        ArrayList<SimpleChunkLocation> locs = new ArrayList<SimpleChunkLocation>(cache.keySet());
        for (SimpleChunkLocation scl : locs) {
            World w = Bukkit.getWorld((String)scl.getWorld());
            if (w == null) continue;
            if (w.isChunkLoaded(scl.getX(), scl.getZ())) {
                Collection<Object[]> changes = cache.remove(scl);
                if (changes == null) continue;
                for (Object[] entry : changes) {
                    int[] loc = (int[])entry[0];
                    BlockData data = (BlockData)entry[1];
                    w.getBlockAt(loc[0], loc[1], loc[2]).setBlockData(data, false);
                }
                continue;
            }
            w.loadChunk(scl.getX(), scl.getZ());
        }
    }

    public void populate(@NotNull World world, @NotNull Random random, @NotNull Chunk chunk) {
        SimpleChunkLocation scl = new SimpleChunkLocation(chunk);
        Collection<Object[]> changes = cache.remove(scl);
        if (changes != null) {
            for (Object[] entry : changes) {
                int[] loc = (int[])entry[0];
                BlockData data = (BlockData)entry[1];
                world.getBlockAt(loc[0], loc[1], loc[2]).setBlockData(data, false);
            }
        }
    }

    @EventHandler
    public void onChunkLoad(@NotNull ChunkLoadEvent event) {
        SimpleChunkLocation scl = new SimpleChunkLocation(event.getChunk());
        Collection<Object[]> changes = cache.remove(scl);
        if (changes != null) {
            for (Object[] entry : changes) {
                int[] loc = (int[])entry[0];
                BlockData data = (BlockData)entry[1];
                event.getChunk().getWorld().getBlockAt(loc[0], loc[1], loc[2]).setBlockData(data, false);
            }
        }
    }

    @EventHandler
    public void onWorldUnload(@NotNull WorldUnloadEvent event) {
        TerraformGeneratorPlugin.logger.info("[NativeGeneratorPatcher] Flushing repairs for " + event.getWorld().getName() + " (" + cache.size() + " chunks in cache), triggered by world unload");
        int processed = 0;
        for (SimpleChunkLocation scl : cache.keySet()) {
            if (!scl.getWorld().equals(event.getWorld().getName())) continue;
            Collection<Object[]> changes = cache.get(scl);
            if (changes != null) {
                for (Object[] entry : changes) {
                    int[] loc = (int[])entry[0];
                    BlockData data = (BlockData)entry[1];
                    event.getWorld().getBlockAt(loc[0], loc[1], loc[2]).setBlockData(data, false);
                }
            }
            if (++processed % 20 != 0) continue;
            TerraformGeneratorPlugin.logger.info("[NativeGeneratorPatcher] Processed " + processed + "/" + cache.size() + " chunks");
        }
    }
}

