/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.data;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.IPopulatorDataPhysicsCapable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.SimpleChunkLocation;
import org.terraform.data.SimpleLocation;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class SimpleBlock {
    @NotNull
    final PopulatorDataAbstract popData;
    @SerializedName(value="w")
    private final int x;
    @SerializedName(value="w")
    private final int y;
    @SerializedName(value="w")
    private final int z;

    public SimpleBlock(@NotNull Location loc) {
        this.popData = new PopulatorDataPostGen(loc.getChunk());
        this.x = loc.getBlockX();
        this.y = loc.getBlockY();
        this.z = loc.getBlockZ();
    }

    public SimpleBlock(@NotNull PopulatorDataAbstract data, @NotNull Vector loc) {
        this.popData = data;
        this.x = (int)Math.round(loc.getX());
        this.y = (int)Math.round(loc.getY());
        this.z = (int)Math.round(loc.getZ());
    }

    public SimpleBlock(@NotNull PopulatorDataAbstract data, int x, int y, int z) {
        this.popData = data;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SimpleBlock(@NotNull PopulatorDataAbstract data, @NotNull SimpleLocation sLoc) {
        this.popData = data;
        this.x = sLoc.getX();
        this.y = sLoc.getY();
        this.z = sLoc.getZ();
    }

    public SimpleBlock(@NotNull PopulatorDataAbstract data, @NotNull Location loc) {
        this.popData = data;
        this.x = (int)loc.getX();
        this.y = (int)loc.getY();
        this.z = (int)loc.getZ();
    }

    public SimpleBlock(@NotNull PopulatorDataAbstract data, @NotNull Block b2) {
        this.popData = data;
        this.x = b2.getX();
        this.y = b2.getY();
        this.z = b2.getZ();
    }

    public void pathTowards(int width, int maxLength, @NotNull SimpleBlock target, Material ... types) {
        BlockFace dir = BlockFace.NORTH;
        int max = -1;
        if (target.getX() - this.getX() > max) {
            dir = BlockFace.EAST;
        } else if (this.getX() - target.getX() > max) {
            dir = BlockFace.WEST;
        } else if (this.getZ() - target.getZ() > max) {
            dir = BlockFace.NORTH;
        } else if (target.getZ() - this.getZ() > max) {
            dir = BlockFace.SOUTH;
        }
        SimpleBlock base = this;
        for (int i = 0; i < maxLength && base.lsetType(types); ++i) {
            for (int w = 0; w < width; ++w) {
                for (BlockFace adj : BlockUtils.getAdjacentFaces(dir)) {
                    base.getRelative(adj).setType(types);
                }
            }
            base = base.getRelative(dir);
        }
    }

    @NotNull
    public SimpleLocation getLoc() {
        return new SimpleLocation(this.x, this.y, this.z);
    }

    @NotNull
    public SimpleBlock getAtY(int y) {
        return new SimpleBlock(this.popData, this.x, y, this.z);
    }

    public double distanceSquared(@NotNull SimpleBlock other) {
        float selfX = this.x;
        float selfY = this.y;
        float selfZ = this.z;
        float oX = other.x;
        float oY = other.y;
        float oZ = other.z;
        return Math.pow(selfX - oX, 2.0) + Math.pow(selfY - oY, 2.0) + Math.pow(selfZ - oZ, 2.0);
    }

    public boolean isConnected(SimpleBlock other) {
        for (BlockFace face : BlockUtils.sixBlockFaces) {
            if (!this.getRelative(face).equals(other)) continue;
            return true;
        }
        return false;
    }

    public double distance(@NotNull SimpleBlock other) {
        return Math.sqrt(this.distanceSquared(other));
    }

    public boolean sameLocation(@NotNull SimpleBlock other) {
        return other.x == this.x && other.y == this.y && other.z == this.z;
    }

    @NotNull
    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    @NotNull
    public SimpleBlock untilSolid(@NotNull BlockFace face) {
        SimpleBlock rel = this.getRelative(face);
        while (!rel.isSolid()) {
            rel = rel.getRelative(face);
        }
        return rel;
    }

    public boolean lsetType(@NotNull Material type) {
        if (!this.isSolid()) {
            this.setType(type);
            return true;
        }
        return false;
    }

    public void lsetBlockData(BlockData data) {
        if (!this.isSolid()) {
            this.setBlockData(data);
        }
    }

    @Nullable
    public BlockData getBlockData() {
        return this.popData.getBlockData(this.x, this.y, this.z);
    }

    public void setBlockData(BlockData dat) {
        if (this.popData.getType(this.x, this.y, this.z) == Material.WATER && dat instanceof Waterlogged) {
            Waterlogged wl = (Waterlogged)dat;
            wl.setWaterlogged(true);
        }
        this.popData.setBlockData(this.x, this.y, this.z, dat);
    }

    public void RSolSetBlockData(BlockData data) {
        if (this.isSolid()) {
            this.setBlockData(data);
        }
    }

    @NotNull
    public SimpleBlock getRelative(int nx, int ny, int nz) {
        return new SimpleBlock(this.popData, this.x + nx, this.y + ny, this.z + nz);
    }

    @NotNull
    public SimpleBlock getRelative(@NotNull Vector v) {
        return new SimpleBlock(this.popData, (int)Math.round((double)this.x + v.getX()), (int)Math.round((double)this.y + v.getY()), (int)Math.round((double)this.z + v.getZ()));
    }

    @NotNull
    public String getCoords() {
        return this.x + "," + this.y + "," + this.z;
    }

    @NotNull
    public SimpleBlock getRelative(@NotNull BlockFace face) {
        return new SimpleBlock(this.popData, this.x + face.getModX(), this.y + face.getModY(), this.z + face.getModZ());
    }

    @NotNull
    public SimpleBlock getRelative(@NotNull BlockFace face, int count) {
        return new SimpleBlock(this.popData, this.x + face.getModX() * count, this.y + face.getModY() * count, this.z + face.getModZ() * count);
    }

    public void addEntity(EntityType type) {
        this.popData.addEntity(this.x, this.y, this.z, type);
    }

    public int countAdjacentsThatMatchType(BlockFace @NotNull [] faces, Material ... types) {
        int i = 0;
        for (BlockFace face : faces) {
            for (Material type : types) {
                if (this.getRelative(face).getType() != type) continue;
                ++i;
            }
        }
        return i;
    }

    public boolean doAdjacentsMatchType(BlockFace @NotNull [] faces, Material ... types) {
        for (BlockFace face : faces) {
            for (Material type : types) {
                if (this.getRelative(face).getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceAdjacentNonLiquids(BlockFace @NotNull [] faces, Material liquid, Material ... types) {
        for (BlockFace face : faces) {
            if (this.getRelative(face).isSolid() || this.getRelative(face).getType() == liquid) continue;
            this.getRelative(face).setType(types);
        }
    }

    public boolean hasAdjacentSolid(BlockFace @NotNull [] faces) {
        for (BlockFace face : faces) {
            if (!this.getRelative(face).isSolid()) continue;
            return true;
        }
        return false;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }

    @NotNull
    public SimpleChunkLocation getSChunk(String world) {
        return new SimpleChunkLocation(world, this.getChunkX(), this.getChunkZ());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    @NotNull
    public Material getType() {
        return this.popData.getType(this.x, this.y, this.z);
    }

    public void setType(@NotNull Material type) {
        if (this.popData.getType(this.x, this.y, this.z) == Material.WATER) {
            BlockData data = Bukkit.createBlockData((Material)type);
            if (data instanceof Waterlogged) {
                Waterlogged wl = (Waterlogged)data;
                wl.setWaterlogged(true);
            }
            this.popData.setBlockData(this.x, this.y, this.z, data);
        } else {
            this.popData.setType(this.x, this.y, this.z, type);
        }
        if (Tag.LEAVES.isTagged((Keyed)type)) {
            BlockData l = Bukkit.createBlockData((Material)type);
            if (l instanceof Leaves) {
                Leaves leaves = (Leaves)l;
                leaves.setPersistent(true);
            }
            this.setBlockData(l);
        }
    }

    public void setType(Material ... types) {
        this.setType(GenUtils.randChoice(types));
    }

    public boolean isAir() {
        return this.popData.getType(this.x, this.y, this.z) == Material.AIR || this.popData.getType(this.x, this.y, this.z) == Material.CAVE_AIR;
    }

    public boolean isSolid() {
        return this.popData.getType(this.x, this.y, this.z).isSolid();
    }

    public void physicsSetType(@NotNull Material type, boolean updatePhysics) {
        if (this.popData instanceof IPopulatorDataPhysicsCapable) {
            if (this.popData.getType(this.x, this.y, this.z) == Material.WATER) {
                BlockData data = Bukkit.createBlockData((Material)type);
                if (data instanceof Waterlogged) {
                    Waterlogged wl = (Waterlogged)data;
                    wl.setWaterlogged(true);
                }
                ((IPopulatorDataPhysicsCapable)((Object)this.popData)).setBlockData(this.x, this.y, this.z, data, updatePhysics);
            } else {
                ((IPopulatorDataPhysicsCapable)((Object)this.popData)).setType(this.x, this.y, this.z, type, updatePhysics);
            }
            if (Tag.LEAVES.isTagged((Keyed)type)) {
                BlockData l = Bukkit.createBlockData((Material)type);
                if (l instanceof Leaves) {
                    Leaves leaves = (Leaves)l;
                    leaves.setPersistent(true);
                }
                ((IPopulatorDataPhysicsCapable)((Object)this.popData)).setBlockData(this.x, this.y, this.z, l, updatePhysics);
            }
        } else {
            this.setType(type);
        }
    }

    public void physicsSetBlockData(BlockData dat, boolean updatePhysics) {
        if (this.popData instanceof IPopulatorDataPhysicsCapable) {
            if (this.popData.getType(this.x, this.y, this.z) == Material.WATER && dat instanceof Waterlogged) {
                Waterlogged wl = (Waterlogged)dat;
                wl.setWaterlogged(true);
            }
            ((IPopulatorDataPhysicsCapable)((Object)this.popData)).setBlockData(this.x, this.y, this.z, dat, updatePhysics);
        } else {
            this.setBlockData(dat);
        }
    }

    public boolean lsetType(Material ... types) {
        return this.lsetType(GenUtils.randChoice(types));
    }

    public void RSolSetType(@NotNull Material type) {
        if (this.isSolid()) {
            this.setType(type);
        }
    }

    @NotNull
    public PopulatorDataAbstract getPopData() {
        return this.popData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.popData.getTerraformWorld().hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleBlock)) {
            return false;
        }
        SimpleBlock other = (SimpleBlock)obj;
        return Objects.equals(this.popData.getTerraformWorld(), other.getPopData().getTerraformWorld()) && this.x == other.x && this.z == other.z && this.y == other.y;
    }

    @NotNull
    public SimpleBlock getGround() {
        return new SimpleBlock(this.popData, this.x, GenUtils.getHighestGround(this.popData, this.x, this.z), this.z);
    }

    @NotNull
    public SimpleBlock getGroundOrSeaLevel() {
        int y = GenUtils.getHighestGround(this.popData, this.x, this.z);
        if (y < TerraformGenerator.seaLevel) {
            y = TerraformGenerator.seaLevel;
        }
        return new SimpleBlock(this.popData, this.x, y, this.z);
    }

    @NotNull
    public SimpleBlock getGroundOrDry() {
        int y;
        for (y = GenUtils.getHighestGround(this.popData, this.x, this.z); y < TerraformGeneratorPlugin.injector.getMaxY() && (BlockUtils.isWet(this.getAtY(y + 1)) || Tag.ICE.isTagged((Keyed)this.getAtY(y + 1).getType())); ++y) {
        }
        return new SimpleBlock(this.popData, this.x, y, this.z);
    }

    @NotNull
    public SimpleBlock getUp() {
        return this.getRelative(0, 1, 0);
    }

    @NotNull
    public SimpleBlock getUp(int i) {
        return this.getRelative(0, i, 0);
    }

    @Nullable
    public SimpleBlock findCeiling(int cutoff) {
        SimpleBlock ceil = this.getUp();
        while (cutoff > 0) {
            if (ceil.isSolid() && ceil.getType() != Material.LANTERN) {
                return ceil;
            }
            --cutoff;
            ceil = ceil.getUp();
        }
        return null;
    }

    @Nullable
    public SimpleBlock findFloor(int cutoff) {
        SimpleBlock floor = this.getDown();
        while (cutoff > 0 && floor.getY() >= TerraformGeneratorPlugin.injector.getMinY()) {
            if (floor.isSolid() && floor.getType() != Material.LANTERN) {
                return floor;
            }
            --cutoff;
            floor = floor.getDown();
        }
        return null;
    }

    @Nullable
    public SimpleBlock findAirPocket(int cutoff) {
        SimpleBlock floor = this.getDown();
        while (cutoff > 0 && floor.getY() >= TerraformGeneratorPlugin.injector.getMinY()) {
            if (!floor.isSolid()) {
                return floor;
            }
            --cutoff;
            floor = floor.getDown();
        }
        return null;
    }

    @Nullable
    public SimpleBlock findNearestAirPocket(int cutoff) {
        if (this.isSolid()) {
            SimpleBlock rel = this.getUp();
            while (cutoff > 0) {
                if (!rel.isSolid()) {
                    return rel;
                }
                --cutoff;
                rel = rel.getUp();
            }
            return null;
        }
        SimpleBlock candidate = this.findFloor(cutoff);
        if (candidate != null) {
            candidate = candidate.getUp();
        }
        return candidate;
    }

    @Nullable
    public SimpleBlock findStonelikeFloor(int cutoff) {
        SimpleBlock floor = this.getDown();
        while (cutoff > 0 && floor.getY() >= TerraformGeneratorPlugin.injector.getMinY()) {
            if (BlockUtils.isStoneLike(floor.getType())) {
                return floor;
            }
            --cutoff;
            floor = floor.getDown();
        }
        return null;
    }

    @Nullable
    public SimpleBlock findStonelikeCeiling(int cutoff) {
        SimpleBlock ceil = this.getUp();
        while (cutoff > 0) {
            if (BlockUtils.isStoneLike(ceil.getType())) {
                return ceil;
            }
            --cutoff;
            ceil = ceil.getUp();
        }
        return null;
    }

    public void Pillar(int height, Material ... types) {
        Random rand = new Random();
        for (int i = 0; i < height; ++i) {
            this.getRelative(0, i, 0).setType(GenUtils.randChoice(rand, types));
        }
    }

    public void fluidize() {
        Material fluid = Material.AIR;
        if (!BlockUtils.isWet(this)) {
            for (BlockFace face : BlockUtils.directBlockFaces) {
                if (this.getRelative(face).getType() == Material.WATER) {
                    fluid = Material.WATER;
                    continue;
                }
                if (this.getRelative(face).getType() != Material.LAVA) continue;
                fluid = Material.LAVA;
            }
        } else {
            fluid = Material.WATER;
        }
        this.setType(fluid);
    }

    public void Pillar(int height, @NotNull Random rand, Material ... types) {
        for (int i = 0; i < height; ++i) {
            this.getRelative(0, i, 0).setType(GenUtils.randChoice(rand, types));
        }
    }

    public void Pillar(int height, boolean pattern, @NotNull Random rand, Material ... types) {
        for (int i = 0; i < height; ++i) {
            if (Arrays.equals(new Material[]{Material.BARRIER}, types)) continue;
            if (!pattern) {
                this.getRelative(0, i, 0).setType(GenUtils.randChoice(rand, types));
                continue;
            }
            if (types[i % types.length] == Material.BARRIER) continue;
            this.getRelative(0, i, 0).setType(types[i % types.length]);
        }
    }

    public void CorrectMultipleFacing(int height) {
        for (int i = 0; i < height; ++i) {
            BlockUtils.correctSurroundingMultifacingData(this.getRelative(0, i, 0));
        }
    }

    public void LPillar(int height, Material ... types) {
        this.LPillar(height, false, new Random(), types);
    }

    public int LPillar(int height, @NotNull Random rand, Material ... types) {
        return this.LPillar(height, false, rand, types);
    }

    public int LPillar(int height, boolean pattern, @NotNull Random rand, Material ... types) {
        for (int i = 0; i < height; ++i) {
            if (this.getRelative(0, i, 0).isSolid()) {
                return i;
            }
            if (Arrays.equals(new Material[]{Material.BARRIER}, types)) continue;
            if (!pattern) {
                this.getRelative(0, i, 0).setType(GenUtils.randChoice(rand, types));
                continue;
            }
            this.getRelative(0, i, 0).setType(types[i % types.length]);
        }
        return height;
    }

    public void RPillar(int height, @NotNull Random rand, Material ... types) {
        for (int i = 0; i < height; ++i) {
            if (this.getRelative(0, i, 0).isSolid()) continue;
            this.getRelative(0, i, 0).setType(GenUtils.randChoice(rand, types));
        }
    }

    public void ReplacePillar(int height, Material ... types) {
        for (int i = 0; i < height; ++i) {
            if (!this.getRelative(0, i, 0).isSolid()) continue;
            this.getRelative(0, i, 0).setType(GenUtils.randChoice(types));
        }
    }

    public void CAPillar(int height, @NotNull Random rand, Material ... types) {
        for (int i = 0; i < height; ++i) {
            if (this.getRelative(0, i, 0).getType() == Material.CAVE_AIR) continue;
            this.getRelative(0, i, 0).setType(GenUtils.randChoice(rand, types));
        }
    }

    public void waterlog(int height) {
        for (int i = 0; i < height; ++i) {
            SimpleBlock rel = this.getRelative(0, i, 0);
            BlockData blockData = rel.getBlockData();
            if (!(blockData instanceof Waterlogged)) continue;
            Waterlogged log = (Waterlogged)blockData;
            log.setWaterlogged(true);
            rel.setBlockData((BlockData)log);
        }
    }

    public int downUntilSolid(@NotNull Random rand, Material ... types) {
        int depth = 0;
        for (int y = this.y; y > TerraformGeneratorPlugin.injector.getMinY() && !this.getRelative(0, -depth, 0).isSolid(); --y) {
            this.getRelative(0, -depth, 0).setType(GenUtils.randChoice(rand, types));
            ++depth;
        }
        return depth;
    }

    public int blockfaceUntilSolid(int maxDepth, @NotNull Random rand, @NotNull BlockFace face, Material ... types) {
        int depth;
        for (depth = 0; depth <= maxDepth && !this.getRelative(face).isSolid(); ++depth) {
            this.getRelative(face).setType(GenUtils.randChoice(rand, types));
        }
        return depth;
    }

    public int blockface(int maxDepth, @NotNull Random rand, @NotNull BlockFace face, Material ... types) {
        int depth;
        for (depth = 0; depth <= maxDepth; ++depth) {
            this.getRelative(face).setType(GenUtils.randChoice(rand, types));
        }
        return depth;
    }

    public void downPillar(int h2, Material ... types) {
        this.downPillar(new Random(), h2, types);
    }

    public void downPillar(@NotNull Random rand, int h2, Material ... types) {
        int depth = 0;
        for (int y = this.y; y > TerraformGeneratorPlugin.injector.getMinY() && depth < h2; ++depth, --y) {
            this.getRelative(0, -depth, 0).setType(GenUtils.randChoice(rand, types));
        }
    }

    public void downLPillar(@NotNull Random rand, int h2, Material ... types) {
        int depth = 0;
        for (int y = this.y; y > TerraformGeneratorPlugin.injector.getMinY() && depth < h2 && !this.getRelative(0, -depth, 0).isSolid(); ++depth, --y) {
            this.getRelative(0, -depth, 0).setType(GenUtils.randChoice(rand, types));
        }
    }

    public void downRPillar(@NotNull Random rand, int h2, Material ... types) {
        int depth = 0;
        for (int y = this.y; y > TerraformGeneratorPlugin.injector.getMinY() && depth < h2; ++depth, --y) {
            if (this.getRelative(0, -depth, 0).isSolid()) continue;
            this.getRelative(0, -depth, 0).setType(GenUtils.randChoice(rand, types));
        }
    }

    public void directionalLPillar(@NotNull Random rand, @NotNull BlockFace face, int h2, Material ... types) {
        int depth = 0;
        for (int y = this.y; y > TerraformGeneratorPlugin.injector.getMinY() && depth < h2 && !this.getRelative(face, depth).isSolid(); ++depth, --y) {
            this.getRelative(face, depth).setType(GenUtils.randChoice(rand, types));
        }
    }

    @NotNull
    public SimpleBlock getDown(int i) {
        return this.getRelative(0, -i, 0);
    }

    @NotNull
    public SimpleBlock getDown() {
        return this.getRelative(0, -1, 0);
    }

    @NotNull
    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }

    public void rsetType(@NotNull EnumSet<Material> toReplace, Material ... type) {
        this.popData.rsetType(this.toVector(), toReplace, type);
    }

    public void rsetBlockData(@NotNull EnumSet<Material> toReplace, BlockData data) {
        this.popData.rsetBlockData(this.toVector(), toReplace, data);
    }
}

