/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.main;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.terraform.main.config.TConfig;

public class TLogger {
    private static final Logger LOGGER = Logger.getLogger("TerraformGenerator-Custom");
    private static boolean suppressConsoleLogs = false;

    public TLogger() {
        suppressConsoleLogs = TConfig.c.DEVSTUFF_SUPPRESS_CONSOLE_LOGS;
        if (suppressConsoleLogs) {
            try {
                ConsoleHandler consoleHandler = new ConsoleHandler();
                FileHandler fileHandler = new FileHandler("plugins" + File.separator + "TerraformGenerator" + File.separator + "terraform.log", true);
                fileHandler.setFormatter(new SimpleFormatter(){
                    private static final String format = "[%1$tF %1$tT] [%2$-7s] %3$s %n";

                    @Override
                    @NotNull
                    public synchronized String format(@NotNull LogRecord lr) {
                        return String.format(format, new Date(lr.getMillis()), lr.getLevel().getLocalizedName(), ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)lr.getMessage())));
                    }
                });
                LOGGER.setUseParentHandlers(false);
                LOGGER.addHandler(consoleHandler);
                LOGGER.addHandler(fileHandler);
                consoleHandler.setLevel(Level.OFF);
                fileHandler.setLevel(Level.ALL);
                LOGGER.config("Configuration done.");
                this.stdout("Custom Logger Initialized");
            }
            catch (IOException exception) {
                Bukkit.getLogger().severe("Error occur in FileHandler." + String.valueOf(exception));
                suppressConsoleLogs = false;
            }
        }
    }

    public void stdout(@NotNull String message) {
        Bukkit.getConsoleSender().sendMessage("[TerraformGenerator] " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        if (suppressConsoleLogs) {
            LOGGER.log(Level.INFO, " " + message);
        }
    }

    public void error(@NotNull String message) {
        if (suppressConsoleLogs) {
            LOGGER.log(Level.SEVERE, "[!] " + message);
        } else {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[TerraformGenerator][!] " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    public void info(@NotNull String message) {
        if (suppressConsoleLogs) {
            LOGGER.log(Level.INFO, message);
        } else {
            Bukkit.getConsoleSender().sendMessage("[TerraformGenerator] " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    public void debug(@NotNull String message) {
        if (TConfig.c.DEVSTUFF_DEBUG_MODE) {
            if (suppressConsoleLogs) {
                LOGGER.log(Level.INFO, "[v] " + message);
            } else {
                Bukkit.getConsoleSender().sendMessage("[TerraformGenerator][v] " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
        }
    }

    public void stackTrace(@NotNull Throwable e2) {
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[TerraformGenerator][!] " + e2.getMessage());
        for (StackTraceElement stackTraceElement : e2.getStackTrace()) {
            String message = stackTraceElement.toString();
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[TerraformGenerator][!] " + message);
        }
    }
}

