/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.main;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.command.AncientCityCommand;
import org.terraform.command.AnimalFarmCommand;
import org.terraform.command.AnimalSpawnerCommand;
import org.terraform.command.BiomeConsoleCheckCommand;
import org.terraform.command.BiomeDistribCommand;
import org.terraform.command.BiomeVisualiserCommand;
import org.terraform.command.BlockDataTestCommand;
import org.terraform.command.CatacombsCommand;
import org.terraform.command.CaveCommand;
import org.terraform.command.CheckHeightCommand;
import org.terraform.command.CoconutCommand;
import org.terraform.command.CoralCommand;
import org.terraform.command.CrappyDebugStructureCommand;
import org.terraform.command.DesertWellCommand;
import org.terraform.command.DrownedDungeonCommand;
import org.terraform.command.FarmhouseCommand;
import org.terraform.command.FixerCacheFlushCommand;
import org.terraform.command.FractalTreeCommand;
import org.terraform.command.GiantPumpkinCommand;
import org.terraform.command.HelpCommand;
import org.terraform.command.IceSpikeCommand;
import org.terraform.command.IglooCommand;
import org.terraform.command.InjectorDebugTestCommand;
import org.terraform.command.JigsawBuilderTestCommand;
import org.terraform.command.LargeMonumentLampCommand;
import org.terraform.command.LocateBiomeCommand;
import org.terraform.command.LocateCommand;
import org.terraform.command.MansionCommand;
import org.terraform.command.MazeCommand;
import org.terraform.command.MineshaftCommand;
import org.terraform.command.MonumentCommand;
import org.terraform.command.MountainhouseCommand;
import org.terraform.command.MushroomCommand;
import org.terraform.command.NMSChunkPacketRefreshCommand;
import org.terraform.command.NMSChunkQueryCommand;
import org.terraform.command.NewTreeCommand;
import org.terraform.command.OreDitCommand;
import org.terraform.command.OutpostCommand;
import org.terraform.command.PlainsVillageCommand;
import org.terraform.command.PreviewCommand;
import org.terraform.command.PyramidCommand;
import org.terraform.command.RibCageCommand;
import org.terraform.command.RuinedPortalCommand;
import org.terraform.command.SchematicLoadCommand;
import org.terraform.command.SchematicSaveCommand;
import org.terraform.command.SeekCommand;
import org.terraform.command.ShipwreckCommand;
import org.terraform.command.SphereCommand;
import org.terraform.command.StrongholdCommand;
import org.terraform.command.TimingsCommand;
import org.terraform.command.TrailRuinsCommand;
import org.terraform.command.UndergroundDungeonCommand;
import org.terraform.command.ValuesCommand;
import org.terraform.command.WandCommand;
import org.terraform.command.WarmOceanRuinsCommand;
import org.terraform.command.WitchHutCommand;
import org.terraform.command.contants.InvalidArgumentException;
import org.terraform.command.contants.TerraCommand;
import org.terraform.command.contants.TerraCommandArgument;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;

public class TerraformCommandManager
implements TabExecutor {
    @NotNull
    public final ArrayList<String> bases = new ArrayList();
    @NotNull
    private final ArrayList<TerraCommand> commands = new ArrayList();
    private final TerraformGeneratorPlugin plugin;

    public TerraformCommandManager(@NotNull TerraformGeneratorPlugin plugin, String ... bases) {
        this.plugin = plugin;
        for (String base : bases) {
            this.bases.add(base);
            plugin.getCommand(base).setExecutor((CommandExecutor)this);
        }
        this.registerCommand(new HelpCommand(plugin, this, "help", "h", "?"));
        if (TConfig.c.DEVSTUFF_EXTENDED_COMMANDS) {
            this.registerCommand(new PreviewCommand(plugin, "preview"));
            this.registerCommand(new TimingsCommand(plugin, "timings", "lag"));
            this.registerCommand(new CoconutCommand(plugin, "coconut"));
            this.registerCommand(new ValuesCommand(plugin, "values"));
            this.registerCommand(new BiomeDistribCommand(plugin, "biomedistrib"));
            this.registerCommand(new SphereCommand(plugin, "sphere"));
            this.registerCommand(new FractalTreeCommand(plugin, "fractal", "fractaltree", "ftree"));
            this.registerCommand(new CaveCommand(plugin, "cave"));
            this.registerCommand(new WarmOceanRuinsCommand(plugin, "warmoceanruins", "wor"));
            this.registerCommand(new TrailRuinsCommand(plugin, "trailruins", "tr"));
            this.registerCommand(new IceSpikeCommand(plugin, "icespike"));
            this.registerCommand(new CoralCommand(plugin, "coral"));
            this.registerCommand(new WitchHutCommand(plugin, "hut"));
            this.registerCommand(new GiantPumpkinCommand(plugin, "giantpumpkin"));
            this.registerCommand(new MonumentCommand(plugin, "monument", "mon"));
            this.registerCommand(new LargeMonumentLampCommand(plugin, "lml"));
            this.registerCommand(new StrongholdCommand(plugin, "stronghold", "sh"));
            this.registerCommand(new AnimalFarmCommand(plugin, "animalfarm", "af"));
            this.registerCommand(new FarmhouseCommand(plugin, "farmhouse", "fh"));
            this.registerCommand(new MountainhouseCommand(plugin, "mountainhouse", "mh"));
            this.registerCommand(new AnimalSpawnerCommand(plugin, "animalspawner", "as"));
            this.registerCommand(new MineshaftCommand(plugin, "mineshaft", "ms"));
            this.registerCommand(new CatacombsCommand(plugin, "catacombs", "ccs"));
            this.registerCommand(new IglooCommand(plugin, "igloo"));
            this.registerCommand(new ShipwreckCommand(plugin, "shipwreck", "sw"));
            this.registerCommand(new OutpostCommand(plugin, "outpost"));
            this.registerCommand(new NMSChunkPacketRefreshCommand(plugin, "chunkrefresh"));
            this.registerCommand(new NMSChunkQueryCommand(plugin, "chunkquery"));
            this.registerCommand(new BiomeVisualiserCommand(plugin, "bv", "biomevisualiser"));
            this.registerCommand(new BiomeConsoleCheckCommand(plugin, "bcc", "biomeconsolecheck"));
            this.registerCommand(new UndergroundDungeonCommand(plugin, "ud", "undergrounddungeon"));
            this.registerCommand(new InjectorDebugTestCommand(plugin, "idt", "injectordebugtest"));
            this.registerCommand(new DrownedDungeonCommand(plugin, "dd", "drowneddungeon"));
            this.registerCommand(new CheckHeightCommand(plugin, "checkheight", "ch"));
            this.registerCommand(new WandCommand(plugin, "wand"));
            this.registerCommand(new MushroomCommand(plugin, "mushroom"));
            this.registerCommand(new RuinedPortalCommand(plugin, "ruinedportal"));
            this.registerCommand(new MansionCommand(plugin, "mansion"));
            this.registerCommand(new SchematicSaveCommand(plugin, "save"));
            this.registerCommand(new AncientCityCommand(plugin, "ancientcity", "ac"));
            this.registerCommand(new SchematicLoadCommand(plugin, "load"));
            this.registerCommand(new PyramidCommand(plugin, "pyramid"));
            this.registerCommand(new MazeCommand(plugin, "maze"));
            this.registerCommand(new DesertWellCommand(plugin, "desertwell"));
            this.registerCommand(new BlockDataTestCommand(plugin, "blockdatatest", "bdt"));
            this.registerCommand(new JigsawBuilderTestCommand(plugin, "jigsawbuildertest", "jbt"));
            this.registerCommand(new PlainsVillageCommand(plugin, "plainsvillage", "pv"));
            this.registerCommand(new RibCageCommand(plugin, "ribcage"));
            this.registerCommand(new OreDitCommand(plugin, "oredit"));
            this.registerCommand(new NewTreeCommand(plugin, "newtree", "nt"));
            this.registerCommand(new CrappyDebugStructureCommand(plugin, "cdsc"));
            this.registerCommand(new SeekCommand(plugin, "seek"));
        }
        this.registerCommand(new LocateCommand(plugin, "locate"));
        this.registerCommand(new FixerCacheFlushCommand(plugin, "fixercacheflush", "fcf"));
        this.registerCommand(new LocateBiomeCommand(plugin, "locatebiome", "lb"));
    }

    public void unregisterCommand(@NotNull Class<?> clazz) {
        this.commands.removeIf(clazz::isInstance);
    }

    public void unregisterCommand(String alias) {
        this.commands.removeIf(cmd -> cmd.matchCommand(alias));
    }

    @NotNull
    public ArrayList<TerraCommand> getCommands() {
        return this.commands;
    }

    public void registerCommand(@NotNull TerraCommand cmd) {
        this.commands.add(cmd);
        this.plugin.getLang().fetchLang("command." + cmd.aliases.get(0) + ".desc", cmd.getDefaultDescription());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String arg2, String @NotNull [] args) {
        if (args.length == 0) {
            sender.sendMessage(this.plugin.getLang().fetchLang("command.unknown"));
            new HelpCommand(this.plugin, this, new String[0]).execute(sender, new Stack<String>());
            return false;
        }
        for (TerraCommand command : this.commands) {
            if (!command.matchCommand(args[0].toLowerCase(Locale.ENGLISH))) continue;
            Stack<String> stack = new Stack<String>();
            for (int i = args.length - 1; i >= 1; --i) {
                stack.push(args[i]);
            }
            if (!command.hasPermission(sender)) {
                sender.sendMessage(this.plugin.getLang().fetchLang("permissions.insufficient"));
                return false;
            }
            if (!command.canConsoleExec() && !(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getLang().fetchLang("permissions.console-cannot-exec"));
                return false;
            }
            if (!command.isInAcceptedParamRange(stack)) {
                sender.sendMessage(this.plugin.getLang().fetchLang("command.wrong-arg-length"));
                return false;
            }
            try {
                command.execute(sender, stack);
                return true;
            }
            catch (InvalidArgumentException e2) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + e2.getProblem());
                return false;
            }
        }
        sender.sendMessage(this.plugin.getLang().fetchLang("command.unknown"));
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (args.length == 0) {
            for (TerraCommand terraCommand : this.commands) {
                if (!terraCommand.hasPermission(commandSender)) continue;
                options.add(terraCommand.aliases.get(0));
            }
        } else if (args.length == 1) {
            block1: for (TerraCommand terraCommand : this.commands) {
                if (!terraCommand.hasPermission(commandSender)) continue;
                for (String a2 : terraCommand.aliases) {
                    if (!a2.startsWith(args[0].toLowerCase(Locale.ENGLISH))) continue;
                    options.add(terraCommand.aliases.get(0));
                    continue block1;
                }
            }
        } else {
            for (TerraCommand terraCommand : this.commands) {
                if (!terraCommand.matchCommand(args[0].toLowerCase(Locale.ENGLISH))) continue;
                for (TerraCommandArgument<?> arg : terraCommand.parameters) {
                    options.addAll(arg.getTabOptions(args));
                }
                break;
            }
        }
        return options;
    }
}

