/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.populators;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.noise.FastNoise;

public class AmethystGeodePopulator {
    private final int geodeRadius;
    private final double frequency;
    private final int minDepth;
    private final int minDepthBelowSurface;

    public AmethystGeodePopulator(int geodeRadius, double frequency, int minDepth, int minDepthBelowSurface) {
        this.geodeRadius = geodeRadius;
        this.frequency = TConfig.c.FEATURE_ORES_ENABLED ? frequency : 0.0;
        this.minDepth = minDepth;
        this.minDepthBelowSurface = minDepthBelowSurface;
    }

    public static void placeGeode(int seed, float r, @NotNull SimpleBlock block) {
        if (r <= 1.0f) {
            return;
        }
        ArrayList<SimpleBlock> amethystBlocks = new ArrayList<SimpleBlock>();
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -r; x <= r; x += 1.0f) {
            for (float y = -r; y <= r; y += 1.0f) {
                for (float z = -r; z <= r; z += 1.0f) {
                    double noiseVal;
                    SimpleBlock rel = block.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double outerCrust = (Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) / Math.pow(r, 2.0);
                    double innerCrust = (Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) / Math.pow((double)r - 1.0, 2.0);
                    double amethystCrust = (Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) / Math.pow((double)r - 2.2, 2.0);
                    double airHollower = (Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) / Math.pow((double)r - 3.3, 2.0);
                    if (airHollower <= (noiseVal = 1.0 + 0.4 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()))) {
                        if (BlockUtils.isWet(rel)) {
                            rel.setType(Material.WATER);
                            continue;
                        }
                        rel.setType(Material.CAVE_AIR);
                        continue;
                    }
                    if (!rel.isSolid()) continue;
                    if (amethystCrust <= noiseVal) {
                        rel.setType(Material.AMETHYST_BLOCK, Material.BUDDING_AMETHYST);
                        amethystBlocks.add(rel);
                        continue;
                    }
                    if (innerCrust <= noiseVal) {
                        rel.setType(Material.CALCITE);
                        continue;
                    }
                    if (!(outerCrust <= noiseVal)) continue;
                    rel.setType(Material.SMOOTH_BASALT);
                }
            }
        }
        for (SimpleBlock rel : amethystBlocks) {
            for (BlockFace face : BlockUtils.sixBlockFaces) {
                SimpleBlock target;
                if (GenUtils.chance(1, 6) || !BlockUtils.isAir((target = rel.getRelative(face)).getType()) || !GenUtils.chance(1, 6)) continue;
                new DirectionalBuilder(Material.AMETHYST_CLUSTER).setFacing(face).apply(target);
            }
        }
    }

    public void populate(@NotNull TerraformWorld world, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        if (GenUtils.chance(random, (int)(this.frequency * 10000.0), 10000)) {
            int z;
            int x = GenUtils.randInt(random, 0, 15) + data.getChunkX() * 16;
            int upperHeightRange = GenUtils.getHighestGround(data, x, z = GenUtils.randInt(random, 0, 15) + data.getChunkZ() * 16) - this.minDepthBelowSurface;
            if (upperHeightRange > this.minDepth) {
                upperHeightRange = this.minDepth;
            }
            if ((upperHeightRange = Math.min(world.getBiomeBank(x, z).getHandler().getMaxHeightForCaves(world, x, z), upperHeightRange)) < 14) {
                return;
            }
            int y = GenUtils.randInt(random, 14, upperHeightRange);
            AmethystGeodePopulator.placeGeode(random.nextInt(9999), this.geodeRadius, new SimpleBlock(data, x, y, z));
        }
    }
}

