/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.populators;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class OrePopulator {
    private final BlockData type;
    private final int baseChance;
    private final int maxOreSize;
    private final int minOreSize;
    private final int maxNumberOfVeins;
    private final int peakSpawnChanceHeight;
    private final int maxSpawnHeight;
    private final Set<BiomeBank> requiredBiomes;
    private final int maxDistance;
    private final boolean ignorePeakSpawnChance;
    private int minRange;
    private static final ConcurrentHashMap<TerraformWorld, FastNoise> privateNoiseCache = new ConcurrentHashMap();

    public OrePopulator(Material type, int baseChance, int maxOreSize, int maxNumberOfVeins, int peakSpawnChanceHeight, int maxSpawnHeight, boolean ignorePeakSpawnChance, BiomeBank ... requiredBiomes) {
        this.type = Bukkit.createBlockData((Material)type);
        this.baseChance = baseChance;
        this.maxOreSize = maxOreSize;
        this.minOreSize = maxOreSize / 2;
        this.maxNumberOfVeins = maxNumberOfVeins;
        this.peakSpawnChanceHeight = peakSpawnChanceHeight;
        this.maxSpawnHeight = maxSpawnHeight;
        this.requiredBiomes = Set.of(requiredBiomes);
        this.ignorePeakSpawnChance = ignorePeakSpawnChance;
        this.minRange = TerraformGeneratorPlugin.injector.getMinY() + 1;
        this.maxDistance = Math.max(Math.abs(this.minRange - peakSpawnChanceHeight), Math.abs(maxSpawnHeight - peakSpawnChanceHeight));
    }

    public OrePopulator(Material type, int baseChance, int maxOreSize, int maxNumberOfVeins, int minRange, int peakSpawnChanceHeight, int maxSpawnHeight, boolean ignorePeakSpawnChance, BiomeBank ... requiredBiomes) {
        this.type = Bukkit.createBlockData((Material)type);
        this.baseChance = baseChance;
        this.maxOreSize = maxOreSize;
        this.minOreSize = maxOreSize / 2;
        this.maxNumberOfVeins = TConfig.c.FEATURE_ORES_ENABLED ? maxNumberOfVeins : 0;
        this.minRange = minRange;
        this.peakSpawnChanceHeight = peakSpawnChanceHeight;
        this.maxSpawnHeight = maxSpawnHeight;
        this.requiredBiomes = Set.of(requiredBiomes);
        this.ignorePeakSpawnChance = ignorePeakSpawnChance;
        this.maxDistance = Math.max(Math.abs(minRange - peakSpawnChanceHeight), Math.abs(maxSpawnHeight - peakSpawnChanceHeight));
    }

    public void populate(@NotNull TerraformWorld world, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        BiomeBank b2;
        if (this.requiredBiomes.size() > 0 && !this.requiredBiomes.contains((Object)(b2 = BiomeBank.getBiomeSectionFromChunk(world, data.getChunkX(), data.getChunkZ()).getBiomeBank()))) {
            return;
        }
        for (int i = 0; i < this.maxNumberOfVeins; ++i) {
            int distance;
            if (!GenUtils.chance(random, this.baseChance, 100)) continue;
            int x = GenUtils.randInt(random, 0, 15) + data.getChunkX() * 16;
            int z = GenUtils.randInt(random, 0, 15) + data.getChunkZ() * 16;
            int range = this.maxSpawnHeight;
            if (this.minRange > range) continue;
            if (this.minRange < world.minY) {
                this.minRange = world.minY;
            }
            int y = GenUtils.randInt(random, this.minRange + 64, range + 64) - 64;
            if (!this.ignorePeakSpawnChance && !GenUtils.chance((int)Math.round(100.0 * (1.0 - (double)((float)(distance = Math.abs(y - this.peakSpawnChanceHeight)) / (float)this.maxDistance))), 100)) continue;
            this.placeOre(Objects.hash(world.getSeed(), 7118794), data, x, y, z);
        }
    }

    public void placeOre(int seed, @NotNull PopulatorDataAbstract data, int coreX, int coreY, int coreZ) {
        double size = GenUtils.randDouble(new Random(seed), this.minOreSize, this.maxOreSize);
        double radius = Math.pow(0.75 * size * 0.3183098861837907, 0.3333333333333333);
        if (radius <= 0.0) {
            return;
        }
        if (radius <= 0.5) {
            data.setBlockData(coreX, coreY, coreZ, GenUtils.randChoice(new Random(seed), new BlockData[]{this.type}));
            return;
        }
        FastNoise noise = privateNoiseCache.get(data.getTerraformWorld());
        if (noise == null) {
            noise = new FastNoise(seed);
            noise.SetNoiseType(FastNoise.NoiseType.Simplex);
            noise.SetFrequency(0.09f);
            privateNoiseCache.put(data.getTerraformWorld(), noise);
        }
        ArrayDeque<Long> bfsQueue = new ArrayDeque<Long>();
        HashSet<Integer> visited = new HashSet<Integer>();
        visited.add(Objects.hash(0, 0, 0));
        bfsQueue.add(0L);
        while (bfsQueue.size() > 0) {
            long v = (Long)bfsQueue.remove();
            short rZ = (short)(v & 0xFFFFL);
            short rY = (short)(v >> 16 & 0xFFFFL);
            short rX = (short)(v >> 32 & 0xFFFFL);
            for (BlockFace face : BlockUtils.sixBlockFaces) {
                double equationResult;
                long nX = rX + face.getModX();
                long nY = rY + face.getModY();
                long nZ = rZ + face.getModZ();
                int hash = Objects.hash(nX, nY, nZ);
                if (!visited.add(hash) || (long)coreY + nY <= (long)TerraformGeneratorPlugin.injector.getMinY() || (long)coreY + nY >= (long)TerraformGeneratorPlugin.injector.getMaxY() || !((equationResult = Math.pow(nX, 2.0) / Math.pow(radius, 2.0) + Math.pow(nY, 2.0) / Math.pow(radius, 2.0) + Math.pow(nZ, 2.0) / Math.pow(radius, 2.0)) <= 1.0 + 0.7 * (double)noise.GetNoise(nX + (long)coreX, nY + (long)coreY, nZ + (long)coreZ))) continue;
                bfsQueue.add(nZ | nY << 16 | nX << 32);
            }
            int x = rX + coreX;
            int y = rY + coreY;
            int z = rZ + coreZ;
            Material replaced = data.getType(x, y, z);
            if (replaced == Material.STONE) {
                data.setBlockData(x, y, z, this.type);
                continue;
            }
            if (this.type.getMaterial() == Material.DEEPSLATE && BlockUtils.ores.contains(replaced)) {
                data.setBlockData(x, y, z, BlockUtils.deepSlateVersion(replaced));
                continue;
            }
            if (replaced != Material.DEEPSLATE) continue;
            data.setBlockData(x, y, z, BlockUtils.deepSlateVersion(this.type.getMaterial()));
        }
    }

    public Material getType() {
        return this.type.getMaterial();
    }

    public int getBaseChance() {
        return this.baseChance;
    }

    public int getMaxOreSize() {
        return this.maxOreSize;
    }

    public int getMinOreSize() {
        return this.minOreSize;
    }

    public int getMaxNumberOfVeins() {
        return this.maxNumberOfVeins;
    }

    public int getPeakSpawnChanceHeight() {
        return this.peakSpawnChanceHeight;
    }

    public int getMaxSpawnHeight() {
        return this.maxSpawnHeight;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public Set<BiomeBank> getRequiredBiomes() {
        return this.requiredBiomes;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public boolean isIgnorePeakSpawnChance() {
        return this.ignorePeakSpawnChance;
    }
}

