/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.reflection.PrivateFieldHandler;

public class Pre14PrivateFieldHandler
extends PrivateFieldHandler {
    @Nullable
    private static final MethodHandle FIELD_MODIFIERS;

    @Override
    public void injectField(@NotNull Object obj, @NotNull String field, Object value) throws Throwable {
        Field targetField = obj.getClass().getField(field);
        targetField.setAccessible(true);
        FIELD_MODIFIERS.invoke(targetField, targetField.getModifiers() & 0xFFFFFFEF);
        targetField.set(obj, value);
        TerraformGeneratorPlugin.logger.info("Pre Java 14 detected.");
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle fieldModifiers = null;
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            fieldModifiers = lookup.unreflectSetter(modifiersField);
        }
        catch (IllegalAccessException | NoSuchFieldException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
        FIELD_MODIFIERS = fieldModifiers;
    }
}

