/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.spigot.v1_21_R6;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.NaturalSpawnType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.spigot.v1_21_R6.CustomBiomeHandler;
import org.terraform.spigot.v1_21_R6.LootTableTranslator;
import org.terraform.utils.version.TerraformFieldHandler;

public class PopulatorDataICA
extends PopulatorDataICABiomeWriterAbstract {
    private final PopulatorDataAbstract parent;
    private final IChunkAccess ica;
    private final int chunkX;
    private final int chunkZ;
    private final WorldServer ws;
    private final TerraformWorld tw;

    public PopulatorDataICA(PopulatorDataAbstract parent, TerraformWorld tw, WorldServer ws, IChunkAccess ica, int chunkX, int chunkZ) {
        this.ica = ica;
        this.parent = parent;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.ws = ws;
        this.tw = tw;
    }

    @Override
    @NotNull
    public Material getType(int x, int y, int z) {
        IBlockData ibd = this.ica.a_(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd).getMaterial();
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        IBlockData ibd = this.ica.a_(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd);
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, CustomBiomeType cbt, Biome fallback) {
        Holder targetBiome;
        IRegistry<BiomeBase> biomeRegistry = CustomBiomeHandler.getBiomeRegistry();
        if (cbt == CustomBiomeType.NONE) {
            targetBiome = CraftBiome.bukkitToMinecraftHolder((Biome)fallback);
        } else {
            ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)cbt);
            Optional optHolder = biomeRegistry.a(rkey);
            if (optHolder.isEmpty()) {
                TerraformGeneratorPlugin.logger.error("Custom biome was not found in the vanilla registry!");
                targetBiome = CraftBiome.bukkitToMinecraftHolder((Biome)fallback);
            } else {
                targetBiome = (Holder)optHolder.get();
            }
        }
        this.ica.setBiome(rawX >> 2, rawY >> 2, rawZ >> 2, targetBiome);
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, Biome biome) {
        this.ica.setBiome(rawX >> 2, rawY >> 2, rawZ >> 2, CraftBiome.bukkitToMinecraftHolder((Biome)biome));
    }

    @Override
    public void setType(int x, int y, int z, @NotNull Material type) {
        this.ica.a(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), 3);
    }

    @Override
    public void setBlockData(int x, int y, int z, @NotNull BlockData data) {
        this.ica.a(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), 3);
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        return this.parent.getBiome(rawX, rawZ);
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, EntityType type) {
        this.parent.addEntity(rawX, rawY, rawZ, type);
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        this.parent.setSpawner(rawX, rawY, rawZ, type);
    }

    @Override
    public void lootTableChest(int x, int y, int z, TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntity te = this.ica.c_(pos);
        if (te instanceof TileEntityLootable) {
            TileEntityLootable rcb = (TileEntityLootable)te;
            rcb.a(LootTableTranslator.translationMap.get((Object)table));
        } else if (te instanceof BrushableBlockEntity) {
            BrushableBlockEntity bbe = (BrushableBlockEntity)te;
            bbe.a(LootTableTranslator.translationMap.get((Object)table), this.tw.getHashedRand(x, y, z).nextLong());
        }
    }

    @Override
    public void registerNaturalSpawns(@NotNull NaturalSpawnType type, int x0, int y0, int z0, int x1, int y1, int z1) {
        ResourceKey structureKey = switch (type) {
            default -> throw new MatchException(null, null);
            case NaturalSpawnType.GUARDIAN -> BuiltinStructures.l;
            case NaturalSpawnType.PILLAGER -> BuiltinStructures.a;
            case NaturalSpawnType.WITCH -> BuiltinStructures.j;
        };
        IRegistry featureRegistry = (IRegistry)MinecraftServer.getServer().bg().a(Registries.bm).orElseThrow();
        Structure structureFeature = (Structure)featureRegistry.c(structureKey);
        try {
            Class<OceanMonumentPieces.h> oceanMonumentPiecesHClass = OceanMonumentPieces.h.class;
            StructurePiece customBoundPiece = (StructurePiece)oceanMonumentPiecesHClass.getConstructor(RandomSource.class, Integer.TYPE, Integer.TYPE, EnumDirection.class).newInstance(RandomSource.a(), x0, z0, EnumDirection.a);
            PiecesContainer container = new PiecesContainer(List.of(customBoundPiece));
            StructureStart start = new StructureStart(structureFeature, new ChunkCoordIntPair(this.chunkX, this.chunkZ), 0, container);
            TerraformFieldHandler cachedBoundingBox = new TerraformFieldHandler(StructureStart.class, "cachedBoundingBox", "h");
            cachedBoundingBox.field.set(start, new StructureBoundingBox(x0, y0, z0, x1, y1, z1));
            this.ica.a(structureFeature, start);
            this.ica.a(structureFeature, new ChunkCoordIntPair(this.chunkX, this.chunkZ).a());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
    }

    @Override
    public void spawnMinecartWithChest(int x, int y, int z, TerraLootTable table, @NotNull Random random) {
        EntityMinecartChest minecartChest = (EntityMinecartChest)EntityTypes.A.a((World)this.ws.getMinecraftWorld(), EntitySpawnReason.b);
        if (minecartChest != null) {
            minecartChest.a_((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
            minecartChest.a(LootTableTranslator.translationMap.get((Object)table), random.nextLong());
            this.ws.b((Entity)minecartChest);
        }
    }

    @Override
    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }
}

