/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.structure.MultiMegaChunkStructurePopulator;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructurePopulator;
import org.terraform.structure.StructureType;
import org.terraform.structure.ancientcity.AncientCityPopulator;
import org.terraform.structure.catacombs.CatacombsPopulator;
import org.terraform.structure.caves.LargeCavePopulator;
import org.terraform.structure.mineshaft.BadlandsMinePopulator;
import org.terraform.structure.mineshaft.MineshaftPopulator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.pillager.outpost.OutpostPopulator;
import org.terraform.structure.pyramid.PyramidPopulator;
import org.terraform.structure.small.DesertWellPopulator;
import org.terraform.structure.small.WitchHutPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.small.dungeon.SmallDungeonPopulator;
import org.terraform.structure.small.igloo.IglooPopulator;
import org.terraform.structure.small.ruinedportal.RuinedPortalPopulator;
import org.terraform.structure.small.shipwreck.ShipwreckPopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.structure.trailruins.TrailRuinsPopulator;
import org.terraform.structure.trialchamber.TrialChamberPopulator;
import org.terraform.structure.village.VillagePopulator;
import org.terraform.structure.villagehouse.VillageHousePopulator;
import org.terraform.structure.warmoceanruins.WarmOceanRuinsPopulator;
import org.terraform.utils.version.Version;

public class StructureRegistry {
    public static final Map<StructureType, SingleMegaChunkStructurePopulator[]> largeStructureRegistry = new EnumMap<StructureType, SingleMegaChunkStructurePopulator[]>(StructureType.class);
    public static final Collection<MultiMegaChunkStructurePopulator> smallStructureRegistry = new ArrayList<MultiMegaChunkStructurePopulator>();
    private static final HashMap<MegaChunkKey, SingleMegaChunkStructurePopulator[]> queryCache = new HashMap();

    public static void init() {
        StructureRegistry.registerStructure(StructureType.VILLAGE, new VillageHousePopulator());
        StructureRegistry.registerStructure(StructureType.VILLAGE, new VillagePopulator());
        StructureRegistry.registerStructure(StructureType.VILLAGE, new OutpostPopulator());
        StructureRegistry.registerStructure(StructureType.MEGA_DUNGEON, new PyramidPopulator());
        StructureRegistry.registerStructure(StructureType.MEGA_DUNGEON, new MonumentPopulator());
        StructureRegistry.registerStructure(StructureType.MEGA_DUNGEON, new StrongholdPopulator());
        StructureRegistry.registerStructure(StructureType.MEGA_DUNGEON, new MansionPopulator());
        StructureRegistry.registerStructure(StructureType.MEGA_DUNGEON, new AncientCityPopulator());
        if (Version.VERSION.isAtLeast(Version.v1_21)) {
            StructureRegistry.registerStructure(StructureType.MEGA_DUNGEON, new TrialChamberPopulator());
        }
        StructureRegistry.registerStructure(StructureType.LARGE_CAVE, new LargeCavePopulator());
        StructureRegistry.registerStructure(StructureType.LARGE_MISC, new MineshaftPopulator());
        StructureRegistry.registerStructure(StructureType.LARGE_MISC, new CatacombsPopulator());
        StructureRegistry.registerStructure(StructureType.LARGE_MISC, new BadlandsMinePopulator());
        StructureRegistry.registerStructure(StructureType.LARGE_MISC, new WarmOceanRuinsPopulator());
        StructureRegistry.registerStructure(StructureType.LARGE_MISC, new TrailRuinsPopulator());
        StructureRegistry.registerStructure(StructureType.SMALL, new SmallDungeonPopulator());
        StructureRegistry.registerStructure(StructureType.SMALL, new ShipwreckPopulator());
        StructureRegistry.registerStructure(StructureType.SMALL, new BuriedTreasurePopulator());
        StructureRegistry.registerStructure(StructureType.SMALL, new RuinedPortalPopulator());
        StructureRegistry.registerStructure(StructureType.SMALL, new IglooPopulator());
        StructureRegistry.registerStructure(StructureType.SMALL, new DesertWellPopulator());
        StructureRegistry.registerStructure(StructureType.SMALL, new WitchHutPopulator());
    }

    @Nullable
    public static StructureType getStructureType(@NotNull Class<? extends SingleMegaChunkStructurePopulator> populatorType) {
        for (Map.Entry<StructureType, SingleMegaChunkStructurePopulator[]> entry : largeStructureRegistry.entrySet()) {
            for (SingleMegaChunkStructurePopulator pops : entry.getValue()) {
                if (!populatorType.isInstance(pops)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @NotNull
    public static SingleMegaChunkStructurePopulator[] getLargeStructureForMegaChunk(@NotNull TerraformWorld tw, @NotNull MegaChunk mc) {
        MegaChunkKey key;
        if (queryCache.size() > 50) {
            queryCache.clear();
        }
        if (queryCache.containsKey(key = new MegaChunkKey(tw, mc))) {
            return queryCache.get(key);
        }
        Random structRand = tw.getHashedRand(9L, mc.getX(), mc.getZ());
        int maxStructures = 3;
        SingleMegaChunkStructurePopulator[] pops = new SingleMegaChunkStructurePopulator[maxStructures];
        int size = 0;
        if (largeStructureRegistry.containsKey((Object)StructureType.MEGA_DUNGEON) && largeStructureRegistry.get((Object)StructureType.MEGA_DUNGEON).length > 0) {
            SingleMegaChunkStructurePopulator[] available;
            for (SingleMegaChunkStructurePopulator singleMegaChunkStructurePopulator : available = (SingleMegaChunkStructurePopulator[])StructureRegistry.shuffleArray(structRand, largeStructureRegistry.get((Object)StructureType.MEGA_DUNGEON))) {
                int[] coords = mc.getCenterBiomeSectionBlockCoords();
                if (coords == null || !TConfig.areStructuresEnabled() || !singleMegaChunkStructurePopulator.canSpawn(tw, coords[0] >> 4, coords[1] >> 4, mc.getCenterBiomeSection(tw).getBiomeBank())) continue;
                pops[size] = singleMegaChunkStructurePopulator;
                ++size;
                break;
            }
        }
        StructureType[] types = new StructureType[]{StructureType.LARGE_CAVE, StructureType.VILLAGE, StructureType.LARGE_MISC};
        for (StructureType structureType : types = (StructureType[])StructureRegistry.shuffleArray(structRand, (Object[])types)) {
            if (largeStructureRegistry.containsKey((Object)structureType)) {
                for (SingleMegaChunkStructurePopulator pop : largeStructureRegistry.get((Object)structureType)) {
                    int[] coords = mc.getCenterBiomeSectionBlockCoords();
                    if (!TConfig.areStructuresEnabled() || !pop.canSpawn(tw, coords[0] >> 4, coords[1] >> 4, mc.getCenterBiomeSection(tw).getBiomeBank())) continue;
                    pops[size] = pop;
                    ++size;
                    break;
                }
            }
            if (size >= maxStructures) break;
        }
        SingleMegaChunkStructurePopulator[] singleMegaChunkStructurePopulatorArray = new SingleMegaChunkStructurePopulator[size];
        System.arraycopy(pops, 0, singleMegaChunkStructurePopulatorArray, 0, size);
        queryCache.put(key, singleMegaChunkStructurePopulatorArray);
        return singleMegaChunkStructurePopulatorArray;
    }

    private static Object @NotNull [] shuffleArray(@NotNull Random rand, Object[] ar) {
        if ((ar = (Object[])ar.clone()).length == 0) {
            return ar;
        }
        for (int i = ar.length - 1; i > 0; --i) {
            int index = rand.nextInt(i + 1);
            Object a2 = ar[index];
            ar[index] = ar[i];
            ar[i] = a2;
        }
        return ar;
    }

    public static void registerStructure(StructureType type, @NotNull StructurePopulator pop) {
        if (!pop.isEnabled()) {
            return;
        }
        if (pop instanceof SingleMegaChunkStructurePopulator) {
            SingleMegaChunkStructurePopulator[] pops = new SingleMegaChunkStructurePopulator[]{(SingleMegaChunkStructurePopulator)pop};
            if (largeStructureRegistry.containsKey((Object)type)) {
                SingleMegaChunkStructurePopulator[] existing = largeStructureRegistry.get((Object)type);
                SingleMegaChunkStructurePopulator[] old = pops;
                pops = new SingleMegaChunkStructurePopulator[existing.length + 1];
                System.arraycopy(existing, 0, pops, 0, existing.length);
                System.arraycopy(old, 0, pops, existing.length, 1);
            }
            TerraformGeneratorPlugin.logger.info("[Structure Registry] Registered Large Structure: " + pop.getClass().getSimpleName());
            largeStructureRegistry.put(type, pops);
        } else if (pop instanceof MultiMegaChunkStructurePopulator) {
            TerraformGeneratorPlugin.logger.info("[Structure Registry] Registered Small Structure: " + pop.getClass().getSimpleName());
            smallStructureRegistry.add((MultiMegaChunkStructurePopulator)pop);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static StructurePopulator @NotNull [] getAllPopulators() {
        int size = smallStructureRegistry.size();
        for (StructurePopulator[] structurePopulatorArray : largeStructureRegistry.values()) {
            size += structurePopulatorArray.length;
        }
        StructurePopulator[] pops = new StructurePopulator[size];
        boolean bl = false;
        Iterator<MultiMegaChunkStructurePopulator> iterator = smallStructureRegistry.iterator();
        while (iterator.hasNext()) {
            void var2_4;
            StructurePopulator pop;
            pops[var2_4] = pop = (StructurePopulator)iterator.next();
            ++var2_4;
        }
        iterator = largeStructureRegistry.values().iterator();
        while (iterator.hasNext()) {
            StructurePopulator[] types;
            StructurePopulator[] structurePopulatorArray = types = (StructurePopulator[])iterator.next();
            int n = structurePopulatorArray.length;
            for (int i = 0; i < n; ++i) {
                void var2_5;
                StructurePopulator pop;
                pops[var2_5] = pop = structurePopulatorArray[i];
                ++var2_5;
            }
        }
        return pops;
    }

    private static class MegaChunkKey {
        private final TerraformWorld tw;
        private final MegaChunk mc;

        public MegaChunkKey(TerraformWorld tw, MegaChunk mc) {
            this.tw = tw;
            this.mc = mc;
        }

        public int hashCode() {
            return Objects.hash(this.tw.hashCode(), this.mc.getX(), this.mc.getZ());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MegaChunkKey)) {
                return false;
            }
            MegaChunkKey other = (MegaChunkKey)obj;
            return this.tw.equals(other.tw) && this.mc.getX() == other.mc.getX() && this.mc.getZ() == other.mc.getZ();
        }
    }
}

