/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.ancientcity.AncientCityAbstractRoomPopulator;
import org.terraform.structure.ancientcity.AncientCitySchematicParser;
import org.terraform.structure.ancientcity.AncientCityUtils;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomLayoutGenerator;

public class AncientCityAltarPopulator
extends AncientCityAbstractRoomPopulator {
    public AncientCityAltarPopulator(TerraformWorld tw, HashSet<SimpleLocation> occupied, RoomLayoutGenerator gen, Random rand, boolean forceSpawn, boolean unique) {
        super(tw, gen, rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        super.populate(data, room);
        for (Map.Entry<Wall, Integer> entry : this.effectiveRoom.getFourWalls(data, 0).entrySet()) {
            int pillarSpacing;
            Wall w = entry.getKey();
            Wall center = null;
            boolean shouldPlaceAltar = true;
            for (int i = 0; i < entry.getValue(); ++i) {
                if (i == entry.getValue() / 2) {
                    center = w;
                }
                if (this.containsPaths.contains(w)) {
                    shouldPlaceAltar = false;
                    break;
                }
                w = w.getLeft();
            }
            if (!shouldPlaceAltar) continue;
            String altarFile = entry.getValue() < 7 ? "ancient-city/ancient-city-altar-small" : (entry.getValue() < 11 ? "ancient-city/ancient-city-altar-medium" : "ancient-city/ancient-city-altar-large");
            try {
                TerraSchematic schema = TerraSchematic.load(altarFile, center);
                schema.parser = new AncientCitySchematicParser();
                schema.setFace(center.getDirection());
                schema.apply();
            }
            catch (FileNotFoundException e2) {
                TerraformGeneratorPlugin.logger.stackTrace(e2);
            }
            for (int i = pillarSpacing = entry.getValue() / 3; i < Math.min(this.effectiveRoom.getWidthX(), this.effectiveRoom.getWidthZ()); i += 3) {
                center.getFront(i).getLeft(pillarSpacing).LPillar(this.rand.nextInt(room.getHeight() / 3), AncientCityUtils.deepslateBricks);
                center.getFront(i).getRight(pillarSpacing).LPillar(this.rand.nextInt(room.getHeight() / 3), AncientCityUtils.deepslateBricks);
            }
            super.sculkUp(this.tw, data, this.effectiveRoom);
            return;
        }
        super.sculkUp(this.tw, data, this.effectiveRoom);
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() % 2 == 1 || room.getWidthZ() % 2 == 1;
    }
}

