/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.structure.ancientcity.AncientCityAbstractRoomPopulator;
import org.terraform.structure.ancientcity.AncientCityResearchBasementHandler;
import org.terraform.structure.ancientcity.AncientCityUtils;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.StairwayBuilder;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.version.V_1_19;
import org.terraform.utils.version.Version;

public class AncientCityCenterPlatformPopulator
extends AncientCityAbstractRoomPopulator {
    public AncientCityCenterPlatformPopulator(TerraformWorld tw, HashSet<SimpleLocation> occupied, RoomLayoutGenerator gen, Random rand, boolean forceSpawn, boolean unique) {
        super(tw, gen, rand, forceSpawn, unique);
        this.doCarve = false;
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        CubeRoom fireBox;
        int modZ;
        int modX;
        super.populate(data, room);
        for (Map.Entry<Wall, Integer> entry : this.effectiveRoom.getFourWalls(data, 0).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                if (i > 2 && i < entry.getValue() - 3 && i % 3 == 0) {
                    if (!this.containsPaths.contains(w.get())) {
                        w.lsetType(Material.CHISELED_DEEPSLATE);
                        w.getUp().CorrectMultipleFacing(2);
                        w.getUp().LPillar(2, Material.DEEPSLATE_BRICK_WALL);
                        w.getUp(3).lsetType(Material.CHISELED_DEEPSLATE);
                        new SlabBuilder(Material.DEEPSLATE_BRICK_SLAB).setType(Slab.Type.TOP).lapply(w.getUp(3).getRear());
                        w.getRear().getUp(4).lsetType(Material.DEEPSLATE_BRICK_WALL);
                        w.getRear().getUp(4).CorrectMultipleFacing(1);
                    }
                    for (BlockFace dir : BlockUtils.getAdjacentFaces(w.getDirection())) {
                        Wall rel = w.getRelative(dir);
                        if (this.containsPaths.contains(rel.get())) continue;
                        rel.lsetType(Material.DEEPSLATE_BRICKS);
                        new StairBuilder(Material.DEEPSLATE_BRICK_STAIRS).setFacing(rel.getDirection().getOppositeFace()).lapply(rel.getFront()).setFacing(dir).lapply(rel.getUp()).setFacing(dir.getOppositeFace()).lapply(rel.getUp(2)).lapply(rel.getUp(4).getRear());
                        rel.getUp(3).lsetType(Material.DEEPSLATE_BRICKS);
                        new StairBuilder(Material.DEEPSLATE_BRICK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(rel.getDirection()).lapply(rel.getUp(3).getRear()).setFacing(rel.getDirection().getOppositeFace()).lapply(rel.getUp(3).getFront());
                    }
                }
                w = w.getLeft();
            }
        }
        int y = this.effectiveRoom.getY();
        for (int[] corner : this.effectiveRoom.getAllCorners(2)) {
            int x = corner[0];
            int z = corner[1];
            this.spawnLargePillar(new SimpleBlock(data, x, y, z), room);
        }
        BlockFace blockFace = BlockUtils.getDirectBlockFace(this.getRand());
        if (BlockUtils.getAxisFromBlockFace(blockFace) == Axis.X) {
            modX = 3;
            modZ = 17;
            fireBox = this.effectiveRoom.getCloneSubsetRoom(8, 2);
        } else {
            modZ = 3;
            modX = 17;
            fireBox = this.effectiveRoom.getCloneSubsetRoom(2, 8);
        }
        int[] lowerCorner = fireBox.getLowerCorner(6);
        int[] upperCorner = fireBox.getUpperCorner(6);
        for (int nx = lowerCorner[0]; nx <= upperCorner[0]; ++nx) {
            for (int nz = lowerCorner[1]; nz <= upperCorner[1]; ++nz) {
                data.setType(nx, fireBox.getY(), nz, Material.SOUL_SAND);
                data.setType(nx, fireBox.getY() + 1, nz, Material.SOUL_FIRE);
            }
        }
        for (Map.Entry<Wall, Integer> entry : fireBox.getFourWalls(data, 5).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                w.Pillar(GenUtils.randInt(this.rand, 1, 3), AncientCityUtils.deepslateBricks);
                if (BlockUtils.getAxisFromBlockFace(w.getDirection()) == BlockUtils.getAxisFromBlockFace(blockFace)) {
                    w.getRear().setType(AncientCityUtils.deepslateBricks);
                    w.getRear(2).setType(AncientCityUtils.deepslateBricks);
                    if (GenUtils.chance(this.rand, 1, 30)) {
                        BlockUtils.placeCandle(w.getRear().getUp(), this.rand.nextInt(3) + 1, true);
                    }
                    if (GenUtils.chance(this.rand, 1, 30)) {
                        BlockUtils.placeCandle(w.getRear(2).getUp(), this.rand.nextInt(3) + 1, true);
                    }
                    if (this.rand.nextBoolean()) {
                        w.getRear(3).setType(AncientCityUtils.deepslateBricks);
                        if (GenUtils.chance(this.rand, 1, 30)) {
                            BlockUtils.placeCandle(w.getRear(3).getUp(), this.rand.nextInt(3) + 1, true);
                        }
                        if (this.rand.nextBoolean()) {
                            new StairBuilder(Material.COBBLED_DEEPSLATE_STAIRS, Material.POLISHED_DEEPSLATE_STAIRS).setFacing(w.getDirection()).apply(w.getRear(4));
                        }
                    } else if (this.rand.nextBoolean()) {
                        new StairBuilder(Material.COBBLED_DEEPSLATE_STAIRS, Material.POLISHED_DEEPSLATE_STAIRS).setFacing(w.getDirection()).apply(w.getRear(3));
                    }
                }
                w = w.getLeft();
            }
        }
        new CylinderBuilder(new Random(), room.getCenterSimpleBlock(data).getUp(13), AncientCityUtils.deepslateBricks).setRX(modX).setRZ(modZ).setRY(20.0f).build();
        this.spawnCentralHead(room.getCenterSimpleBlock(data).getUp(13), blockFace);
        for (BlockFace dir : new BlockFace[]{blockFace, blockFace.getOppositeFace()}) {
            Wall targetStair = new Wall(room.getCenterSimpleBlock(data).getAtY(this.effectiveRoom.getY() + 1).getRelative(dir, 5), dir.getOppositeFace());
            for (int radius = 0; radius <= 14; ++radius) {
                for (BlockFace rel : BlockUtils.getAdjacentFaces(blockFace)) {
                    new StairwayBuilder(Material.COBBLED_DEEPSLATE_STAIRS, Material.POLISHED_DEEPSLATE_STAIRS).setAngled(false).setCarveAirSpace(false).setUpwardsCarveUntilSolid(true).setUpwardsCarveUntilNotSolid(false).setStopAtY(targetStair.getY() + 4).setDownTypes(AncientCityUtils.deepslateBricks).setStairwayDirection(BlockFace.UP).build(targetStair.getRelative(rel, radius));
                }
            }
        }
        CubeRoom basement = new CubeRoom(this.effectiveRoom.getWidthX(), this.effectiveRoom.getWidthZ(), 6, this.effectiveRoom.getX(), this.effectiveRoom.getY() - 6, this.effectiveRoom.getZ());
        AncientCityResearchBasementHandler.populate(this.rand, data, basement, blockFace);
        super.sculkUp(this.tw, data, this.effectiveRoom);
    }

    private void spawnCentralHead(@NotNull SimpleBlock core, @NotNull BlockFace facing) {
        int headHeight = 11;
        int headWidth = 15;
        int generalFuzzSize = 3;
        for (int radius = 0; radius <= headWidth; ++radius) {
            for (BlockFace rel : BlockUtils.getAdjacentFaces(facing)) {
                if (Version.VERSION.isAtLeast(Version.v1_19_4)) {
                    assert (V_1_19.REINFORCED_DEEPSLATE != null);
                    core.getRelative(rel, radius).setType(V_1_19.REINFORCED_DEEPSLATE);
                    core.getUp(headHeight).getRelative(rel, radius).setType(V_1_19.REINFORCED_DEEPSLATE);
                } else if (radius % 2 == 0) {
                    core.getRelative(rel, radius).setType(AncientCityUtils.deepslateTiles);
                    core.getUp(headHeight).getRelative(rel, radius).setType(AncientCityUtils.deepslateTiles);
                } else {
                    core.getRelative(rel, radius).setType(Material.POLISHED_DIORITE, Material.DIORITE);
                    core.getUp(headHeight).getRelative(rel, radius).setType(Material.POLISHED_DIORITE, Material.DIORITE);
                }
                if (radius != headWidth) {
                    core.getRelative(rel, radius).getUp().Pillar(headHeight - 1, Material.AIR);
                }
                this.airWardenBlocks(core.getRelative(rel, radius), facing);
                this.airWardenBlocks(core.getUp(headHeight).getRelative(rel, radius), facing);
                this.airWardenBlocks(core.getUp(1).getRelative(rel, radius), headHeight - 1, facing);
                core.getRelative(rel, radius).getDown().downPillar(GenUtils.randInt(this.rand, generalFuzzSize, generalFuzzSize + 1), AncientCityUtils.deepslateTiles);
                this.airWardenBlocks(core.getRelative(rel, radius).getDown(), facing);
                core.getRelative(rel, radius).getUp(headHeight + 1).Pillar(GenUtils.randInt(this.rand, generalFuzzSize, generalFuzzSize + 1), AncientCityUtils.deepslateTiles);
                if (radius != headWidth) continue;
                if (Version.VERSION.isAtLeast(Version.v1_19_4)) {
                    core.getRelative(rel, radius).Pillar(headHeight, V_1_19.REINFORCED_DEEPSLATE);
                } else {
                    core.getRelative(rel, radius).Pillar(headHeight, true, new Random(), Material.DEEPSLATE_TILES, Material.DIORITE);
                }
                for (int i = -2; i <= headHeight + 2; ++i) {
                    SimpleBlock start = core.getRelative(rel, radius + 1).getUp(i);
                    int maxFuzzSize = GenUtils.randInt(this.rand, generalFuzzSize, generalFuzzSize + 1);
                    if (i >= headHeight / 2 - 1 && i <= headHeight / 2 + 2) {
                        maxFuzzSize += 2;
                    }
                    for (int fuzzSize = 0; fuzzSize < maxFuzzSize; ++fuzzSize) {
                        start.getRelative(rel, fuzzSize).setType(AncientCityUtils.deepslateTiles);
                    }
                }
            }
        }
    }

    private void airWardenBlocks(@NotNull SimpleBlock b2, @NotNull BlockFace dir) {
        this.airWardenBlocks(b2, 1, dir);
    }

    private void airWardenBlocks(@NotNull SimpleBlock b2, int height, @NotNull BlockFace dir) {
        for (int i = 0; i < height; ++i) {
            for (int depth = 1; depth <= 3; ++depth) {
                b2.getUp(i).getRelative(dir, depth).setType(Material.AIR);
                b2.getUp(i).getRelative(dir, -depth).setType(Material.AIR);
            }
        }
    }

    private void spawnLargePillar(@NotNull SimpleBlock core, @NotNull CubeRoom room) {
        SimpleBlock target;
        for (int relX = -2; relX <= 2; ++relX) {
            for (int relZ = -2; relZ <= 2; ++relZ) {
                target = core.getRelative(relX, 1, relZ);
                if (Math.abs(relX) == 2 || Math.abs(relZ) == 2 || relX == 0 && relZ == 0) {
                    target.RPillar(10, new Random(), Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS, Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS, Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS, Material.DEEPSLATE_BRICK_SLAB);
                    continue;
                }
                target.Pillar(10, Material.AIR);
            }
        }
        int bfIndex = 0;
        if (core.getX() < room.getX() && core.getZ() < room.getZ()) {
            bfIndex = 3;
        } else if (core.getX() > room.getX() && core.getZ() < room.getZ()) {
            bfIndex = 5;
        } else if (core.getX() < room.getX() && core.getZ() > room.getZ()) {
            bfIndex = 1;
        } else if (core.getX() > room.getX() && core.getZ() > room.getZ()) {
            bfIndex = 7;
        }
        for (int i = 1; i <= 10; ++i) {
            if (i == 1) {
                target = core.getRelative(BlockUtils.xzPlaneBlockFaces[bfIndex], 2);
                for (int relX = -1; relX <= 1; ++relX) {
                    for (int relZ = -1; relZ <= 1; ++relZ) {
                        target.getRelative(relX, 1, relZ).Pillar(3, Material.AIR);
                    }
                }
            }
            BlockFace face = BlockUtils.xzPlaneBlockFaces[bfIndex];
            Slab bottom = (Slab)Bukkit.createBlockData((Material)Material.DEEPSLATE_BRICK_SLAB);
            bottom.setType(Slab.Type.BOTTOM);
            core.getRelative(face.getModX(), i, face.getModZ()).setBlockData((BlockData)bottom);
            bfIndex = AncientCityCenterPlatformPopulator.getNextIndex(bfIndex);
            face = BlockUtils.xzPlaneBlockFaces[bfIndex];
            Slab top = (Slab)Bukkit.createBlockData((Material)Material.DEEPSLATE_BRICK_SLAB);
            top.setType(Slab.Type.TOP);
            core.getRelative(face.getModX(), i, face.getModZ()).setBlockData((BlockData)top);
            bfIndex = AncientCityCenterPlatformPopulator.getNextIndex(bfIndex);
        }
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Wall target2 = new Wall(core.getUp(10), face).getFront(2);
            target2.getFront().getUp().setType(Material.DEEPSLATE_BRICK_WALL);
            target2.getFront().getDown().getRight().setType(Material.DEEPSLATE_BRICK_WALL);
            target2.getFront().getDown().getLeft().setType(Material.DEEPSLATE_BRICK_WALL);
            target2.getFront().getRight().setType(Material.DEEPSLATE_BRICK_SLAB);
            target2.getFront().getLeft().setType(Material.DEEPSLATE_BRICK_SLAB);
            new StairBuilder(Material.DEEPSLATE_BRICK_STAIRS).setFacing(face).apply(target2.getUp().getRight()).apply(target2.getUp().getLeft());
            new StairBuilder(Material.DEEPSLATE_BRICK_STAIRS).setFacing(face).setHalf(Bisected.Half.TOP).apply(target2.getFront()).apply(target2.getFront().getRight().getDown(2)).apply(target2.getFront().getLeft().getDown(2));
            target2.getUp().getRight(2).setType(Material.DEEPSLATE_BRICK_WALL);
            target2.getUp().getLeft(2).setType(Material.DEEPSLATE_BRICK_WALL);
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

