/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.ancientcity.AncientCityAbstractRoomPopulator;
import org.terraform.structure.ancientcity.AncientCityPillarSchematicParser;
import org.terraform.structure.ancientcity.AncientCityUtils;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class AncientCityLargePillarRoomPopulator
extends AncientCityAbstractRoomPopulator {
    public AncientCityLargePillarRoomPopulator(TerraformWorld tw, HashSet<SimpleLocation> occupied, RoomLayoutGenerator gen, Random rand, boolean forceSpawn, boolean unique) {
        super(tw, gen, rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        this.effectiveRoom = room;
        int[] lowerCorner = this.effectiveRoom.getLowerCorner(0);
        int[] upperCorner = this.effectiveRoom.getUpperCorner(0);
        int y = this.effectiveRoom.getY();
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                SimpleBlock b2 = new SimpleBlock(data, x, y, z);
                if (x == lowerCorner[0] || x == upperCorner[0] || z == lowerCorner[1] || z == upperCorner[1]) {
                    if (!this.rand.nextBoolean()) continue;
                    b2.lsetType(AncientCityUtils.deepslateBricks);
                    continue;
                }
                b2.lsetType(AncientCityUtils.deepslateBricks);
            }
        }
        FastNoise ruinsNoise = NoiseCacheHandler.getNoise(this.tw, NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_ANCIENTCITY_RUINS, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 11L));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.09f);
            return n;
        });
        try {
            Object schema;
            int maxHeight;
            SimpleBlock center = room.getCenterSimpleBlock(data).getUp();
            AncientCityPillarSchematicParser lastParser = null;
            for (maxHeight = 70; maxHeight > 0; --maxHeight) {
                schema = TerraSchematic.load("ancient-city/ancient-city-pillar-segment", center);
                lastParser = new AncientCityPillarSchematicParser();
                ((TerraSchematic)schema).parser = lastParser;
                ((TerraSchematic)schema).setFace(BlockUtils.getDirectBlockFace(this.rand));
                ((TerraSchematic)schema).apply();
                center = center.getUp(3);
                if (lastParser.calculateFailRate() > 0.3f) break;
            }
            for (SimpleBlock b3 : lastParser.getTouchedOffsets()) {
                b3.getUp().LPillar((int)(5.0f * ruinsNoise.GetNoise(b3.getX(), b3.getZ())), AncientCityUtils.deepslateBricks);
            }
            center = room.getCenterSimpleBlock(data).getDown(3);
            lastParser = null;
            for (maxHeight = 70; maxHeight > 0; --maxHeight) {
                schema = TerraSchematic.load("ancient-city/ancient-city-pillar-segment", center);
                lastParser = new AncientCityPillarSchematicParser();
                ((TerraSchematic)schema).parser = lastParser;
                ((TerraSchematic)schema).setFace(BlockUtils.getDirectBlockFace(this.rand));
                ((TerraSchematic)schema).apply();
                center = center.getDown(3);
                if (lastParser.calculateFailRate() > 0.3f || center.getY() <= TerraformGeneratorPlugin.injector.getMinY()) break;
            }
            for (SimpleBlock b3 : lastParser.getTouchedOffsets()) {
                b3.getDown(3).downLPillar(new Random(), (int)Math.abs(5.0f * ruinsNoise.GetNoise(b3.getX(), b3.getZ())), AncientCityUtils.deepslateBricks);
            }
        }
        catch (FileNotFoundException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
        super.sculkUp(this.tw, data, room);
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() <= 20 && room.getWidthZ() <= 20;
    }
}

