/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.ancientcity.AncientCitySchematicParser;
import org.terraform.structure.ancientcity.AncientCityUtils;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.StairwayBuilder;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.version.V_1_19;

public class AncientCityResearchBasementHandler {
    private static final String[] northSouthResearchSchematics = new String[]{"ancient-city/ancient-city-basement-sculkresearch", "ancient-city/ancient-city-basement-redstoneresearch", "ancient-city/ancient-city-basement-sleepingchamber"};
    private static final String[] eastWestResearchSchematics = new String[]{"ancient-city/ancient-city-basement-farm", "ancient-city/ancient-city-basement-cage"};

    public static void populate(@NotNull Random random, @NotNull PopulatorDataAbstract data, @NotNull CubeRoom room, @NotNull BlockFace headFacing) {
        int[] lowerCorner = room.getLowerCorner();
        int[] upperCorner = room.getUpperCorner();
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                for (int y = room.getY(); y < room.getY() + room.getHeight(); ++y) {
                    if (y == room.getY() || y == room.getY() + room.getHeight() - 1) {
                        if (y == room.getY() && x > lowerCorner[0] && x < upperCorner[0] && z > lowerCorner[1] && z < upperCorner[1]) {
                            data.setType(x, y, z, Material.GRAY_WOOL);
                            data.setType(x, y - 1, z, AncientCityUtils.deepslateBricks);
                            continue;
                        }
                        data.setType(x, y, z, AncientCityUtils.deepslateBricks);
                        continue;
                    }
                    data.setType(x, y, z, Material.AIR);
                }
            }
        }
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 0).entrySet()) {
            Wall w = entry.getKey().getLeft(3);
            for (int i = 3; i < entry.getValue() - 3; i += 3) {
                w.getUp(4).setType(Material.CHISELED_DEEPSLATE);
                w.setType(Material.CHISELED_DEEPSLATE);
                new StairBuilder(Material.DEEPSLATE_TILE_STAIRS).setFacing(w.getDirection()).apply(w.getUp(3)).setHalf(Bisected.Half.TOP).apply(w.getUp());
                new OrientableBuilder(Material.POLISHED_BASALT).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).apply(w.getUp(2)).apply(w.getUp(2).getFront());
                w.getUp().getFront().setType(Material.CHISELED_DEEPSLATE);
                w.getUp(3).getFront().setType(Material.CHISELED_DEEPSLATE);
                w.getFront().setType(Material.DEEPSLATE_TILES);
                w.getUp(4).getFront().setType(Material.DEEPSLATE_TILES);
                for (BlockFace face : BlockUtils.getAdjacentFaces(w.getDirection())) {
                    Wall temp = w.getRelative(face);
                    temp.getUp(2).setType(Material.POLISHED_BASALT);
                    new StairBuilder(Material.DEEPSLATE_TILE_STAIRS).setFacing(face.getOppositeFace()).apply(temp).setHalf(Bisected.Half.TOP).apply(temp.getUp(4));
                    new StairBuilder(Material.POLISHED_DEEPSLATE_STAIRS).setFacing(face.getOppositeFace()).apply(temp.getUp(3)).setHalf(Bisected.Half.TOP).apply(temp.getUp());
                    w.getFront().getRelative(face).Pillar(2, Material.POLISHED_BASALT);
                    w.getFront().getRelative(face).getUp(2).setType(Material.DEEPSLATE_TILES);
                    w.getFront().getRelative(face).getUp(3).Pillar(2, Material.POLISHED_BASALT);
                }
                w = w.getLeft(3);
            }
        }
        for (Object corner : (Object)room.getAllCorners(2)) {
            int n;
            BlockFace[] core = new SimpleBlock(data, (int)corner[0], room.getY(), (int)corner[1]);
            for (int relX = -2; relX <= 2; ++relX) {
                for (n = -2; n <= 2; ++n) {
                    SimpleBlock target = core.getRelative(relX, 1, n);
                    target.RPillar(4, new Random(), Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS, Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS, Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS, Material.DEEPSLATE_BRICK_SLAB);
                }
            }
            BlockFace[] blockFaceArray = BlockUtils.directBlockFaces;
            n = blockFaceArray.length;
            for (int target = 0; target < n; ++target) {
                BlockFace side = blockFaceArray[target];
                Wall w = new Wall((SimpleBlock)core, side).getFront(3).getUp();
                if (!w.getDown().isSolid() || w.isSolid()) continue;
                for (BlockFace adj : BlockUtils.getAdjacentFaces(side)) {
                    if (w.getRelative(adj).isSolid()) continue;
                    new StairBuilder(Material.DEEPSLATE_BRICK_STAIRS).setFacing(w.getDirection().getOppositeFace()).apply(w).apply(w.getRelative(adj, 1)).apply(w.getRelative(adj, 2)).apply(w.getRelative(adj, 3)).setHalf(Bisected.Half.TOP).apply(w.getUp(3)).apply(w.getRelative(adj, 1).getUp(3)).apply(w.getRelative(adj, 2).getUp(3)).apply(w.getRelative(adj, 3).getUp(3));
                    BlockUtils.correctStairData(w.getRelative(adj, 3));
                    BlockUtils.correctStairData(w.getRelative(adj, 3).getUp(3));
                    w.getRelative(adj, 2).getRear().Pillar(4, Material.POLISHED_BASALT);
                }
            }
        }
        int roomBreadth = BlockUtils.getAxisFromBlockFace(headFacing) == Axis.X ? room.getWidthX() : room.getWidthZ();
        SimpleBlock base = room.getCenterSimpleBlock(data).getRelative(headFacing, roomBreadth / 3);
        for (int depth = 0; depth < 10; ++depth) {
            boolean breakOut = false;
            for (BlockFace adj : BlockUtils.getAdjacentFaces(headFacing)) {
                Wall core = new Wall(base.getUp(), adj).getFront(2).getRelative(headFacing, depth);
                if (core.isSolid()) {
                    breakOut = true;
                    break;
                }
                if (depth == 0) {
                    core.Pillar(4, Material.POLISHED_BASALT);
                    for (int i = 1; i < 4; ++i) {
                        core.getFront(i).Pillar(6, AncientCityUtils.deepslateBricks);
                    }
                    continue;
                }
                new StairwayBuilder(Material.DEEPSLATE_BRICK_STAIRS).setDownTypes(AncientCityUtils.deepslateBricks).setStairwayDirection(BlockFace.UP).setStopAtY(room.getY() + 6).setUpwardsCarveUntilNotSolid(false).build(core);
            }
            if (breakOut) break;
        }
        SimpleBlock pillarCent = room.getCenterSimpleBlock(data).getUp();
        for (int nx = -1; nx <= 1; ++nx) {
            for (int nz = -1; nz <= 1; ++nz) {
                pillarCent.getRelative(nx, 0, nz).setType(AncientCityUtils.deepslateTiles);
                pillarCent.getRelative(nx, 3, nz).setType(AncientCityUtils.deepslateTiles);
            }
        }
        pillarCent.getUp().Pillar(2, V_1_19.SCULK_SENSOR);
        for (BlockFace blockFace : BlockUtils.directBlockFaces) {
            new StairBuilder(Material.DEEPSLATE_BRICK_STAIRS).setFacing(blockFace.getOppositeFace()).apply(pillarCent.getRelative(blockFace, 2)).setHalf(Bisected.Half.TOP).apply(pillarCent.getRelative(blockFace, 2).getUp(3));
            pillarCent.getRelative(blockFace).getUp().Pillar(2, Material.REDSTONE_LAMP);
            pillarCent.getRelative(blockFace).getRelative(BlockUtils.getLeft(blockFace)).getUp().Pillar(2, Material.DEEPSLATE_BRICK_WALL);
            pillarCent.getRelative(blockFace).getRelative(BlockUtils.getLeft(blockFace)).getUp().CorrectMultipleFacing(2);
        }
        for (BlockFace blockFace : BlockUtils.cornerBlockFaces) {
            SimpleBlock rel = pillarCent.getRelative(blockFace[0], 3).getRelative(blockFace[1], 3);
            rel.Pillar(4, Material.POLISHED_BASALT);
            for (Wall face : blockFace) {
                int v = face.getModX() != 0 ? room.getWidthX() / 2 - 6 : room.getWidthZ() / 2 - 6;
                SimpleBlock relrel = rel;
                for (int i = 1; i < v && !(relrel = relrel.getRelative((BlockFace)face)).isSolid(); ++i) {
                    relrel.getUp().Pillar(2, Material.GLASS_PANE);
                    relrel.CorrectMultipleFacing(3);
                    relrel.setType(AncientCityUtils.deepslateBricks);
                    relrel.getUp(3).setType(AncientCityUtils.deepslateBricks);
                }
                relrel.Pillar(4, Material.POLISHED_BASALT);
            }
        }
        try {
            TerraSchematic schema = TerraSchematic.load("ancient-city/ancient-city-pistondoor", base.getUp().getRelative(headFacing.getOppositeFace(), 2));
            schema.parser = new AncientCitySchematicParser();
            schema.setFace(headFacing);
            schema.apply();
        }
        catch (FileNotFoundException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
        for (BlockFace blockFace : BlockUtils.directBlockFaces) {
            SimpleBlock pasteCent = room.getCenterSimpleBlock(data).getUp().getRelative(blockFace, 2).getRelative(BlockUtils.getLeft(blockFace), 2);
            try {
                String schematic = BlockUtils.getAxisFromBlockFace(blockFace) == BlockUtils.getAxisFromBlockFace(headFacing) ? northSouthResearchSchematics[random.nextInt(northSouthResearchSchematics.length)] : eastWestResearchSchematics[random.nextInt(eastWestResearchSchematics.length)];
                TerraSchematic schema = TerraSchematic.load(schematic, pasteCent);
                schema.parser = new AncientCitySchematicParser();
                schema.setFace(blockFace);
                schema.apply();
            }
            catch (FileNotFoundException e3) {
                TerraformGeneratorPlugin.logger.stackTrace(e3);
            }
        }
    }
}

