/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.caves;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.SeaPickle;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.cavepopulators.LushClusterCavePopulator;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.structure.caves.GenericLargeCavePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.StalactiteBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class LargeLushCavePopulator
extends GenericLargeCavePopulator {
    public LargeLushCavePopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    protected void populateFloor(@NotNull SimpleBlock floor, int waterLevel) {
        if (floor.getY() > waterLevel) {
            return;
        }
        int waterDepth = waterLevel - floor.getY();
        TerraformWorld tw = floor.getPopData().getTerraformWorld();
        FastNoise raisedGroundNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_LARGECAVE_RAISEDGROUNDNOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 5L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.06f);
            return n;
        });
        double noise = raisedGroundNoise.GetNoise(floor.getX(), floor.getZ());
        if (noise > 0.0) {
            int h2 = (int)Math.round((double)(4.3f * (float)waterDepth) * noise);
            if (h2 > waterDepth) {
                h2 = (int)Math.round((double)waterDepth + Math.sqrt(h2 - waterDepth));
            }
            floor.getUp().RPillar(h2, new Random(), Material.CLAY);
            floor = floor.getUp(h2 - 1);
        }
        if (floor.getY() > waterLevel) {
            return;
        }
        if (TConfig.arePlantsEnabled() && BlockUtils.isWet(floor.getUp()) && GenUtils.chance(this.rand, 7, 100)) {
            SeaPickle sp = (SeaPickle)Bukkit.createBlockData((Material)Material.SEA_PICKLE);
            sp.setPickles(GenUtils.randInt(3, 4));
            floor.getUp().setBlockData((BlockData)sp);
        }
        if (GenUtils.chance(this.rand, 1, 200) && BlockUtils.isWet(floor.getAtY(waterLevel)) && floor.getAtY(waterLevel + 1).isAir()) {
            PlantBuilder.LILY_PAD.build(floor.getAtY(waterLevel + 1));
        }
        if (GenUtils.chance(this.rand, 1, 130)) {
            int r = 2;
            int h3 = GenUtils.randInt(this.rand, 6 * waterDepth, (int)(1.5f * (float)(6 * waterDepth)));
            new StalactiteBuilder(BlockUtils.stoneOrSlateWall(floor.getY())).setSolidBlockType(BlockUtils.stoneOrSlate(floor.getY())).makeSpike(floor, r, h3, true);
        }
    }

    @Override
    protected void populateCeilFloorPair(@NotNull SimpleBlock ceil, @NotNull SimpleBlock floor, int height) {
        int cutoff;
        TerraformWorld tw = ceil.getPopData().getTerraformWorld();
        for (cutoff = height; cutoff > 0 && floor.getUp().isSolid(); --cutoff) {
            floor = floor.getUp();
        }
        if (cutoff <= 0) {
            return;
        }
        new LushClusterCavePopulator(10.0f, true).oneUnit(tw, new Random(), ceil, floor, false);
        if (GenUtils.chance(this.rand, 1, 150)) {
            int r = 2;
            int h2 = GenUtils.randInt(this.rand, (int)((float)height / 2.5f), (int)(1.5f * ((float)height / 2.5f)));
            new StalactiteBuilder(BlockUtils.stoneOrSlateWall(ceil.getY())).setSolidBlockType(BlockUtils.stoneOrSlate(ceil.getY())).makeSpike(ceil, r, h2, false);
        }
        PopulatorDataICABiomeWriterAbstract biomeWriter = (PopulatorDataICABiomeWriterAbstract)TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData());
        for (int ny = floor.getY(); ny <= ceil.getY(); ++ny) {
            biomeWriter.setBiome(floor.getX(), ny, floor.getZ(), Biome.LUSH_CAVES);
        }
    }
}

