/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.mineshaft;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.block.data.type.Slab;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.data.SimpleBlock;
import org.terraform.schematic.SchematicParser;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.noise.FastNoise;

public class BadlandsMineEntranceParser
extends SchematicParser {
    @Nullable
    static FastNoise noise = null;
    private boolean didPlaceLantern = false;

    static double getNoise(int x, int y, int z) {
        if (noise == null) {
            noise = new FastNoise();
            noise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            noise.SetFractalOctaves(2);
            noise.SetFrequency(0.08f);
        }
        return noise.GetNoise(x, y, z);
    }

    @Override
    public void applyData(@NotNull SimpleBlock block, @NotNull BlockData data) {
        double noiseValue = BadlandsMineEntranceParser.getNoise(block.getX(), block.getY(), block.getZ());
        switch (data.getMaterial()) {
            case RED_CONCRETE: {
                if (noiseValue > 0.0) {
                    super.applyData(block, Bukkit.createBlockData((Material)Material.DARK_OAK_FENCE));
                    break;
                }
                Slab s = (Slab)Bukkit.createBlockData((Material)Material.DARK_OAK_SLAB);
                s.setType(Slab.Type.TOP);
                super.applyData(block, (BlockData)s);
                break;
            }
            case GREEN_CONCRETE: {
                if (!(noiseValue > 0.5) || !BlockUtils.isAir(block.getType())) break;
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    SimpleBlock b2 = block.getRelative(face);
                    if (b2.getType() != Material.OAK_LOG) continue;
                    MultipleFacing dir = (MultipleFacing)Bukkit.createBlockData((Material)Material.VINE);
                    dir.setFace(face, true);
                    super.applyData(block, (BlockData)dir);
                }
                break;
            }
            case DARK_OAK_FENCE: {
                if (this.willPlaceFence(block)) {
                    block.lsetBlockData(data);
                    break;
                }
                if (!this.willPlaceFence(block.getUp()) || this.didPlaceLantern) break;
                Lantern l = (Lantern)Bukkit.createBlockData((Material)Material.LANTERN);
                l.setHanging(true);
                super.applyData(block, (BlockData)l);
                this.didPlaceLantern = true;
                break;
            }
            case RED_SAND: {
                if (!(noiseValue < 0.0)) break;
                SimpleBlock b3 = block;
                while (b3.getType() == Material.RED_SAND) {
                    b3 = b3.getUp();
                }
                b3.lsetType(Material.RED_SAND);
                break;
            }
            case DARK_OAK_SLAB: {
                Slab s = (Slab)data;
                if (s.getType() == Slab.Type.BOTTOM) {
                    block.lsetBlockData(data);
                    break;
                }
                super.applyData(block, data);
                break;
            }
            case OAK_STAIRS: {
                block.lsetBlockData(data);
                break;
            }
            default: {
                super.applyData(block, data);
            }
        }
    }

    boolean willPlaceFence(@NotNull SimpleBlock block) {
        return BadlandsMineEntranceParser.getNoise(block.getX(), block.getY(), block.getZ()) < 0.4;
    }
}

