/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion;

import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.pillager.mansion.MansionJigsawBuilder;
import org.terraform.utils.GenUtils;

public class MansionPopulator
extends SingleMegaChunkStructurePopulator {
    @Override
    @NotNull
    public Random getHashedRandom(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        return tw.getHashedRand(717281012L, chunkX, chunkZ);
    }

    private boolean rollSpawnRatio(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        return GenUtils.chance(tw.getHashedRand(chunkX, chunkZ, 99572), (int)(TConfig.c.STRUCTURES_MANSION_SPAWNRATIO * 10000.0), 10000);
    }

    @Override
    public boolean canSpawn(@NotNull TerraformWorld tw, int chunkX, int chunkZ, BiomeBank biome) {
        if (!this.isEnabled()) {
            return false;
        }
        if (Math.pow(chunkX * 16, 2.0) + Math.pow(chunkZ * 16, 2.0) < Math.pow(TConfig.c.STRUCTURES_MANSION_MINDISTANCE, 2.0)) {
            return false;
        }
        if (biome == BiomeBank.DARK_FOREST) {
            return this.rollSpawnRatio(tw, chunkX, chunkZ);
        }
        return false;
    }

    @Override
    public void populate(TerraformWorld tw, @NotNull PopulatorDataAbstract data) {
        if (!this.isEnabled()) {
            return;
        }
        MegaChunk mc = new MegaChunk(data.getChunkX(), data.getChunkZ());
        int[] coords = mc.getCenterBiomeSectionBlockCoords();
        int y = GenUtils.getHighestGround(data, coords[0], coords[1]);
        if (y < TerraformGenerator.seaLevel) {
            y = TerraformGenerator.seaLevel;
        }
        MansionJigsawBuilder builder = new MansionJigsawBuilder(TConfig.c.STRUCTURES_MANSION_SIZE, TConfig.c.STRUCTURES_MANSION_SIZE, data, coords[0], y, coords[1]);
        builder.generate(new Random());
        builder.build(new Random());
    }

    @Override
    public int getChunkBufferDistance() {
        return TConfig.c.STRUCTURES_MANSION_CHUNK_EXCLUSION_ZONE;
    }

    @Override
    public boolean isEnabled() {
        return TConfig.areStructuresEnabled() && BiomeBank.isBiomeEnabled(BiomeBank.DARK_FOREST) && TConfig.c.STRUCTURES_MANSION_ENABLED;
    }
}

