/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion;

import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.structure.pillager.mansion.MansionRoomPopulator;
import org.terraform.structure.pillager.mansion.MansionRoomSize;
import org.terraform.structure.pillager.mansion.ground.MansionGrandStairwayPopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundFloorHallwayPopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundLevelBrewingRoomPopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundLevelDiningRoomPopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundLevelForgePopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundLevelKitchenPopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundLevelLibraryPopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundLevelMushroomFarmPopulator;
import org.terraform.structure.pillager.mansion.ground.MansionGroundLevelWarroomPopulator;
import org.terraform.structure.pillager.mansion.secondfloor.MansionSecondFloorBedroomPopulator;
import org.terraform.structure.pillager.mansion.secondfloor.MansionSecondFloorBunkPopulator;
import org.terraform.structure.pillager.mansion.secondfloor.MansionSecondFloorHallwayPopulator;
import org.terraform.structure.pillager.mansion.secondfloor.MansionSecondFloorLoungePopulator;
import org.terraform.structure.pillager.mansion.secondfloor.MansionSecondFloorPianoRoomPopulator;
import org.terraform.structure.pillager.mansion.secondfloor.MansionSecondFloorStoreroomPopulator;
import org.terraform.structure.pillager.mansion.secondfloor.MansionSecondFloorStudyPopulator;

public enum MansionRoomPopulatorRegistry {
    GROUND_3_3(new MansionGrandStairwayPopulator(null, null)),
    GROUND_2_2(new MansionGroundLevelLibraryPopulator(null, null), new MansionGroundLevelWarroomPopulator(null, null)),
    GROUND_1_2(new MansionGroundLevelKitchenPopulator(null, null), new MansionGroundLevelMushroomFarmPopulator(null, null), new MansionGroundLevelForgePopulator(null, null)),
    GROUND_2_1(new MansionGroundLevelDiningRoomPopulator(null, null), new MansionGroundLevelBrewingRoomPopulator(null, null)),
    GROUND_1_1(new MansionGroundFloorHallwayPopulator(null, null)),
    SECOND_3_3(new MansionGrandStairwayPopulator(null, null)),
    SECOND_2_2(new MansionSecondFloorBedroomPopulator(null, null), new MansionSecondFloorStudyPopulator(null, null)),
    SECOND_1_2(new MansionSecondFloorLoungePopulator(null, null), new MansionSecondFloorPianoRoomPopulator(null, null)),
    SECOND_2_1(new MansionSecondFloorBunkPopulator(null, null), new MansionSecondFloorStoreroomPopulator(null, null)),
    SECOND_1_1(new MansionSecondFloorHallwayPopulator(null, null));

    @NotNull
    final ArrayList<MansionRoomPopulator> populators = new ArrayList();

    private MansionRoomPopulatorRegistry(MansionRoomPopulator ... populators) {
        this.populators.addAll(Arrays.asList(populators));
    }

    @Nullable
    public static MansionRoomPopulatorRegistry getByRoomSize(@NotNull MansionRoomSize size, boolean isGround) {
        if (isGround) {
            if (size.getWidthX() == 3 && size.getWidthZ() == 3) {
                return GROUND_3_3;
            }
            if (size.getWidthX() == 2 && size.getWidthZ() == 2) {
                return GROUND_2_2;
            }
            if (size.getWidthX() == 1 && size.getWidthZ() == 2) {
                return GROUND_1_2;
            }
            if (size.getWidthX() == 2 && size.getWidthZ() == 1) {
                return GROUND_2_1;
            }
            if (size.getWidthX() == 1 && size.getWidthZ() == 1) {
                return GROUND_1_1;
            }
        } else {
            if (size.getWidthX() == 3 && size.getWidthZ() == 3) {
                return SECOND_3_3;
            }
            if (size.getWidthX() == 2 && size.getWidthZ() == 2) {
                return SECOND_2_2;
            }
            if (size.getWidthX() == 1 && size.getWidthZ() == 2) {
                return SECOND_1_2;
            }
            if (size.getWidthX() == 2 && size.getWidthZ() == 1) {
                return SECOND_2_1;
            }
            if (size.getWidthX() == 1 && size.getWidthZ() == 1) {
                return SECOND_1_1;
            }
        }
        return null;
    }

    @NotNull
    public ArrayList<MansionRoomPopulator> getPopulators() {
        return new ArrayList<MansionRoomPopulator>(this.populators);
    }
}

