/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.V_1_20;
import org.terraform.utils.version.Version;

public abstract class Antechamber
extends RoomPopulatorAbstract {
    public Antechamber(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int length;
        Object[] corner2;
        int[][] corners;
        for (Object[] corner2 : corners = room.getAllCorners(1)) {
            Wall w = new Wall(new SimpleBlock(data, corner2[0], room.getY() + room.getHeight() - 1, corner2[1]));
            w.downLPillar(this.rand, 2, Material.CUT_SANDSTONE, Material.SMOOTH_SANDSTONE);
            for (BlockFace face : BlockUtils.directBlockFaces) {
                w.getRelative(face).setType(GenUtils.randChoice(Material.CUT_SANDSTONE, Material.SMOOTH_SANDSTONE));
            }
        }
        int[] choices = new int[]{-2, -1, 0, 1, 2};
        int[] steps = new int[15];
        for (int i = 0; i < 15; ++i) {
            steps[i] = choices[this.rand.nextInt(choices.length)];
        }
        SimpleBlock center = new SimpleBlock(data, room.getX(), room.getY(), room.getZ());
        corner2 = BlockUtils.directBlockFaces;
        int w = corner2.length;
        for (int i = 0; i < w; ++i) {
            int face = corner2[i];
            length = room.getWidthX() / 2;
            if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                length = room.getWidthZ() / 2;
            }
            for (int i2 = 0; i2 < length; ++i2) {
                if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                    center.getRelative((BlockFace)face, i2).getRelative(steps[i2] * face.getModZ(), 0, 0).setType(Material.ORANGE_TERRACOTTA);
                    continue;
                }
                center.getRelative((BlockFace)face, i2).getRelative(0, 0, steps[i2] * face.getModX()).setType(Material.ORANGE_TERRACOTTA);
            }
        }
        center.setType(Material.BLUE_TERRACOTTA);
        if (Version.VERSION.isAtLeast(Version.v1_20)) {
            for (int i = 0; i < TConfig.c.STRUCTURES_PYRAMID_SUSPICIOUS_SAND_COUNT_PER_ANTECHAMBER; ++i) {
                SimpleBlock target = center.getRelative(GenUtils.getSign(this.rand) * GenUtils.randInt(this.rand, 1, room.getWidthX() / 2 - 1), 0, GenUtils.getSign(this.rand) * GenUtils.randInt(this.rand, 1, room.getWidthZ() / 2 - 1));
                target.setType(V_1_20.SUSPICIOUS_SAND);
                data.lootTableChest(target.getX(), target.getY(), target.getZ(), TerraLootTable.DESERT_PYRAMID_ARCHAEOLOGY);
            }
        }
        center = new SimpleBlock(data, room.getX(), room.getY() + room.getHeight(), room.getZ());
        for (BlockFace face : BlockUtils.directBlockFaces) {
            length = room.getWidthX() / 2;
            if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                length = room.getWidthZ() / 2;
            }
            for (int i = 0; i < length; ++i) {
                if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                    center.getRelative(face, i).getRelative(steps[i] * face.getModZ(), 0, 0).setType(Material.ORANGE_TERRACOTTA);
                    continue;
                }
                center.getRelative(face, i).getRelative(0, 0, steps[i] * face.getModX()).setType(Material.ORANGE_TERRACOTTA);
            }
        }
        center.setType(Material.BLUE_TERRACOTTA);
    }

    protected void randomRoomPlacement(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room, int lowerbound, int upperbound, Material ... types) {
        for (int i = 0; i < GenUtils.randInt(lowerbound, upperbound); ++i) {
            int[] coords = room.randomCoords(this.rand, 1);
            BlockData bd = Bukkit.createBlockData((Material)GenUtils.randChoice(types));
            if (bd instanceof Waterlogged) {
                ((Waterlogged)bd).setWaterlogged(false);
            }
            if (!data.getType(coords[0], room.getY() + 1, coords[2]).isSolid()) {
                data.setBlockData(coords[0], room.getY() + 1, coords[2], bd);
                continue;
            }
            data.setBlockData(coords[0], room.getY() + 2, coords[2], bd);
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

