/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class CursedChamber
extends RoomPopulatorAbstract {
    public CursedChamber(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int i;
        Object w;
        int[] lowerCorner = room.getLowerCorner(3);
        int[] upperCorner = room.getUpperCorner(3);
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 1).entrySet()) {
            w = entry.getKey();
            for (int i2 = 0; i2 < entry.getValue(); ++i2) {
                for (int h2 = 0; h2 < room.getHeight() - 2; ++h2) {
                    if (!((Wall)w).getRelative(0, h2, 0).getRear().isSolid() || !GenUtils.chance(this.rand, 1, 5)) continue;
                    Directional head = (Directional)Bukkit.createBlockData((Material)Material.SKELETON_WALL_SKULL);
                    head.setFacing(((Wall)w).getDirection());
                    ((Wall)w).getRelative(0, h2, 0).setBlockData((BlockData)head);
                }
                w = ((Wall)w).getLeft();
            }
        }
        ArrayList<Integer> availableX = new ArrayList<Integer>();
        ArrayList<Integer> availableZ = new ArrayList<Integer>();
        if (room.getWidthX() > 10) {
            availableX.add(lowerCorner[0]);
            availableX.add(upperCorner[0]);
        } else {
            availableX.add(room.getX());
        }
        if (room.getWidthZ() > 10) {
            availableZ.add(lowerCorner[1]);
            availableZ.add(upperCorner[1]);
        } else {
            availableZ.add(room.getZ());
        }
        w = availableX.iterator();
        while (w.hasNext()) {
            int nx = (Integer)w.next();
            Iterator iterator = availableZ.iterator();
            while (iterator.hasNext()) {
                int nz = (Integer)iterator.next();
                this.spawnSkullPillar(new Wall(new SimpleBlock(data, nx, room.getY() + 1, nz)), room);
            }
        }
        for (i = 0; i < GenUtils.randInt(3, 10); ++i) {
            int[] loc = room.randomCoords(this.rand, 1);
            if (data.getType(loc[0], room.getY() + room.getHeight() + 1, loc[2]) == Material.SAND) {
                data.setType(loc[0], room.getY() + room.getHeight() + 1, loc[2], Material.SANDSTONE);
            }
            BlockUtils.dropDownBlock(new SimpleBlock(data, loc[0], room.getY() + room.getHeight(), loc[2]));
        }
        for (i = 0; i < GenUtils.randInt(this.rand, 1, 4); ++i) {
            data.addEntity(room.getX() - room.getWidthX() / 2 + 1, room.getY() + 1, room.getZ(), EntityType.SKELETON);
        }
    }

    public void spawnSkullPillar(@NotNull Wall w, @NotNull CubeRoom room) {
        w.LPillar(room.getHeight() - 1, this.rand, Material.SANDSTONE, Material.CHISELED_SANDSTONE);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Stairs stair = (Stairs)Bukkit.createBlockData((Material)GenUtils.randChoice(Material.SANDSTONE_STAIRS, Material.STONE_STAIRS, Material.COBBLESTONE_STAIRS));
            stair.setFacing(face.getOppositeFace());
            w.getRelative(face).setBlockData((BlockData)stair);
            stair = (Stairs)Bukkit.createBlockData((Material)GenUtils.randChoice(Material.SANDSTONE_STAIRS, Material.STONE_STAIRS, Material.COBBLESTONE_STAIRS));
            stair.setFacing(face.getOppositeFace());
            stair.setHalf(Bisected.Half.TOP);
            w.getRelative(face).getRelative(0, room.getHeight() - 2, 0).setBlockData((BlockData)stair);
        }
        for (int h2 = 1; h2 < room.getHeight() - 3; ++h2) {
            Wall target = w.getRelative(0, h2, 0);
            for (BlockFace face : BlockUtils.directBlockFaces) {
                if (GenUtils.chance(4, 5)) continue;
                Directional head = (Directional)Bukkit.createBlockData((Material)Material.SKELETON_WALL_SKULL);
                head.setFacing(face);
                target.getRelative(face).setBlockData((BlockData)head);
            }
        }
        for (int nz = -2; nz <= 2; ++nz) {
            for (int nx = -2; nx <= 2; ++nx) {
                w.getRelative(nx, room.getHeight() - 1, nz).setType(GenUtils.randChoice(Material.ANDESITE, Material.COBBLESTONE, Material.SANDSTONE));
            }
        }
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() > 6 && room.getWidthZ() > 6;
    }
}

