/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.schematic.SchematicParser;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;

public class ElderGuardianChamber
extends RoomPopulatorAbstract {
    public ElderGuardianChamber(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        void var7_15;
        BlockFace face;
        void var7_13;
        SimpleBlock base = new SimpleBlock(data, room.getX(), room.getY() + 1, room.getZ());
        for (BlockFace blockFace : BlockUtils.directBlockFaces) {
            this.placeStatue(base.getRelative(blockFace, 4), blockFace.getOppositeFace());
        }
        for (BlockFace blockFace : BlockUtils.xzDiagonalPlaneBlockFaces) {
            this.placePillar(new Wall(base.getRelative(blockFace, 6)), room.getHeight() - 1);
        }
        SimpleBlock center = new SimpleBlock(data, room.getX(), room.getY(), room.getZ());
        center.setType(Material.BLUE_TERRACOTTA);
        BlockFace[] blockFaceArray = BlockUtils.xzDiagonalPlaneBlockFaces;
        int n = blockFaceArray.length;
        boolean bl = false;
        while (var7_13 < n) {
            face = blockFaceArray[var7_13];
            center.getRelative(face).setType(Material.ORANGE_TERRACOTTA);
            new Wall(center.getRelative(face).getRelative(face).getUp()).Pillar(room.getHeight(), this.rand, Material.CUT_SANDSTONE);
            ++var7_13;
        }
        blockFaceArray = BlockUtils.directBlockFaces;
        n = blockFaceArray.length;
        boolean bl2 = false;
        while (var7_15 < n) {
            face = blockFaceArray[var7_15];
            center.getRelative(face).getRelative(face).setType(Material.ORANGE_TERRACOTTA);
            ++var7_15;
        }
        SimpleBlock ceiling = new SimpleBlock(data, room.getX(), room.getY() + room.getHeight(), room.getZ());
        ceiling.setType(Material.BLUE_TERRACOTTA);
        for (BlockFace face2 : BlockUtils.xzDiagonalPlaneBlockFaces) {
            ceiling.getRelative(face2).setType(Material.ORANGE_TERRACOTTA);
        }
        for (BlockFace face2 : BlockUtils.directBlockFaces) {
            ceiling.getRelative(face2).getRelative(face2).setType(Material.ORANGE_TERRACOTTA);
        }
        if (TConfig.c.STRUCTURES_PYRAMID_SPAWN_ELDER_GUARDIAN) {
            SimpleBlock cageCenter = center.getUp(11);
            this.placeElderGuardianCage(cageCenter);
        }
        for (Map.Entry entry : room.getFourWalls(data, 0).entrySet()) {
            Wall w = (Wall)entry.getKey();
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                if (i % 2 == 0 && i != 0 && i != (Integer)entry.getValue() - 1) {
                    w.getUp(4).Pillar(10, this.rand, Material.CHISELED_RED_SANDSTONE);
                }
                w = w.getLeft();
            }
        }
        for (Map.Entry entry : room.getFourWalls(data, 1).entrySet()) {
            Wall w = ((Wall)entry.getKey()).getRelative(0, room.getHeight() - 2, 0);
            int length = (Integer)entry.getValue();
            for (int j = 0; j < length; ++j) {
                Stairs stair = (Stairs)Bukkit.createBlockData((Material)Material.RED_SANDSTONE_STAIRS);
                stair.setFacing(w.getDirection().getOppositeFace());
                stair.setHalf(Bisected.Half.TOP);
                w.setBlockData((BlockData)stair);
                w = w.getLeft();
            }
        }
    }

    private void placeElderGuardianCage(@NotNull SimpleBlock cageCenter) {
        cageCenter.getDown(2).setType(Material.CUT_SANDSTONE);
        cageCenter.getUp(2).setType(Material.CUT_SANDSTONE);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Wall w = new Wall(cageCenter, face);
            w.getFront(2).setType(Material.CHISELED_SANDSTONE);
            w.getFront(2).getLeft().setType(Material.CHISELED_SANDSTONE);
            w.getFront(2).getRight().setType(Material.CHISELED_SANDSTONE);
            Stairs stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setFacing(face.getOppositeFace());
            w.getFront(2).getUp().setBlockData((BlockData)stair);
            stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setFacing(face.getOppositeFace());
            stair.setHalf(Bisected.Half.TOP);
            w.getFront(2).getDown().setBlockData((BlockData)stair);
            w.getFront().getUp(2).setType(Material.CUT_SANDSTONE_SLAB);
            Slab slab = (Slab)Bukkit.createBlockData((Material)Material.CUT_SANDSTONE_SLAB);
            slab.setType(Slab.Type.TOP);
            w.getFront().getDown(2).setBlockData((BlockData)slab);
        }
        cageCenter.getPopData().addEntity(cageCenter.getX(), cageCenter.getY(), cageCenter.getZ(), EntityType.ELDER_GUARDIAN);
    }

    private void placePillar(@NotNull Wall base, int height) {
        for (BlockFace face : BlockUtils.xzDiagonalPlaneBlockFaces) {
            base.getRelative(face).Pillar(height, this.rand, Material.CUT_SANDSTONE, Material.SMOOTH_SANDSTONE);
        }
        for (BlockFace face : BlockUtils.directBlockFaces) {
            base.getRelative(face).Pillar(height, true, this.rand, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE, Material.AIR, Material.AIR, Material.AIR, Material.CHISELED_SANDSTONE);
        }
        base.Pillar(height, this.rand, Material.CHISELED_RED_SANDSTONE);
    }

    private void placeStatue(SimpleBlock base, BlockFace dir) {
        try {
            TerraSchematic schema = TerraSchematic.load("pharoah-statue", base);
            schema.parser = new SchematicParser();
            schema.setFace(dir);
            schema.apply();
        }
        catch (Throwable e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

