/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.Wall;
import org.terraform.structure.pyramid.Antechamber;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.GenUtils;

public class TreasureAntechamber
extends Antechamber {
    public TreasureAntechamber(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        super.populate(data, room);
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 1).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                if (i != 0 && i != entry.getValue() - 1 && w.getRear().isSolid() && !w.isSolid() && GenUtils.chance(this.rand, 1, 4)) {
                    Chest chest = (Chest)Bukkit.createBlockData((Material)Material.CHEST);
                    chest.setFacing(w.getDirection());
                    w.setBlockData((BlockData)chest);
                    data.lootTableChest(w.getX(), w.getY(), w.getZ(), TerraLootTable.DESERT_PYRAMID);
                }
                w = w.getLeft();
            }
        }
    }
}

