/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.room.jigsaw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.utils.BlockUtils;

public abstract class JigsawStructurePiece
implements Cloneable {
    protected final JigsawType type;
    protected CubeRoom room;
    protected HashMap<BlockFace, Boolean> validDirections = new HashMap();
    protected ArrayList<BlockFace> walledFaces = new ArrayList();
    protected JigsawStructurePiece[] allowedPieces;
    protected int depth = 0;
    protected BlockFace rotation = BlockFace.NORTH;
    protected boolean unique = false;
    protected int elevation = 0;

    public JigsawStructurePiece(int widthX, int height, int widthZ, JigsawType type, boolean unique, BlockFace ... validDirs) {
        this.room = new CubeRoom(widthX, widthZ, height, 0, 0, 0);
        this.type = type;
        this.unique = unique;
        for (BlockFace face : validDirs) {
            this.validDirections.put(face, false);
        }
    }

    public JigsawStructurePiece(int widthX, int height, int widthZ, JigsawType type, BlockFace ... validDirs) {
        this.room = new CubeRoom(widthX, widthZ, height, 0, 0, 0);
        this.type = type;
        for (BlockFace face : validDirs) {
            this.validDirections.put(face, false);
        }
    }

    public void postBuildDecoration(Random random, PopulatorDataAbstract data) {
    }

    @Nullable
    public JigsawStructurePiece getInstance(@NotNull Random rand, int depth) {
        try {
            JigsawStructurePiece clone = (JigsawStructurePiece)this.clone();
            clone.room = new CubeRoom(this.room.getWidthX(), this.room.getWidthZ(), this.room.getHeight(), 0, 0, 0);
            clone.validDirections = (HashMap)this.validDirections.clone();
            for (BlockFace face : this.validDirections.keySet()) {
                clone.validDirections.put(face, false);
            }
            clone.walledFaces = new ArrayList();
            clone.setRotation(BlockUtils.getDirectBlockFace(rand));
            clone.elevation = 0;
            clone.setDepth(depth);
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
            return null;
        }
    }

    public abstract void build(PopulatorDataAbstract var1, Random var2);

    @Nullable
    public BlockFace getNextUnpopulatedBlockFace() {
        for (Map.Entry<BlockFace, Boolean> entry : this.validDirections.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return entry.getKey();
        }
        TerraformGeneratorPlugin.logger.error("Tried to get unpopulated block face when there aren't any left!");
        return null;
    }

    public void setPopulated(BlockFace face) {
        if (this.type == JigsawType.END) {
            return;
        }
        if (!this.validDirections.containsKey(face)) {
            TerraformGeneratorPlugin.logger.error("Tried to set an invalid blockface as populated for a jigsaw piece.");
        }
        this.validDirections.put(face, true);
    }

    public boolean hasUnpopulatedDirections() {
        if (this.type == JigsawType.END) {
            return false;
        }
        for (Boolean populated : this.validDirections.values()) {
            if (populated.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public CubeRoom getRoom() {
        return this.room;
    }

    public HashMap<BlockFace, Boolean> getValidDirections() {
        if (this.type == JigsawType.END) {
            return new HashMap<BlockFace, Boolean>();
        }
        return this.validDirections;
    }

    public JigsawStructurePiece[] getAllowedPieces() {
        return this.allowedPieces;
    }

    public JigsawType getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int elevation) {
        this.elevation = elevation;
    }

    public BlockFace getRotation() {
        return this.rotation;
    }

    public void setRotation(BlockFace rotation) {
        this.rotation = rotation;
    }

    public CubeRoom getExtendedRoom(int extraSize) {
        if (this.walledFaces.isEmpty()) {
            return this.room;
        }
        return new CubeRoom(this.room.getWidthX() + extraSize * 2, this.room.getWidthZ() + extraSize * 2, this.room.getHeight(), this.room.getX(), this.room.getY(), this.room.getZ());
    }

    @NotNull
    public String toString() {
        StringBuilder directions = new StringBuilder();
        for (BlockFace face : this.validDirections.keySet()) {
            directions.append(face).append(",");
        }
        return this.getClass().getSimpleName() + "::" + this.room.getX() + "," + this.room.getY() + "," + this.room.getZ() + "::" + this.hasUnpopulatedDirections() + "::" + String.valueOf(directions);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public ArrayList<BlockFace> getWalledFaces() {
        return this.walledFaces;
    }

    public void setWalledFaces(ArrayList<BlockFace> walledFaces) {
        this.walledFaces = walledFaces;
    }
}

