/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.EndPortalFrame;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class PortalRoomPopulator
extends RoomPopulatorAbstract {
    public PortalRoomPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @NotNull
    private Slab randTopSlab() {
        Slab slab = (Slab)Bukkit.createBlockData((Material)BlockUtils.stoneBrickSlab(this.rand));
        slab.setType(Slab.Type.TOP);
        return slab;
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        Wall w;
        int x;
        int h2;
        int i;
        BlockFace[] wall;
        int[] lowerBounds = room.getLowerCorner();
        int[] upperBounds = room.getUpperCorner();
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 0).entrySet()) {
            wall = entry.getKey().getUp(3);
            for (i = 1; i <= entry.getValue(); ++i) {
                wall.setType(Material.CHISELED_STONE_BRICKS);
                if (i % 5 == 2 || i % 5 == 4) {
                    wall.getUp().Pillar(8, this.rand, Material.CHISELED_STONE_BRICKS);
                }
                if (i % 5 == 3) {
                    wall.getUp().Pillar(8, this.rand, Material.COBBLESTONE_WALL);
                }
                for (h2 = 1; h2 < 8; ++h2) {
                    BlockUtils.correctSurroundingMultifacingData(wall.getRelative(0, h2, 0).get());
                }
                wall = wall.getLeft();
            }
        }
        for (x = lowerBounds[0] + 1; x < upperBounds[0]; ++x) {
            for (int z = lowerBounds[1] + 1; z < upperBounds[1]; ++z) {
                data.setType(x, room.getY(), z, Material.OBSIDIAN);
            }
        }
        for (x = lowerBounds[0] + 2; x < upperBounds[0] - 1; ++x) {
            for (int z = lowerBounds[1] + 2; z < upperBounds[1] - 1; ++z) {
                data.setType(x, room.getY(), z, BlockUtils.stoneBrick(this.rand));
            }
        }
        for (x = lowerBounds[0] + 1; x < upperBounds[0]; ++x) {
            for (int z = lowerBounds[1] + 1; z < upperBounds[1]; ++z) {
                data.setType(x, room.getY() + room.getHeight() - 1, z, Material.COBBLESTONE);
                data.setType(x, room.getY() + room.getHeight() - 2, z, Material.COBBLESTONE);
            }
        }
        for (x = lowerBounds[0] + 3; x <= upperBounds[0] - 3; ++x) {
            for (int z = lowerBounds[1] + 3; z <= upperBounds[1] - 3; ++z) {
                data.setType(x, room.getY() + room.getHeight() - 1, z, Material.CAVE_AIR);
            }
        }
        for (x = lowerBounds[0] + 2; x <= upperBounds[0] - 2; ++x) {
            for (int z = lowerBounds[1] + 2; z <= upperBounds[1] - 2; ++z) {
                data.setType(x, room.getY() + room.getHeight() - 2, z, Material.CAVE_AIR);
            }
        }
        SimpleBlock ceil = new SimpleBlock(data, room.getX(), room.getHeight() - 1 + room.getY(), room.getZ());
        this.ceilDecor(ceil);
        SimpleBlock base = new SimpleBlock(data, room.getX(), room.getY() + 2, room.getZ());
        wall = BlockUtils.directBlockFaces;
        i = wall.length;
        for (h2 = 0; h2 < i; ++h2) {
            BlockFace face = wall[h2];
            w = new Wall(base.getRelative(face).getRelative(face), face);
            EndPortalFrame portalFrame = (EndPortalFrame)Bukkit.createBlockData((Material)Material.END_PORTAL_FRAME);
            portalFrame.setFacing(face.getOppositeFace());
            portalFrame.setEye(GenUtils.chance(this.rand, 1, 10));
            w.setBlockData((BlockData)portalFrame);
            portalFrame.setEye(GenUtils.chance(this.rand, 1, 10));
            w.getLeft().setBlockData((BlockData)portalFrame);
            portalFrame.setEye(GenUtils.chance(this.rand, 1, 10));
            w.getRight().setBlockData((BlockData)portalFrame);
            w.getLeft().getLeft().setType(Material.CHISELED_STONE_BRICKS);
            w.getRight().getRight().setType(Material.CHISELED_STONE_BRICKS);
            w = w.getDown();
            w.setType(BlockUtils.stoneBrick(this.rand));
            w.getLeft().setType(BlockUtils.stoneBrick(this.rand));
            w.getRight().setType(BlockUtils.stoneBrick(this.rand));
        }
        base = new SimpleBlock(data, room.getX(), room.getY() + 1, room.getZ());
        for (int nx = -1; nx <= 1; ++nx) {
            for (int nz = -1; nz <= 1; ++nz) {
                base.getRelative(nx, 0, nz).setType(Material.LAVA);
            }
        }
        for (BlockFace face : BlockUtils.directBlockFaces) {
            w = new Wall(base.getRelative(face).getRelative(face).getRelative(face), face);
            w.setType(BlockUtils.stoneBrick(this.rand));
            w.getLeft().setType(BlockUtils.stoneBrick(this.rand));
            w.getRight().setType(BlockUtils.stoneBrick(this.rand));
            w.getLeft().getLeft().setType(BlockUtils.stoneBrick(this.rand));
            w.getRight().getRight().setType(BlockUtils.stoneBrick(this.rand));
            w.getUp().setType(BlockUtils.stoneBrickSlab(this.rand));
            w.getUp().getLeft().setType(BlockUtils.stoneBrickSlab(this.rand));
            w.getUp().getRight().setType(BlockUtils.stoneBrickSlab(this.rand));
            w.getLeft().getLeft().getLeft().setType(BlockUtils.stoneBrickSlab(this.rand));
            w.getRight().getRight().getRight().setType(BlockUtils.stoneBrickSlab(this.rand));
            Stairs stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
            stairs.setFacing(face.getOppositeFace());
            w.getFront().setBlockData((BlockData)stairs);
            w.getLeft().getFront().setBlockData((BlockData)stairs);
            w.getRight().getFront().setBlockData((BlockData)stairs);
            w.getLeft().getFront().getLeft().setType(BlockUtils.stoneBrickSlab(this.rand));
            w.getRight().getFront().getRight().setType(BlockUtils.stoneBrickSlab(this.rand));
        }
        this.decoratedPillar(this.rand, data, room.getX() + 6, room.getY() + 1, room.getZ() + 6, room.getHeight() - 2);
        this.decoratedPillar(this.rand, data, room.getX() - 6, room.getY() + 1, room.getZ() + 6, room.getHeight() - 2);
        this.decoratedPillar(this.rand, data, room.getX() + 6, room.getY() + 1, room.getZ() - 6, room.getHeight() - 2);
        this.decoratedPillar(this.rand, data, room.getX() - 6, room.getY() + 1, room.getZ() - 6, room.getHeight() - 2);
        this.lavaPool(data, room.getX() + 8, room.getY() + 1, room.getZ(), room.getHeight() - 2);
        this.lavaPool(data, room.getX() - 8, room.getY() + 1, room.getZ(), room.getHeight() - 2);
        Wall w2 = new Wall(new SimpleBlock(data, room.getX() + 6, room.getY() + 1, room.getZ()), BlockFace.WEST);
        for (i = 0; i < 4; ++i) {
            w2.setType(Material.LAVA);
            if (i == 0 || i == 3) {
                w2.getLeft().setType(Material.CHISELED_STONE_BRICKS);
                w2.getRight().setType(Material.CHISELED_STONE_BRICKS);
            } else {
                Stairs stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
                stairs.setFacing(BlockUtils.getAdjacentFaces(w2.getDirection())[1]);
                w2.getLeft().setBlockData((BlockData)stairs);
                stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
                stairs.setFacing(BlockUtils.getAdjacentFaces(w2.getDirection())[0]);
                w2.getRight().setBlockData((BlockData)stairs);
            }
            w2 = w2.getFront();
        }
        w2 = new Wall(new SimpleBlock(data, room.getX() - 6, room.getY() + 1, room.getZ()), BlockFace.EAST);
        for (i = 0; i < 4; ++i) {
            w2.setType(Material.LAVA);
            if (i == 0 || i == 3) {
                w2.getLeft().setType(Material.CHISELED_STONE_BRICKS);
                w2.getRight().setType(Material.CHISELED_STONE_BRICKS);
            } else {
                Stairs stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
                stairs.setFacing(BlockUtils.getAdjacentFaces(w2.getDirection())[1]);
                w2.getLeft().setBlockData((BlockData)stairs);
                stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
                stairs.setFacing(BlockUtils.getAdjacentFaces(w2.getDirection())[0]);
                w2.getRight().setBlockData((BlockData)stairs);
            }
            w2 = w2.getFront();
        }
    }

    public void lavaPool(@NotNull PopulatorDataAbstract data, int x, int y, int z, int height) {
        int nz;
        int nx;
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Wall w = new Wall(new SimpleBlock(data, x, y, z), face).getFront().getFront();
            Stairs stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
            stairs.setFacing(face.getOppositeFace());
            w.setBlockData((BlockData)stairs);
            w.getLeft().setBlockData((BlockData)stairs);
            w.getRight().setBlockData((BlockData)stairs);
            w.getRight().getRight().setType(Material.CHISELED_STONE_BRICKS);
        }
        for (nx = -1; nx <= 1; ++nx) {
            for (nz = -1; nz <= 1; ++nz) {
                data.setType(x + nx, y, z + nz, Material.LAVA);
            }
        }
        for (nx = -1; nx <= 1; ++nx) {
            for (nz = -1; nz <= 1; ++nz) {
                data.setType(x + nx, y + height, z + nz, Material.CHISELED_STONE_BRICKS);
                if (nx != 0 || nz != 0) continue;
                data.setType(x, y + height, z, Material.LAVA);
            }
        }
    }

    public void decoratedPillar(@NotNull Random rand, @NotNull PopulatorDataAbstract data, int x, int y, int z, int height) {
        Stairs stairs;
        BlockUtils.spawnPillar(rand, data, x, y, z, Material.CHISELED_STONE_BRICKS, height, height);
        BlockUtils.spawnPillar(rand, data, x + 1, y, z + 1, Material.COBBLESTONE_WALL, height, height);
        BlockUtils.spawnPillar(rand, data, x - 1, y, z + 1, Material.COBBLESTONE_WALL, height, height);
        BlockUtils.spawnPillar(rand, data, x + 1, y, z - 1, Material.COBBLESTONE_WALL, height, height);
        BlockUtils.spawnPillar(rand, data, x - 1, y, z - 1, Material.COBBLESTONE_WALL, height, height);
        data.setType(x + 1, y, z + 1, Material.CHISELED_STONE_BRICKS);
        data.setType(x - 1, y, z + 1, Material.CHISELED_STONE_BRICKS);
        data.setType(x + 1, y, z - 1, Material.CHISELED_STONE_BRICKS);
        data.setType(x - 1, y, z - 1, Material.CHISELED_STONE_BRICKS);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
            stairs.setFacing(face.getOppositeFace());
            data.setBlockData(x + face.getModX(), y, z + face.getModZ(), (BlockData)stairs);
        }
        for (BlockFace face : BlockUtils.directBlockFaces) {
            stairs = (Stairs)Bukkit.createBlockData((Material)Material.POLISHED_ANDESITE_STAIRS);
            stairs.setFacing(face.getOppositeFace());
            stairs.setHalf(Bisected.Half.TOP);
            data.setBlockData(x + face.getModX(), y + height, z + face.getModZ(), (BlockData)stairs);
        }
        data.setType(x + 1, y + height, z + 1, Material.CHISELED_STONE_BRICKS);
        data.setType(x - 1, y + height, z + 1, Material.CHISELED_STONE_BRICKS);
        data.setType(x + 1, y + height, z - 1, Material.CHISELED_STONE_BRICKS);
        data.setType(x - 1, y + height, z - 1, Material.CHISELED_STONE_BRICKS);
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() == 25 && room.getWidthZ() == 25 && room.getHeight() == 15;
    }

    private void ceilDecor(@NotNull SimpleBlock ceil) {
        ceil.setType(Material.CHISELED_STONE_BRICKS);
        ceil.getRelative(0, 0, -1).setType(Material.CHISELED_STONE_BRICKS);
        ceil.getRelative(0, 0, -2).setType(Material.MOSSY_STONE_BRICKS);
        ceil.getRelative(0, 0, -3).setType(Material.MOSSY_COBBLESTONE);
        ceil.getRelative(0, 0, -4).setBlockData((BlockData)this.randTopSlab());
        ceil.getRelative(0, 0, 1).setType(Material.CHISELED_STONE_BRICKS);
        ceil.getRelative(0, 0, 2).setType(Material.MOSSY_STONE_BRICKS);
        ceil.getRelative(0, 0, 3).setType(Material.MOSSY_COBBLESTONE);
        ceil.getRelative(0, 0, 4).setBlockData((BlockData)this.randTopSlab());
        for (int i : new int[]{-1, 1}) {
            ceil.getRelative(i, 0, -1).setType(Material.MOSSY_STONE_BRICKS);
            ceil.getRelative(i, 0, 0).setType(Material.MOSSY_STONE_BRICKS);
            ceil.getRelative(i, 0, 1).setType(Material.MOSSY_STONE_BRICKS);
            ceil.getRelative(2 * i, 0, -1).setType(Material.MOSSY_COBBLESTONE);
            ceil.getRelative(2 * i, 0, 0).setType(Material.MOSSY_COBBLESTONE);
            ceil.getRelative(2 * i, 0, 1).setType(Material.MOSSY_COBBLESTONE);
            ceil.getRelative(i, 0, -2).setType(Material.MOSSY_COBBLESTONE);
            ceil.getRelative(i, 0, 2).setType(Material.MOSSY_COBBLESTONE);
            SimpleBlock[] blocks = new SimpleBlock[]{ceil.getRelative(3 * i, 0, -1), ceil.getRelative(3 * i, 0, 0), ceil.getRelative(3 * i, 0, 1), ceil.getRelative(i, 0, 3), ceil.getRelative(i, 0, -3), ceil.getRelative(2 * i, 0, 2), ceil.getRelative(2 * i, 0, -2)};
            for (SimpleBlock b2 : blocks) {
                b2.setType(Material.COBBLESTONE);
            }
            for (SimpleBlock b2 : blocks) {
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    b2.getRelative(face).lsetBlockData((BlockData)this.randTopSlab());
                }
            }
        }
    }
}

