/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.AbstractMap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;

public abstract class PlainsVillageAbstractRoomPopulator
extends RoomPopulatorAbstract {
    public PlainsVillageAbstractRoomPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int roomY = this.calculateRoomY(data, room);
        int worldHeight = TerraformGeneratorPlugin.injector.getMaxY() - TerraformGeneratorPlugin.injector.getMinY() + 1;
        for (int[] corner : room.getAllCorners(2)) {
            SimpleBlock sb = new SimpleBlock(data, corner[0], roomY, corner[1]);
            int lowSb = sb.findFloor(worldHeight).getY();
            if (Math.abs(lowSb - roomY) <= TConfig.c.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE) continue;
            this.placeFixerPlatform(roomY, data, room);
            break;
        }
    }

    public void placeFixerPlatform(int roomY, @NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        SimpleBlock core = room.getCenterSimpleBlock(data);
        core = core.getAtY(roomY);
        new SphereBuilder(this.rand, core.getUp(), Material.AIR).setRX((float)room.getWidthX() / 2.0f - 1.5f).setRZ((float)room.getWidthZ() / 2.0f - 1.5f).setRY(this.getRoomRoughNeededHeight()).setHardReplace(true).setSphereType(SphereBuilder.SphereType.UPPER_SEMISPHERE).build();
        new SphereBuilder(this.rand, core.getDown(), Material.DIRT).setRX((float)room.getWidthX() / 2.0f).setRZ((float)room.getWidthZ() / 2.0f).setRY(3.0f).setPadding(4).setSphereFrequency(0.11f).setMinRadius(0.8).setHardReplace(false).setUpperType(Material.GRASS_BLOCK).setSphereType(SphereBuilder.SphereType.LOWER_SEMISPHERE).build();
    }

    public int getRoomRoughNeededHeight() {
        return 12;
    }

    protected int calculateRoomY(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int pathHeight;
        int centerHeight = GenUtils.getHighestGroundOrSeaLevel(data, room.getX(), room.getZ());
        if (Math.abs(centerHeight - (pathHeight = this.getPathHeight(data, room))) > TConfig.c.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE) {
            return pathHeight;
        }
        return centerHeight;
    }

    protected boolean doesAreaFailTolerance(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int roomY = this.calculateRoomY(data, room);
        int worldHeight = TerraformGeneratorPlugin.injector.getMaxY() - TerraformGeneratorPlugin.injector.getMinY() + 1;
        for (int[] corner : room.getAllCorners(2)) {
            SimpleBlock sb = new SimpleBlock(data, corner[0], roomY, corner[1]);
            int lowSb = sb.findFloor(worldHeight).getY();
            if (Math.abs(lowSb - roomY) <= TConfig.c.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE) continue;
            return true;
        }
        return false;
    }

    protected int getPathHeight(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        BlockFace dir = ((DirectionalCubeRoom)room).getDirection();
        int pad = GenUtils.randInt(1, 3);
        AbstractMap.SimpleEntry<Wall, Integer> openingWallSet = room.getWall(data, dir, pad);
        int pathHeight = ((Wall)openingWallSet.getKey()).getLeft((Integer)openingWallSet.getValue() / 2).getGroundOrSeaLevel().getY();
        return pathHeight;
    }
}

