/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.Random;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.structure.village.plains.PlainsVillageAbstractRoomPopulator;
import org.terraform.structure.village.plains.PlainsVillagePathPopulator;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeJigsawBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class PlainsVillageForgePopulator
extends PlainsVillageAbstractRoomPopulator {
    private final PlainsVillagePopulator plainsVillagePopulator;

    public PlainsVillageForgePopulator(PlainsVillagePopulator plainsVillagePopulator, Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
        this.plainsVillagePopulator = plainsVillagePopulator;
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        super.populate(data, room);
        int height = super.calculateRoomY(data, room);
        PlainsVillageForgeJigsawBuilder builder = new PlainsVillageForgeJigsawBuilder(this.plainsVillagePopulator, room.getWidthX() - 3, room.getWidthZ() - 3, data, room.getX(), height + 1, room.getZ());
        if (room instanceof DirectionalCubeRoom) {
            builder.forceEntranceDirection(((DirectionalCubeRoom)room).getDirection());
        }
        builder.generate(this.rand);
        builder.build(this.rand);
        Wall entrance = builder.getEntranceBlock().getGround();
        boolean placedLamp = false;
        for (int maxDepth = 12; entrance.getType() != Material.DIRT_PATH && maxDepth > 0; --maxDepth) {
            SimpleBlock target;
            if (BlockUtils.isDirtLike(entrance.getType())) {
                entrance.setType(Material.DIRT_PATH);
            }
            if (!placedLamp && GenUtils.chance(this.rand, 3, 5) && PlainsVillagePathPopulator.canPlaceLamp(target = this.rand.nextBoolean() ? entrance.getLeft(2).getGround().getUp().get() : entrance.getRight(2).getGround().getUp().get())) {
                placedLamp = true;
                PlainsVillagePathPopulator.placeLamp(this.rand, target);
            }
            entrance = entrance.getFront().getGround();
        }
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() >= 15;
    }
}

