/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.Collection;
import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class PlainsVillagePathPopulator
extends PathPopulatorAbstract {
    final TerraformWorld tw;
    private final Random random;
    private final Collection<DirectionalCubeRoom> knownRooms;

    public PlainsVillagePathPopulator(TerraformWorld tw, Collection<DirectionalCubeRoom> collection, Random rand) {
        this.tw = tw;
        this.random = rand;
        this.knownRooms = collection;
    }

    public static void placeLamp(@NotNull Random rand, @NotNull SimpleBlock b2) {
        b2.setType(GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS}));
        b2.getUp().setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
        b2.getUp(2).setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
        b2.getUp(3).setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.MOSSY_COBBLESTONE}));
        b2.getUp(4).setType(Material.CAMPFIRE);
        b2.getUp(5).setType(GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS}));
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Slab tSlab = (Slab)Bukkit.createBlockData((Material)GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB}));
            tSlab.setType(Slab.Type.TOP);
            b2.getRelative(face).getUp(3).setBlockData((BlockData)tSlab);
            b2.getRelative(face).getUp(4).setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
            b2.getRelative(face).getUp(5).setType(GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB}));
        }
    }

    public static boolean canPlaceLamp(@NotNull SimpleBlock target) {
        if (target.getType() == Material.WATER) {
            return false;
        }
        for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
            for (int i = 0; i < 6; ++i) {
                if (!target.getRelative(face).getRelative(0, i, 0).isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void populate(@NotNull PathPopulatorData ppd) {
        ppd.base = new SimpleBlock(ppd.base.getPopData(), ppd.base.getX(), GenUtils.getHighestGround(ppd.base.getPopData(), ppd.base.getX(), ppd.base.getZ()), ppd.base.getZ());
        if (BlockUtils.isWet(ppd.base.getUp())) {
            Wall pathCore = new Wall(ppd.base, ppd.dir).getAtY(TerraformGenerator.seaLevel);
            if (BlockUtils.getAxisFromBlockFace(ppd.dir) == Axis.X && ppd.base.getX() % 2 == 0 || BlockUtils.getAxisFromBlockFace(ppd.dir) == Axis.Z && ppd.base.getZ() % 2 == 0) {
                pathCore.getDown().downLPillar(this.random, 50, Material.OAK_LOG);
                pathCore.setType(Material.CHISELED_STONE_BRICKS);
            }
            return;
        }
        Wall pathCore = new Wall(ppd.base, ppd.dir);
        block0: for (BlockFace blockFace : BlockUtils.getAdjacentFaces(ppd.dir)) {
            for (int i = 0; i < 4; ++i) {
                Wall target = pathCore.getRelative(blockFace, i).getGround();
                if (target.getUp().isSolid() || target.getUp().getType() == Material.WATER || !BlockUtils.isDirtLike(target.getType()) || target.getType() == Material.DIRT_PATH) continue;
                if (GenUtils.chance(2, 5)) {
                    PlantBuilder.OAK_LEAVES.build(target.getUp());
                    continue block0;
                }
                if (GenUtils.chance(1, 5)) {
                    BlockUtils.pickTallFlower().build(target);
                    continue block0;
                }
                if (!GenUtils.chance(1, 10)) continue block0;
                target.getUp().setType(Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL);
                if (!TConfig.areDecorationsEnabled()) continue block0;
                target.getUp(2).setType(Material.LANTERN);
                continue block0;
            }
        }
        if (GenUtils.chance(this.random, 1, 15)) {
            BlockFace side = BlockUtils.getTurnBlockFace(this.random, ppd.dir);
            SimpleBlock target = new SimpleBlock(ppd.base.getPopData(), ppd.base.getX() + side.getModX() * 3, GenUtils.getHighestGround(ppd.base.getPopData(), ppd.base.getX() + side.getModX() * 3, ppd.base.getZ() + side.getModZ() * 3), ppd.base.getZ() + side.getModZ() * 3);
            if (target.getType() == Material.DIRT_PATH) {
                return;
            }
            for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                if (!target.getRelative(face).getGround().getUp().isSolid()) continue;
                return;
            }
            for (CubeRoom cubeRoom : this.knownRooms) {
                if (!cubeRoom.isPointInside(target)) continue;
                return;
            }
            PlainsVillagePathPopulator.placeLamp(this.random, target.getUp());
        }
    }
}

