/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;

public class PlainsVillagePondPopulator
extends RoomPopulatorAbstract {
    public PlainsVillagePondPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int[] lowerCorner = room.getLowerCorner();
        int[] upperCorner = room.getUpperCorner();
        int lowest = 256;
        int highest = -1;
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                int ground = GenUtils.getHighestGround(data, x, z);
                if (ground < lowest) {
                    lowest = ground;
                }
                if (ground <= highest) continue;
                highest = ground;
            }
        }
        if (highest - lowest >= 5) {
            return;
        }
        SimpleBlock core = new SimpleBlock(data, room.getX(), 0, room.getZ());
        core = core.getGround();
        int depth = GenUtils.randInt(3, 5);
        BlockUtils.replaceLowerSphere(this.rand.nextInt(12222), (float)room.getWidthX() / 2.0f - 1.5f, depth, (float)room.getWidthZ() / 2.0f - 1.5f, core, true, Material.AIR);
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                int ground = GenUtils.getHighestGround(data, x, z);
                if (ground < lowest) {
                    lowest = ground;
                }
                if (ground <= highest) continue;
                highest = ground;
            }
        }
        ArrayList<SimpleBlock> lakeWaterBlocks = this.getLakeWaterBlocks(core, lowerCorner, upperCorner, lowest);
        if (lakeWaterBlocks.isEmpty()) {
            return;
        }
        int pondSurface = -1;
        for (SimpleBlock s : lakeWaterBlocks) {
            s.setType(Material.WATER);
            if (s.getY() <= pondSurface) continue;
            pondSurface = s.getY();
        }
        boolean placedJobBlock = false;
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                SimpleBlock target = new SimpleBlock(core.getPopData(), x, 0, z).getGround();
                if (target.getUp().getType() == Material.AIR) {
                    boolean valid = false;
                    for (BlockFace face : BlockUtils.directBlockFaces) {
                        if (target.getRelative(face).getType() != Material.WATER) continue;
                        valid = true;
                    }
                    if (!valid) continue;
                    target = target.getUp();
                    if (GenUtils.chance(1, 4)) {
                        PlantBuilder.SUGAR_CANE.build(target, this.rand, 2, 5);
                        continue;
                    }
                    if (GenUtils.chance(1, 4)) {
                        PlantBuilder.OAK_LEAVES.build(target);
                        continue;
                    }
                    if (GenUtils.chance(1, 4)) {
                        PlantBuilder.build(core.getPopData(), target.getX(), target.getY(), target.getZ(), PlantBuilder.LARGE_FERN, PlantBuilder.TALL_GRASS);
                        continue;
                    }
                    if (placedJobBlock || !TConfig.areDecorationsEnabled() || !GenUtils.chance(2, 5)) continue;
                    target.setType(Material.BARREL);
                    placedJobBlock = true;
                    continue;
                }
                if (target.getUp().getType() != Material.WATER) continue;
                target = target.getUp();
                if (GenUtils.chance(1, 5)) {
                    PlantBuilder.LILY_PAD.build(target.getAtY(pondSurface).getUp());
                } else if (GenUtils.chance(1, 5)) {
                    CoralGenerator.generateKelpGrowth(data, x, target.getY(), z);
                } else if (GenUtils.chance(1, 7)) {
                    CoralGenerator.generateSeaPickles(data, x, target.getY(), z);
                }
                if (!TConfig.areAnimalsEnabled() || !GenUtils.chance(1, 20)) continue;
                core.getPopData().addEntity(target.getX(), target.getY(), target.getZ(), EntityType.TROPICAL_FISH);
            }
        }
    }

    @NotNull
    private ArrayList<SimpleBlock> getLakeWaterBlocks(@NotNull SimpleBlock core, int @NotNull [] lowerCorner, int @NotNull [] upperCorner, int lowestPoint) {
        int layer = 0;
        ArrayList<SimpleBlock> lakeBlocks = new ArrayList<SimpleBlock>();
        while (true) {
            boolean layerValid = true;
            block1: for (int x : new int[]{lowerCorner[0], upperCorner[0]}) {
                for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                    if (!core.getPopData().getType(x, lowestPoint + layer, z).isSolid()) {
                        layerValid = false;
                        continue block1;
                    }
                    if (!layerValid) continue block1;
                }
            }
            if (layerValid) {
                block3: for (int z : new int[]{lowerCorner[1], upperCorner[1]}) {
                    for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
                        if (!core.getPopData().getType(x, lowestPoint + layer, z).isSolid()) {
                            layerValid = false;
                            continue block3;
                        }
                        if (!layerValid) continue block3;
                    }
                }
            }
            if (!layerValid) break;
            for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
                for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                    if (core.getPopData().getType(x, lowestPoint + layer, z).isSolid()) continue;
                    lakeBlocks.add(new SimpleBlock(core.getPopData(), x, lowestPoint + layer, z));
                }
            }
            ++layer;
        }
        return lakeBlocks;
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() <= 10 && room.getWidthZ() > 5 && room.getWidthX() > 5;
    }
}

