/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.Locale;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.village.VillagePopulator;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.structure.village.plains.PlainsPathRecursiveSpawner;
import org.terraform.structure.village.plains.PlainsVillageAnimalPenPopulator;
import org.terraform.structure.village.plains.PlainsVillageCropFarmPopulator;
import org.terraform.structure.village.plains.PlainsVillageForgePopulator;
import org.terraform.structure.village.plains.PlainsVillageFountainPopulator;
import org.terraform.structure.village.plains.PlainsVillagePathPopulator;
import org.terraform.structure.village.plains.PlainsVillagePondPopulator;
import org.terraform.structure.village.plains.PlainsVillageStandardHousePopulator;
import org.terraform.structure.village.plains.PlainsVillageTemplePopulator;
import org.terraform.structure.village.plains.PlainsVillageTownhallPopulator;
import org.terraform.structure.village.plains.PlainsVillageWellPopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.WoodUtils;

public class PlainsVillagePopulator
extends VillagePopulator {
    @NotNull
    public Material woodSlab = Material.OAK_SLAB;
    @NotNull
    public Material woodPlank = Material.OAK_PLANKS;
    @NotNull
    public Material woodLog = Material.OAK_LOG;
    @NotNull
    public Material woodStrippedLog = Material.STRIPPED_OAK_LOG;
    @NotNull
    public Material woodFence = Material.OAK_FENCE;
    @NotNull
    public Material woodButton = Material.OAK_BUTTON;
    @NotNull
    public Material woodTrapdoor = Material.OAK_TRAPDOOR;
    @NotNull
    public Material woodDoor = Material.OAK_DOOR;
    @NotNull
    public Material woodStairs = Material.OAK_STAIRS;
    @NotNull
    public Material woodLeaves = Material.OAK_LEAVES;
    @NotNull
    public Material woodPressurePlate = Material.OAK_PRESSURE_PLATE;
    @NotNull
    public String wood = "oak_";

    @Override
    public void populate(@NotNull TerraformWorld tw, @NotNull PopulatorDataAbstract data) {
        MegaChunk mc = new MegaChunk(data.getChunkX(), data.getChunkZ());
        int[] coords = mc.getCenterBiomeSectionBlockCoords();
        int x = coords[0];
        int z = coords[1];
        this.spawnPlainsVillage(tw, this.getHashedRandom(tw, data.getChunkX(), data.getChunkZ()), data, x, 50, z);
    }

    private void ensureFarmHouseEntrance(@NotNull Random rand, @NotNull DirectionalCubeRoom room, @NotNull PopulatorDataAbstract data) {
        int max;
        int frontSpaceGuarantee = 11;
        Wall w = new Wall(new SimpleBlock(data, room.getX(), room.getY(), room.getZ()).getGround(), room.getDirection()).getUp(4);
        int elevation = GenUtils.randInt(rand, 2, 4);
        block5: for (max = 30; max > 0 && !this.isFrontSpaceClear(w, frontSpaceGuarantee); --max) {
            switch (rand.nextInt(3)) {
                case 0: {
                    w = w.getFront().getGround().getRelative(0, elevation, 0);
                    continue block5;
                }
                case 1: {
                    w = new Wall(w.get(), BlockUtils.getTurnBlockFace(rand, w.getDirection()));
                    continue block5;
                }
                case 2: {
                    elevation += 2;
                }
            }
        }
        Wall temp = w.getGround().getUp(elevation);
        while (BlockUtils.isWet(temp) || BlockUtils.isWet(temp.getDown())) {
            temp = temp.getUp();
            ++elevation;
        }
        if (max == 0) {
            TerraformGeneratorPlugin.logger.info("Village at " + String.valueOf(w.get().toVector()) + " may have a weird spawn.");
        }
        room.setX(w.getX());
        room.setY(w.getY());
        room.setZ(w.getZ());
        room.setDirection(w.getDirection());
        ((PlainsVillageTownhallPopulator)room.getPop()).setElevation(elevation);
    }

    private boolean isFrontSpaceClear(@NotNull Wall w, int space) {
        for (int i = 0; i < space; ++i) {
            if (!w.getFront(i).isSolid()) continue;
            return false;
        }
        return true;
    }

    public void spawnPlainsVillage(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        BlockFace pathStart = BlockUtils.getDirectBlockFace(random);
        TerraformGeneratorPlugin.logger.info("Spawning plains village at " + x + "," + y + "," + z);
        DirectionalCubeRoom townHall = new DirectionalCubeRoom(pathStart, 24, 24, 24, x, y, z);
        PlainsVillageTownhallPopulator townHallPop = new PlainsVillageTownhallPopulator(tw, random, false, false);
        townHall.setRoomPopulator(townHallPop);
        this.ensureFarmHouseEntrance(random, townHall, data);
        pathStart = townHall.getDirection();
        BiomeBank biome = tw.getBiomeBank(townHall.getX(), townHall.getZ());
        this.woodSlab = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.SLAB);
        this.woodPlank = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.PLANKS);
        this.woodLog = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.LOG);
        this.woodStairs = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.STAIRS);
        this.woodFence = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.FENCE);
        this.woodStrippedLog = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.STRIPPED_LOG);
        this.woodButton = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.BUTTON);
        this.woodTrapdoor = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.TRAPDOOR);
        this.woodPressurePlate = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.PRESSURE_PLATE);
        this.woodDoor = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.DOOR);
        this.woodLeaves = WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.LEAVES);
        this.wood = this.woodLeaves.toString().toLowerCase(Locale.ENGLISH).replace("leaves", "");
        PlainsPathRecursiveSpawner spawner = new PlainsPathRecursiveSpawner(new SimpleBlock(data, townHall.getX() + pathStart.getModX() * 13, y, townHall.getZ() + pathStart.getModZ() * 13), 100, BlockUtils.getAdjacentFaces(pathStart));
        spawner.forceRegisterRoom(townHall);
        spawner.setVillageDensity(0.7);
        spawner.setPathPop(new PlainsVillagePathPopulator(tw, spawner.getRooms().values(), random));
        spawner.registerRoomPopulator(new PlainsVillageStandardHousePopulator(this, random, false, false));
        spawner.registerRoomPopulator(new PlainsVillageTemplePopulator(this, random, false, true));
        spawner.registerRoomPopulator(new PlainsVillageForgePopulator(this, random, false, true));
        spawner.registerRoomPopulator(new PlainsVillageCropFarmPopulator(this, random, false, false));
        spawner.registerRoomPopulator(new PlainsVillageAnimalPenPopulator(this, random, false, false));
        spawner.registerRoomPopulator(new PlainsVillageWellPopulator(this, random, false, false));
        spawner.registerRoomPopulator(new PlainsVillageFountainPopulator(this, random, false, true));
        spawner.registerRoomPopulator(new PlainsVillagePondPopulator(random, false, false));
        spawner.generate(random);
        spawner.build(random);
    }
}

