/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.forge;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawBuilder;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeChimneyPiece;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeEntrancePiece;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeMasonPiece;
import org.terraform.structure.village.plains.forge.PlainsVillageForgePiece;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeRoofHandler;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeWallPiece;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeWeaponSmithPiece;
import org.terraform.utils.BlockUtils;

public class PlainsVillageForgeJigsawBuilder
extends JigsawBuilder {
    private final PlainsVillagePopulator plainsVillagePopulator;

    public PlainsVillageForgeJigsawBuilder(PlainsVillagePopulator plainsVillagePopulator, int widthX, int widthZ, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        super(widthX, widthZ, data, x, y, z);
        this.plainsVillagePopulator = plainsVillagePopulator;
        this.pieceRegistry = new JigsawStructurePiece[]{new PlainsVillageForgeWeaponSmithPiece(plainsVillagePopulator, 5, 3, 5, JigsawType.STANDARD, BlockUtils.directBlockFaces), new PlainsVillageForgeMasonPiece(plainsVillagePopulator, 5, 3, 5, JigsawType.STANDARD, BlockUtils.directBlockFaces), new PlainsVillageForgeWallPiece(plainsVillagePopulator, 5, 3, 5, JigsawType.END, BlockUtils.directBlockFaces), new PlainsVillageForgeEntrancePiece(plainsVillagePopulator, 5, 3, 5, JigsawType.ENTRANCE, BlockUtils.directBlockFaces)};
        this.chanceToAddNewPiece = 50;
    }

    @Override
    @NotNull
    public JigsawStructurePiece getFirstPiece(@NotNull Random random) {
        return new PlainsVillageForgeChimneyPiece(this.plainsVillagePopulator, 5, 3, 5, JigsawType.STANDARD, BlockUtils.directBlockFaces);
    }

    @Override
    public void build(@NotNull Random random) {
        super.build(random);
        ArrayList<SimpleLocation> rectanglePieces = PlainsVillageForgeRoofHandler.identifyRectangle(this.pieces);
        ArrayList<JigsawStructurePiece> builtWalls = new ArrayList<JigsawStructurePiece>();
        for (JigsawStructurePiece piece : this.pieces.values()) {
            PlainsVillageForgeWallPiece.PlainsVillageForgeWallType wallType = PlainsVillageForgeWallPiece.PlainsVillageForgeWallType.FENCE;
            if (rectanglePieces.contains(piece.getRoom().getSimpleLocation())) {
                wallType = PlainsVillageForgeWallPiece.PlainsVillageForgeWallType.SOLID;
            }
            ((PlainsVillageForgePiece)piece).setWallType(wallType);
            for (BlockFace face : BlockUtils.directBlockFaces) {
                JigsawStructurePiece wall = this.getAdjacentWall(piece.getRoom().getSimpleLocation(), face);
                if (wall == null || builtWalls.contains(wall)) continue;
                builtWalls.add(wall);
                ((PlainsVillageForgePiece)wall).setWallType(wallType);
            }
        }
        for (JigsawStructurePiece piece : this.pieces.values()) {
            Wall target;
            SimpleBlock core = new SimpleBlock(this.core.getPopData(), piece.getRoom().getX(), piece.getRoom().getY(), piece.getRoom().getZ());
            PlainsVillageForgeWallPiece.PlainsVillageForgeWallType type = PlainsVillageForgeWallPiece.PlainsVillageForgeWallType.FENCE;
            if (rectanglePieces.contains(piece.getRoom().getSimpleLocation())) {
                type = PlainsVillageForgeWallPiece.PlainsVillageForgeWallType.SOLID;
            }
            if (piece.getWalledFaces().contains(BlockFace.NORTH) && piece.getWalledFaces().contains(BlockFace.WEST)) {
                target = new Wall(core.getRelative(-3, 0, -3));
                this.decorateAwkwardCorner(target, random, BlockFace.NORTH, BlockFace.WEST, type);
            }
            if (piece.getWalledFaces().contains(BlockFace.NORTH) && piece.getWalledFaces().contains(BlockFace.EAST)) {
                target = new Wall(core.getRelative(3, 0, -3));
                this.decorateAwkwardCorner(target, random, BlockFace.NORTH, BlockFace.EAST, type);
            }
            if (piece.getWalledFaces().contains(BlockFace.SOUTH) && piece.getWalledFaces().contains(BlockFace.WEST)) {
                target = new Wall(core.getRelative(-3, 0, 3));
                this.decorateAwkwardCorner(target, random, BlockFace.SOUTH, BlockFace.WEST, type);
            }
            if (!piece.getWalledFaces().contains(BlockFace.SOUTH) || !piece.getWalledFaces().contains(BlockFace.EAST)) continue;
            target = new Wall(core.getRelative(3, 0, 3));
            this.decorateAwkwardCorner(target, random, BlockFace.SOUTH, BlockFace.EAST, type);
        }
        PlainsVillageForgeRoofHandler.placeRoof(this.plainsVillagePopulator, this.core, rectanglePieces);
        for (JigsawStructurePiece piece : this.overlapperPieces) {
            piece.postBuildDecoration(random, this.core.getPopData());
        }
        for (JigsawStructurePiece piece : this.pieces.values()) {
            piece.postBuildDecoration(random, this.core.getPopData());
        }
    }

    public void decorateAwkwardCorner(@NotNull Wall target, @NotNull Random random, BlockFace one, BlockFace two, PlainsVillageForgeWallPiece.PlainsVillageForgeWallType wallType) {
        if (wallType == PlainsVillageForgeWallPiece.PlainsVillageForgeWallType.SOLID) {
            target.Pillar(4, random, this.plainsVillagePopulator.woodLog);
            target.getDown().downUntilSolid(random, this.plainsVillagePopulator.woodLog);
            target.getUp();
        } else {
            target.Pillar(2, random, this.plainsVillagePopulator.woodLog);
            target.getUp(2).setType(Material.STONE_SLAB, Material.COBBLESTONE_SLAB, Material.ANDESITE_SLAB);
            target.getDown().downUntilSolid(random, this.plainsVillagePopulator.woodLog);
        }
    }
}

