/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.forge;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeStandardPiece;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.ChestBuilder;
import org.terraform.utils.blockdata.DirectionalBuilder;

public class PlainsVillageForgeWeaponSmithPiece
extends PlainsVillageForgeStandardPiece {
    public PlainsVillageForgeWeaponSmithPiece(PlainsVillagePopulator plainsVillagePopulator, int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(plainsVillagePopulator, widthX, height, widthZ, type, validDirs);
    }

    @Override
    public void postBuildDecoration(@NotNull Random random, @NotNull PopulatorDataAbstract data) {
        if (this.getWalledFaces().isEmpty()) {
            return;
        }
        ArrayList<BlockFace> walledFaces = this.getWalledFaces();
        Collections.shuffle(walledFaces);
        boolean placedJobBlock = false;
        for (BlockFace face : walledFaces) {
            AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, face, 0);
            Wall w = (Wall)entry.getKey();
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                if (w.getRear().getDown().getType() != Material.CHISELED_STONE_BRICKS) {
                    int choice = random.nextInt(4);
                    switch (choice) {
                        case 0: {
                            if (placedJobBlock) break;
                            placedJobBlock = true;
                            w.setType(Material.SMITHING_TABLE, Material.FLETCHING_TABLE);
                            break;
                        }
                        case 1: {
                            if (GenUtils.chance(random, 3, 4)) break;
                            w.setType(Material.CRAFTING_TABLE);
                            w.getUp().setType(Material.LANTERN);
                            if (!w.getUp().getRear().isSolid() || placedJobBlock) break;
                            placedJobBlock = true;
                            new DirectionalBuilder(Material.GRINDSTONE).setFacing(w.getDirection()).apply(w.getUp());
                            break;
                        }
                        case 2: {
                            if (GenUtils.chance(random, 3, 4)) break;
                            new DirectionalBuilder(Material.ANVIL, Material.CHIPPED_ANVIL, Material.DAMAGED_ANVIL).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w);
                            break;
                        }
                        case 3: {
                            if (!GenUtils.chance(random, 1, 4)) break;
                            new ChestBuilder(Material.CHEST).setFacing(w.getDirection()).setLootTable(TerraLootTable.VILLAGE_ARMORER).apply(w);
                        }
                    }
                }
                w = w.getLeft();
            }
        }
    }
}

