/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.house;

import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.house.PlainsVillageHouseJigsawBuilder;
import org.terraform.structure.village.plains.house.PlainsVillageHouseVariant;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.blockdata.TrapdoorBuilder;

public class PlainsVillageRoofHandler {
    public static boolean isRectangle(@NotNull PlainsVillageHouseJigsawBuilder builder) {
        int[] lowestCoords = null;
        int[] highestCoords = null;
        int y = 0;
        for (JigsawStructurePiece piece : builder.getPieces().values()) {
            if (lowestCoords == null) {
                y = piece.getRoom().getY();
                lowestCoords = new int[]{piece.getRoom().getX(), piece.getRoom().getZ()};
            }
            if (highestCoords == null) {
                highestCoords = new int[]{piece.getRoom().getX(), piece.getRoom().getZ()};
            }
            if (piece.getRoom().getX() < lowestCoords[0]) {
                lowestCoords[0] = piece.getRoom().getX();
            }
            if (piece.getRoom().getZ() < lowestCoords[1]) {
                lowestCoords[1] = piece.getRoom().getZ();
            }
            if (piece.getRoom().getX() > highestCoords[0]) {
                highestCoords[0] = piece.getRoom().getX();
            }
            if (piece.getRoom().getZ() <= highestCoords[1]) continue;
            highestCoords[1] = piece.getRoom().getZ();
        }
        int count = 0;
        for (void x = lowestCoords[0]; x <= highestCoords[0]; x += builder.getPieceWidth()) {
            for (void z = lowestCoords[1]; z <= highestCoords[1]; z += builder.getPieceWidth()) {
                if (!builder.getPieces().containsKey(new SimpleLocation((int)x, y, (int)z))) {
                    return false;
                }
                ++count;
            }
        }
        return count == builder.getPieces().size();
    }

    public static void placeTentRoof(@NotNull PlainsVillagePopulator plainsVillagePopulator, @NotNull Random rand, @NotNull PlainsVillageHouseJigsawBuilder builder) {
        Wall w;
        int breadth;
        int length;
        PopulatorDataAbstract data = builder.getCore().getPopData();
        int[] lowestCoords = null;
        int[] highestCoords = null;
        int y = 0;
        for (JigsawStructurePiece piece : builder.getPieces().values()) {
            if (lowestCoords == null) {
                y = piece.getRoom().getY();
                lowestCoords = new int[]{piece.getRoom().getX(), piece.getRoom().getZ()};
            }
            if (highestCoords == null) {
                highestCoords = new int[]{piece.getRoom().getX(), piece.getRoom().getZ()};
            }
            if (piece.getRoom().getX() < lowestCoords[0]) {
                lowestCoords[0] = piece.getRoom().getX();
            }
            if (piece.getRoom().getZ() < lowestCoords[1]) {
                lowestCoords[1] = piece.getRoom().getZ();
            }
            if (piece.getRoom().getX() > highestCoords[0]) {
                highestCoords[0] = piece.getRoom().getX();
            }
            if (piece.getRoom().getZ() <= highestCoords[1]) continue;
            highestCoords[1] = piece.getRoom().getZ();
        }
        Axis superiorAxis = highestCoords[0] - lowestCoords[0] > highestCoords[1] - lowestCoords[1] ? Axis.X : (highestCoords[0] - lowestCoords[0] < highestCoords[1] - lowestCoords[1] ? Axis.Z : (new Axis[]{Axis.X, Axis.Z})[rand.nextInt(1)]);
        lowestCoords[0] = lowestCoords[0] - 3;
        lowestCoords[1] = lowestCoords[1] - 3;
        highestCoords[0] = highestCoords[0] + 3;
        highestCoords[1] = highestCoords[1] + 3;
        if (superiorAxis == Axis.X) {
            length = highestCoords[0] - lowestCoords[0] + 5;
            breadth = highestCoords[1] - lowestCoords[1] + 3;
            w = new Wall(new SimpleBlock(data, highestCoords[0] + 2, y + 4, lowestCoords[1] - 1), BlockFace.WEST);
        } else {
            length = highestCoords[1] - lowestCoords[1] + 5;
            breadth = highestCoords[0] - lowestCoords[0] + 3;
            w = new Wall(new SimpleBlock(data, lowestCoords[0] - 1, y + 4, lowestCoords[1] - 2), BlockFace.SOUTH);
        }
        for (int i = 0; i < length; ++i) {
            Wall target = w;
            for (int right = 0; right < breadth; ++right) {
                if (i == 2 || i == length - 3) {
                    Material bottom = PlainsVillageRoofHandler.getLowestMaterial(target);
                    target.downUntilSolid(new Random(), bottom);
                }
                if (right != 0 && right != breadth - 1) {
                    if (i == 0) {
                        new TrapdoorBuilder(plainsVillagePopulator.woodTrapdoor).setHalf(Bisected.Half.TOP).setOpen(true).setFacing(target.getDirection().getOppositeFace()).apply(target.getDown());
                    } else if (i == length - 1) {
                        new TrapdoorBuilder(plainsVillagePopulator.woodTrapdoor).setHalf(Bisected.Half.TOP).setOpen(true).setFacing(target.getDirection()).apply(target.getDown());
                    } else {
                        new OrientableBuilder(plainsVillagePopulator.woodLog).setAxis(superiorAxis).apply(target.getDown().get());
                    }
                }
                Material[] stairType = new Material[]{plainsVillagePopulator.woodStairs};
                Material[] slabType = new Material[]{Material.COBBLESTONE_SLAB, Material.MOSSY_COBBLESTONE_SLAB};
                if (right == 0 || right == breadth - 1 || i == 0 || i == length - 1) {
                    stairType = new Material[]{Material.COBBLESTONE_STAIRS, Material.MOSSY_COBBLESTONE_STAIRS};
                }
                if (breadth % 2 == 1) {
                    if (right > breadth / 2) {
                        new StairBuilder(stairType).setFacing(BlockUtils.getLeft(target.getDirection())).apply(target);
                        target = target.getRight().getDown();
                        continue;
                    }
                    if (right < breadth / 2) {
                        new StairBuilder(stairType).setFacing(BlockUtils.getRight(target.getDirection())).apply(target);
                        target = target.getRight().getUp();
                        continue;
                    }
                    target.setType(slabType);
                    target = target.getRight().getDown();
                    continue;
                }
                if (right == breadth / 2 - 1) {
                    new StairBuilder(stairType).setFacing(BlockUtils.getRight(target.getDirection())).apply(target);
                    target = target.getRight();
                    continue;
                }
                if (right >= breadth / 2) {
                    new StairBuilder(stairType).setFacing(BlockUtils.getLeft(target.getDirection())).apply(target);
                    target = target.getRight().getDown();
                    continue;
                }
                if (right >= breadth / 2) continue;
                new StairBuilder(stairType).setFacing(BlockUtils.getRight(target.getDirection())).apply(target);
                target = target.getRight().getUp();
            }
            w = w.getFront();
        }
    }

    @Nullable
    private static Material getLowestMaterial(@NotNull Wall w) {
        Wall other = w.findFloor(10);
        if (other != null) {
            return other.getType();
        }
        return null;
    }

    public static void placeStandardRoof(@NotNull PlainsVillagePopulator plainsVillagePopulator, @NotNull PlainsVillageHouseJigsawBuilder builder) {
        int z;
        int x;
        int[] upperCorner;
        int[] lowerCorner;
        int depth;
        PopulatorDataAbstract data = builder.getCore().getPopData();
        Material[] solidMat = new Material[]{plainsVillagePopulator.woodPlank};
        Material[] stairMat = new Material[]{plainsVillagePopulator.woodStairs};
        if (builder.getVariant() == PlainsVillageHouseVariant.CLAY) {
            solidMat = new Material[]{Material.COBBLESTONE, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE};
            stairMat = new Material[]{Material.COBBLESTONE_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_COBBLESTONE_STAIRS};
        }
        for (JigsawStructurePiece piece : builder.getPieces().values()) {
            for (depth = -2; depth <= 0; ++depth) {
                lowerCorner = piece.getRoom().getLowerCorner(depth);
                upperCorner = piece.getRoom().getUpperCorner(depth);
                for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
                    for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                        data.setType(x, piece.getRoom().getY() + piece.getRoom().getHeight() + 3 + depth, z, GenUtils.randChoice(solidMat));
                    }
                }
            }
        }
        for (JigsawStructurePiece piece : builder.getPieces().values()) {
            for (depth = -2; depth <= 0; ++depth) {
                lowerCorner = piece.getRoom().getLowerCorner(depth);
                upperCorner = piece.getRoom().getUpperCorner(depth);
                for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
                    block7: for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                        SimpleBlock target = new SimpleBlock(data, x, piece.getRoom().getY() + piece.getRoom().getHeight() + 3 + depth, z);
                        if (target.getType() != Material.COBBLESTONE && target.getType() != plainsVillagePopulator.woodPlank && target.getType() != Material.MOSSY_COBBLESTONE) continue;
                        for (BlockFace face : BlockUtils.directBlockFaces) {
                            if (target.getRelative(face).isSolid()) continue;
                            new StairBuilder(stairMat).setFacing(face.getOppositeFace()).apply(target);
                            BlockUtils.correctSurroundingStairData(target);
                            continue block7;
                        }
                    }
                }
            }
        }
    }
}

