/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.villagehouse.farmhouse;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.villagehouse.VillageHousePopulator;
import org.terraform.structure.villagehouse.farmhouse.FarmhouseSchematicParser;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.WoodUtils;
import org.terraform.utils.noise.FastNoise;

public class FarmhousePopulator
extends VillageHousePopulator {
    @Override
    public void populate(@NotNull TerraformWorld tw, @NotNull PopulatorDataAbstract data) {
        if (!TConfig.areStructuresEnabled()) {
            return;
        }
        MegaChunk mc = new MegaChunk(data.getChunkX(), data.getChunkZ());
        int[] coords = mc.getCenterBiomeSectionBlockCoords();
        int x = coords[0];
        int z = coords[1];
        int height = GenUtils.getHighestGround(data, x, z);
        this.spawnFarmHouse(tw, this.getHashedRandom(tw, data.getChunkX(), data.getChunkZ()), data, x, height + 1, z);
    }

    public void spawnFarmHouse(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        if (!TConfig.areStructuresEnabled()) {
            return;
        }
        try {
            BiomeBank biome = tw.getBiomeBank(x, z);
            TerraSchematic farmHouse = TerraSchematic.load("farmhouse", new SimpleBlock(data, x, y += GenUtils.randInt(random, 1, 3), z));
            farmHouse.parser = new FarmhouseSchematicParser(biome, random, data);
            farmHouse.setFace(BlockUtils.getDirectBlockFace(random));
            farmHouse.apply();
            TerraformGeneratorPlugin.logger.info("Spawning farmhouse at " + x + "," + y + "," + z + " with rotation of " + String.valueOf(farmHouse.getFace()));
            data.addEntity(x, y + 1, z, EntityType.VILLAGER);
            data.addEntity(x, y + 1, z, EntityType.VILLAGER);
            data.addEntity(x, y + 1, z, EntityType.CAT);
            for (int nx = -9; nx <= 9; ++nx) {
                for (int nz = -9; nz <= 9; ++nz) {
                    if (data.getType(x + nx, y - 1, z + nz).toString().contains("PLANKS") || data.getType(x + nx, y - 1, z + nz).toString().contains("STONE_BRICKS")) {
                        BlockUtils.setDownUntilSolid(x + nx, y - 2, z + nz, data, Material.COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
                        continue;
                    }
                    if (!data.getType(x + nx, y - 1, z + nz).toString().contains("LOG")) continue;
                    BlockUtils.setDownUntilSolid(x + nx, y - 2, z + nz, data, data.getType(x + nx, y - 1, z + nz));
                }
            }
            Wall w = new Wall(new SimpleBlock(data, x, y - 1, z), farmHouse.getFace()).getRight();
            for (int i = 0; i < 7; ++i) {
                w = w.getFront();
            }
            while (!w.isSolid() || w.getType().toString().contains("PLANKS")) {
                Stairs stairs = (Stairs)Bukkit.createBlockData((Material)GenUtils.randChoice(random, new Material[]{Material.COBBLESTONE_STAIRS, Material.COBBLESTONE_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_COBBLESTONE_STAIRS}));
                stairs.setFacing(w.getDirection().getOppositeFace());
                w.getRight().setBlockData((BlockData)stairs);
                w.setBlockData((BlockData)stairs);
                w.getLeft().setBlockData((BlockData)stairs);
                w.getLeft().getLeft().getUp().downUntilSolid(random, WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.LOG));
                w.getLeft().getLeft().getUp(2).setType(GenUtils.randChoice(random, new Material[]{Material.COBBLESTONE_WALL, Material.COBBLESTONE_WALL, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
                w.getRight().getRight().getUp().downUntilSolid(random, WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.LOG));
                w.getRight().getRight().getUp(2).setType(GenUtils.randChoice(random, new Material[]{Material.COBBLESTONE_WALL, Material.COBBLESTONE_WALL, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
                w = w.getFront().getDown();
            }
            this.createFields(tw, biome, random, data, x, y, z);
        }
        catch (Throwable e2) {
            TerraformGeneratorPlugin.logger.error("Something went wrong trying to place farmhouse at " + x + "," + y + "," + z + "!");
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
    }

    private void placeLamp(TerraformWorld tw, BiomeBank biome, @NotNull Random rand, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        if (!TConfig.areDecorationsEnabled()) {
            return;
        }
        SimpleBlock b2 = new SimpleBlock(data, x, y, z);
        b2.setType(GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS}));
        b2.getUp().setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
        b2.getUp(2).setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
        b2.getUp(3).setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.MOSSY_COBBLESTONE}));
        b2.getUp(4).setType(Material.CAMPFIRE);
        b2.getUp(5).setType(GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS}));
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Slab tSlab = (Slab)Bukkit.createBlockData((Material)GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB}));
            tSlab.setType(Slab.Type.TOP);
            b2.getRelative(face).getUp(3).setBlockData((BlockData)tSlab);
            b2.getRelative(face).getUp(4).setType(GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL}));
            b2.getRelative(face).getUp(5).setType(GenUtils.randChoice(rand, new Material[]{Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB}));
        }
    }

    private void createFields(@NotNull TerraformWorld tw, @NotNull BiomeBank biome, @NotNull Random random, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        FastNoise fieldNoise = new FastNoise(tw.getHashedRand(x, y, z, 23L).nextInt(225));
        fieldNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        fieldNoise.SetFrequency(0.05f);
        FastNoise radiusNoise = new FastNoise(tw.getHashedRand(x, y, z, 23L).nextInt(225));
        radiusNoise.SetNoiseType(FastNoise.NoiseType.Cubic);
        radiusNoise.SetFrequency(0.09f);
        Material cropOne = Material.WHEAT;
        Material cropTwo = Material.CARROTS;
        if (BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z).getTemperature() <= -2.0f) {
            cropOne = Material.POTATOES;
            cropTwo = Material.BEETROOTS;
        }
        for (int nx = -50; nx <= 50; ++nx) {
            for (int nz = -50; nz <= 50; ++nz) {
                BlockFace[] fl;
                BlockFace face;
                int n;
                int height = GenUtils.getTrueHighestBlock(data, x + nx, z + nz);
                if (!BlockUtils.isDirtLike(data.getType(x + nx, height, z + nz)) || data.getType(x + nx, height + 1, z + nz) != Material.AIR) continue;
                double noise = fieldNoise.GetNoise(nx + x, nz + z);
                double dist = Math.pow(nx, 2.0) + Math.pow(nz, 2.0);
                double multiplier = Math.pow(1.0 / (dist - 2500.0) + 1.0, 255.0);
                if (multiplier < 0.0 || dist > 2500.0 + (double)radiusNoise.GetNoise(nx, nz) * 500.0) {
                    multiplier = 0.0;
                }
                noise *= multiplier;
                if (dist < 2500.0 && GenUtils.chance(random, 1, 300)) {
                    data.setType(x + nx, height + 1, z + nz, Material.COMPOSTER);
                    continue;
                }
                if (noise < -0.2) {
                    if (GenUtils.chance(random, 1, 15)) {
                        data.setType(nx + x, height, nz + z, Material.WATER);
                        BlockFace[] blockFaceArray = BlockUtils.directBlockFaces;
                        int n2 = blockFaceArray.length;
                        for (n = 0; n < n2; ++n) {
                            face = blockFaceArray[n];
                            BlockUtils.setDownUntilSolid(nx + x + face.getModX(), height, nz + z + face.getModZ(), data, Material.FARMLAND);
                        }
                        continue;
                    }
                    fl = (BlockFace[])Bukkit.createBlockData((Material)Material.FARMLAND);
                    fl.setMoisture(fl.getMaximumMoisture());
                    data.setBlockData(nx + x, height, nz + z, (BlockData)fl);
                    Ageable crop = (Ageable)Bukkit.createBlockData((Material)cropOne);
                    crop.setAge(GenUtils.randInt(random, 0, crop.getMaximumAge()));
                    if (data.getType(nx + x, height + 1, nz + z).isSolid()) continue;
                    data.setBlockData(nx + x, height + 1, nz + z, (BlockData)crop);
                    continue;
                }
                if (noise > 0.2) {
                    if (GenUtils.chance(random, 1, 15)) {
                        data.setType(nx + x, height, nz + z, Material.WATER);
                        fl = BlockUtils.directBlockFaces;
                        int crop = fl.length;
                        for (n = 0; n < crop; ++n) {
                            face = fl[n];
                            BlockUtils.setDownUntilSolid(nx + x + face.getModX(), height, nz + z + face.getModZ(), data, Material.FARMLAND);
                        }
                        continue;
                    }
                    fl = (Farmland)Bukkit.createBlockData((Material)Material.FARMLAND);
                    fl.setMoisture(fl.getMaximumMoisture());
                    data.setBlockData(nx + x, height, nz + z, (BlockData)fl);
                    Ageable crop = (Ageable)Bukkit.createBlockData((Material)cropTwo);
                    crop.setAge(GenUtils.randInt(random, 0, crop.getMaximumAge()));
                    data.setBlockData(nx + x, height + 1, nz + z, (BlockData)crop);
                    continue;
                }
                if (Math.abs(noise) < 0.2 && Math.abs(noise) > 0.1) {
                    BlockUtils.setPersistentLeaves(data, nx + x, height + 1, nz + z, WoodUtils.getWoodForBiome(biome, WoodUtils.WoodType.LEAVES));
                    if (!GenUtils.chance(random, 1, 100)) continue;
                    this.placeLamp(tw, biome, random, data, nx + x, height + 1, z + nz);
                    continue;
                }
                if (!GenUtils.chance(random, (int)(100.0 * Math.pow(multiplier, 3.0)), 100)) continue;
                data.setType(nx + x, height, nz + z, GenUtils.randChoice(random, new Material[]{Material.COBBLESTONE, Material.MOSSY_COBBLESTONE}));
            }
        }
    }
}

