/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.tree.FractalLeaves;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.NewFractalTreeBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.V_1_19;
import org.terraform.utils.version.V_1_21_5;
import org.terraform.utils.version.Version;

public class FractalTypes {

    public static enum MushroomCap {
        ROUND,
        FLAT,
        FUNNEL,
        POINTY;

    }

    public static enum Mushroom {
        TINY_BROWN_MUSHROOM,
        TINY_RED_MUSHROOM,
        SMALL_RED_MUSHROOM,
        SMALL_POINTY_RED_MUSHROOM,
        SMALL_BROWN_MUSHROOM,
        MEDIUM_BROWN_MUSHROOM,
        MEDIUM_RED_MUSHROOM,
        MEDIUM_BROWN_FUNNEL_MUSHROOM,
        GIANT_BROWN_MUSHROOM,
        GIANT_BROWN_FUNNEL_MUSHROOM,
        GIANT_RED_MUSHROOM;

    }

    public static enum Tree {
        FOREST(new NewFractalTreeBuilder().setLengthVariance(2.0f).setOriginalTrunkLength(12).setInitialBranchRadius(1.6f).setMinBranchHorizontalComponent(0.7).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 1.7f))).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() / 1.7f)).setBranchSpawnChance(0.15).setCrownBranches(4).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.3f, 3).setRadius(4.0f).setRadiusY(2.0f)).setSpawnBees(true).setPrePlacement((random, block) -> Tree.leafLitter(random, block, 6.0f)), new NewFractalTreeBuilder().setOriginalTrunkLength(18).setInitialBranchRadius(2.0f).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 2.0f))).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() - 7.0f)).setBranchSpawnChance(0.2).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.3f, 2).setRadius(4.0f).setRadiusY(2.5f)).setSpawnBees(true).setPrePlacement((random, block) -> Tree.leafLitter(random, block, 6.0f)), new NewFractalTreeBuilder().setOriginalTrunkLength(18).setInitialBranchRadius(2.0f).setCrownBranches(5).setMaxDepth(2).setMinBranchHorizontalComponent(0.7).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 1.5f))).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() / 2.0f)).setBranchSpawnChance(0.2).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.3f, 1).setRadius(4.0f).setRadiusY(2.5f)).setSpawnBees(true).setPrePlacement((random, block) -> Tree.leafLitter(random, block, 6.0f))),
        NORMAL_SMALL(new NewFractalTreeBuilder().setTreeRootThreshold(0).setOriginalTrunkLength(4).setLengthVariance(1.0f).setMaxDepth(1).setCrownBranches(3).setInitialBranchRadius(0.8f).setNoisePriority(0.05f).setFirstEnd(1.0f).setMinBranchHorizontalComponent(1.2).setMaxBranchHorizontalComponent(2.0).setMaxInitialNormalDelta(0.0).setMinInitialNormalDelta(0.0).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() - branchRatio.floatValue() * 0.2f)).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() - 2.0f)).setMinBranchSpawnLength(0.8f).setBranchSpawnChance(0.1).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.3f, 1).setRadius(3.0f).setRadiusY(3.0f).setLeafNoiseFrequency(0.5f).setSemiSphereLeaves(true).setMaterial(Material.OAK_LEAVES)).setPrePlacement((random, block) -> Tree.leafLitter(random, block, 3.5f))),
        AZALEA_TOP(new NewFractalTreeBuilder().setTreeRootThreshold(0).setOriginalTrunkLength(6).setLengthVariance(1.0f).setMaxDepth(1).setCrownBranches(3).setInitialBranchRadius(0.8f).setNoisePriority(0.05f).setFirstEnd(1.0f).setMinBranchHorizontalComponent(1.2).setMaxBranchHorizontalComponent(2.0).setMaxInitialNormalDelta(0.0).setMinInitialNormalDelta(0.0).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() - branchRatio.floatValue() * 0.2f)).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() - 2.0f)).setMinBranchSpawnLength(0.8f).setBranchSpawnChance(0.1).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.5f, 2).setRadius(4.0f).setRadiusY(1.5f).setLeafNoiseFrequency(0.2f).setMaterial(Material.AZALEA_LEAVES, Material.FLOWERING_AZALEA_LEAVES))),
        TAIGA_BIG(new NewFractalTreeBuilder().setFirstEnd(1.0f).setTreeRootThreshold(2).setTreeRootMultiplier(1.3f).setBranchMaterial(Material.SPRUCE_LOG).setRootMaterial(Material.SPRUCE_WOOD).setOriginalTrunkLength(30).setLengthVariance(2.0f).setInitialBranchRadius(1.8f).setBranchDecrement((currentBranchLength, totalTreeHeight) -> {
            if (currentBranchLength.floatValue() < 10.0f) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(0.3f * Math.max(0.0f, 30.0f - totalTreeHeight.floatValue()));
        }).setCrownBranches(0).setMaxDepth(3).setMaxInitialNormalDelta(0.1).setMinInitialNormalDelta(-0.1).setMinBranchHorizontalComponent(1.5).setMaxBranchHorizontalComponent(2.0).setBranchSpawnChance(1.0).setRandomBranchSpawnCooldown(4.0f).setRandomBranchClusterCount(5).setRandomBranchSegmentCount(5).setMinBranchSpawnLength(0.3f).setLeafSpawnDepth(0).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.4f, 2).setConeLeaves(true).setRadius(1.5f).setRadiusY(2.3f).setLeafNoiseFrequency(0.3f).setMaterial(Material.SPRUCE_LEAVES)).setPrePlacement((random, block) -> BlockUtils.lambdaCircularPatch(random.nextInt(132798), 5.0f, block, b2 -> {
            if (BlockUtils.isDirtLike(b2.getType())) {
                b2.setType(Material.PODZOL);
            }
        }))),
        TAIGA_SMALL(new NewFractalTreeBuilder().setTreeRootThreshold(0).setBranchMaterial(Material.SPRUCE_LOG).setOriginalTrunkLength(16).setLengthVariance(1.0f).setInitialBranchRadius(0.8f).setGetBranchWidth((initialBranchWidth, branchRatio) -> initialBranchWidth).setBranchDecrement((currentBranchLength, totalTreeHeight) -> {
            if (currentBranchLength.floatValue() < 10.0f) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(Math.min(4.0f, 0.5f * Math.max(0.0f, 12.0f - totalTreeHeight.floatValue())));
        }).setCrownBranches(0).setMaxDepth(3).setMaxInitialNormalDelta(0.1).setMinInitialNormalDelta(-0.1).setMinBranchHorizontalComponent(1.5).setMaxBranchHorizontalComponent(2.0).setBranchSpawnChance(1.0).setRandomBranchSpawnCooldown(4.0f).setRandomBranchClusterCount(4).setRandomBranchSegmentCount(4).setMinBranchSpawnLength(0.2f).setLeafSpawnDepth(0).setRootMaterial(Material.SPRUCE_WOOD).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.4f, 1).setConeLeaves(true).setRadius(1.3f).setRadiusY(2.0f).setMaterial(Material.SPRUCE_LEAVES)).setPrePlacement((random, block) -> BlockUtils.lambdaCircularPatch(random.nextInt(132798), 3.5f, block, b2 -> {
            if (BlockUtils.isDirtLike(b2.getType())) {
                b2.setType(Material.PODZOL);
            }
        })), new NewFractalTreeBuilder().setTreeRootThreshold(0).setBranchMaterial(Material.SPRUCE_LOG).setOriginalTrunkLength(18).setLengthVariance(3.0f).setInitialBranchRadius(0.8f).setGetBranchWidth((initialBranchWidth, branchRatio) -> initialBranchWidth).setBranchDecrement((currentBranchLength, totalTreeHeight) -> {
            if (currentBranchLength.floatValue() < 10.0f) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(Math.min(4.0f, 0.5f * Math.max(0.0f, 12.0f - totalTreeHeight.floatValue())));
        }).setCrownBranches(0).setMaxDepth(3).setMaxInitialNormalDelta(0.0).setMinInitialNormalDelta(0.0).setMinBranchHorizontalComponent(1.5).setMaxBranchHorizontalComponent(2.0).setBranchSpawnChance(0.7).setRandomBranchSpawnCooldown(2.0f).setRandomBranchClusterCount(4).setRandomBranchSegmentCount(4).setMinBranchSpawnLength(0.4f).setLeafSpawnDepth(0).setRootMaterial(Material.SPRUCE_WOOD).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.4f, 1).setConeLeaves(true).setRadius(1.3f).setRadiusY(3.0f).setMaterial(Material.SPRUCE_LEAVES)).setPrePlacement((random, block) -> BlockUtils.lambdaCircularPatch(random.nextInt(132798), 3.5f, block, b2 -> {
            if (BlockUtils.isDirtLike(b2.getType())) {
                b2.setType(Material.PODZOL);
            }
        }))),
        SCARLET_BIG,
        SCARLET_SMALL,
        SAVANNA_SMALL,
        SAVANNA_BIG,
        WASTELAND_BIG,
        SWAMP_TOP(new NewFractalTreeBuilder().setOriginalTrunkLength(13).setLengthVariance(2.0f).setMaxDepth(4).setInitialBranchRadius(2.0f).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 2.0f))).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() / 1.7f)).setMinBranchHorizontalComponent((double)0.9f).setMaxBranchHorizontalComponent((double)1.3f).setBranchSpawnChance(0.2).setBranchMaterial(V_1_19.MANGROVE_LOG).setRootMaterial(V_1_19.MANGROVE_ROOTS).setTreeRootMultiplier(2.0f).setTreeRootThreshold(3).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.4f, 2).setRadius(4.0f).setRadiusY(1.5f).setMaterial(V_1_19.MANGROVE_LEAVES).setMangrovePropagules(true))),
        BIRCH_BIG,
        BIRCH_SMALL,
        CHERRY_SMALL,
        CHERRY_THICK,
        JUNGLE_BIG,
        JUNGLE_SMALL,
        JUNGLE_EXTRA_SMALL,
        COCONUT_TOP,
        DARK_OAK_SMALL(new NewFractalTreeBuilder().setOriginalTrunkLength(7).setLengthVariance(1.0f).setInitialBranchRadius(2.7f).setCrownBranches(3).setMinBranchSpawnLength(0.2f).setMaxDepth(4).setBranchSpawnChance(0.0).setMinBranchHorizontalComponent(0.5).setMaxBranchHorizontalComponent((double)0.9f).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 2.0f))).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() - 1.0f)).setBranchSpawnChance(0.05).setTreeRootMultiplier(1.3f).setTreeRootThreshold(3).setRootMaterial(Material.DARK_OAK_WOOD).setBranchMaterial(Material.DARK_OAK_LOG).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.3f, 1).setRadius(4.5f).setRadiusY(2.5f).setMaterial(Material.DARK_OAK_LEAVES))),
        DARK_OAK_BIG_TOP(new NewFractalTreeBuilder().setOriginalTrunkLength(12).setLengthVariance(1.0f).setInitialBranchRadius(2.7f).setCrownBranches(3).setMinBranchSpawnLength(0.2f).setMaxDepth(3).setBranchSpawnChance(0.0).setMinBranchHorizontalComponent(-1.2).setMaxBranchHorizontalComponent((double)1.2f).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 3.0f))).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() - 0.5f)).setRandomBranchClusterCount(3).setBranchSpawnChance(0.05).setTreeRootMultiplier(1.6f).setTreeRootThreshold(5).setRootMaterial(Material.DARK_OAK_WOOD).setBranchMaterial(Material.DARK_OAK_LOG).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.3f, 2).setRadius(4.0f).setRadiusY(2.5f).setMaterial(Material.DARK_OAK_LEAVES))),
        FROZEN_TREE_BIG,
        FROZEN_TREE_SMALL,
        FIRE_CORAL,
        HORN_CORAL,
        BRAIN_CORAL,
        TUBE_CORAL,
        BUBBLE_CORAL,
        GIANT_PUMPKIN,
        ANDESITE_PETRIFIED_SMALL,
        GRANITE_PETRIFIED_SMALL,
        DIORITE_PETRIFIED_SMALL;

        private final NewFractalTreeBuilder[] builders;

        private Tree() {
            this.builders = new NewFractalTreeBuilder[0];
        }

        private Tree(NewFractalTreeBuilder ... builder) {
            this.builders = builder;
        }

        public boolean build(@NotNull TerraformWorld tw, @NotNull SimpleBlock base) {
            return this.build(tw, base, null);
        }

        public boolean build(@NotNull TerraformWorld tw, @NotNull SimpleBlock base, @Nullable Consumer<NewFractalTreeBuilder> treeMutator) {
            if (this.builders.length > 0) {
                NewFractalTreeBuilder b2 = Objects.requireNonNull(GenUtils.choice(tw.getHashedRand(base.getX(), base.getY(), base.getZ()), this.builders));
                if (treeMutator != null) {
                    try {
                        b2 = (NewFractalTreeBuilder)b2.clone();
                        treeMutator.accept(b2);
                    }
                    catch (CloneNotSupportedException e2) {
                        TerraformGeneratorPlugin.logger.stackTrace(e2);
                        return b2.build(tw, base);
                    }
                }
                return b2.build(tw, base);
            }
            return new FractalTreeBuilder(this).build(tw, base);
        }

        private static void leafLitter(Random random, SimpleBlock base, float radius) {
            if (!Version.VERSION.isAtLeast(Version.v1_21_5)) {
                return;
            }
            BlockUtils.lambdaCircularPatch(random.nextInt(8903245), radius, base, b2 -> {
                if (b2.getUp().getType() == Material.AIR && random.nextInt(6) == 0) {
                    V_1_21_5.leafLitter(random, b2.getPopData(), b2.getX(), b2.getY() + 1, b2.getZ());
                }
            });
        }
    }
}

